/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

public class GrowthByteBuffer {
    private static final int DefaultBufferSize = 16384;
    private byte[][] buffer;
    private int position;
    private int limit;

    public GrowthByteBuffer() {
        this(16384);
    }

    public GrowthByteBuffer(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("BufferSize most be 1 or more.");
        }
        this.buffer = new byte[16][];
        this.buffer[0] = new byte[n];
        this.position = 0;
        this.limit = -1;
    }

    public void write(int n) {
        this.grow(this.position);
        this.buffer[this.position / this.buffer[0].length][this.position % this.buffer[0].length] = (byte)n;
        ++this.position;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.grow(this.position + n2 - 1);
        while (0 < n2) {
            int n3 = Math.min((this.position / this.buffer[0].length + 1) * this.buffer[0].length, this.position + n2) - this.position;
            System.arraycopy(byArray, n, this.buffer[this.position / this.buffer[0].length], this.position % this.buffer[0].length, n3);
            this.position += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public int read() {
        if (this.position <= this.limit) {
            return this.buffer[this.position / this.buffer[0].length][this.position++ % this.buffer[0].length] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.position <= this.limit) {
            int n3;
            int n4 = 0;
            while (0 < n2 && 0 < (n3 = Math.min(Math.min((this.position / this.buffer[0].length + 1) * this.buffer[0].length, this.position + n2), this.limit + 1) - this.position)) {
                System.arraycopy(this.buffer[this.position / this.buffer[0].length], this.position % this.buffer[0].length, byArray, n, n3);
                this.position += n3;
                n += n3;
                n4 += n3;
                n2 -= n3;
            }
            return n4;
        }
        if (0 < n2) {
            return -1;
        }
        return 0;
    }

    public int length() {
        return this.limit + 1;
    }

    public void setLength(int n) {
        if (this.limit < --n) {
            this.grow(n);
        } else {
            this.limit = n;
        }
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void seek(int n) {
        this.setPosition(n);
    }

    private void grow(int n) {
        if (this.limit < n) {
            int n2;
            for (n2 = 0; n2 < this.buffer.length && this.buffer[n2] != null; ++n2) {
            }
            if (n2 * this.buffer[0].length < ++n) {
                int n3 = n / this.buffer[0].length + (n % this.buffer[0].length == 0 ? 0 : 1);
                if (this.buffer.length < n3) {
                    byte[][] byArray = this.buffer;
                    this.buffer = new byte[Math.max(byArray.length * 2, n3)][];
                    for (int i = 0; i < n2; ++i) {
                        this.buffer[i] = byArray[i];
                    }
                }
                for (int i = n2; i < n3; ++i) {
                    this.buffer[i] = new byte[this.buffer[0].length];
                }
            }
            this.limit = n - 1;
        }
    }
}

