/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.framework.exception.SQLRuntimeException;

public class StatementUtil {
    protected StatementUtil() {
    }

    public static boolean execute(Statement statement, String sql) throws SQLRuntimeException {
        try {
            return statement.execute(sql);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setFetchSize(Statement statement, int fetchSize) throws SQLRuntimeException {
        try {
            statement.setFetchSize(fetchSize);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setMaxRows(Statement statement, int maxRows) throws SQLRuntimeException {
        try {
            statement.setMaxRows(maxRows);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setQueryTimeout(Statement statement, int queryTimeout) throws SQLRuntimeException {
        try {
            statement.setQueryTimeout(queryTimeout);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void close(Statement statement) throws SQLRuntimeException {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static ResultSet getResultSet(Statement statement) throws SQLRuntimeException {
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static int getUpdateCount(Statement statement) {
        try {
            return statement.getUpdateCount();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

