/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.db.allcommon;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.DBMetaProvider;
import org.codelibs.robot.dbflute.exception.DBMetaNotFoundException;
import org.codelibs.robot.dbflute.helper.StringKeyMap;
import org.codelibs.robot.dbflute.util.DfAssertUtil;

public class DBMetaInstanceHandler
implements DBMetaProvider {
    protected static final Map<String, DBMeta> _tableDbNameInstanceMap = DBMetaInstanceHandler.newHashMap();
    protected static final Map<Class<?>, DBMeta> _entityTypeInstanceMap = DBMetaInstanceHandler.newHashMap();
    protected static final Map<String, String> _tableDbNameClassNameMap;
    protected static final Map<String, String> _tableDbNameFlexibleMap;
    protected static final DBMetaProvider _provider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DBMeta> getUnmodifiableDBMetaMap() {
        DBMetaInstanceHandler.initializeDBMetaMap();
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            return Collections.unmodifiableMap(_tableDbNameInstanceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initializeDBMetaMap() {
        if (DBMetaInstanceHandler.isInitialized()) {
            return;
        }
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            for (String tableDbName : _tableDbNameClassNameMap.keySet()) {
                DBMetaInstanceHandler.findDBMeta(tableDbName);
            }
            if (!DBMetaInstanceHandler.isInitialized()) {
                String msg = "Failed to initialize tableDbNameInstanceMap: " + _tableDbNameInstanceMap;
                throw new IllegalStateException(msg);
            }
        }
    }

    protected static boolean isInitialized() {
        return _tableDbNameInstanceMap.size() == _tableDbNameClassNameMap.size();
    }

    public static DBMetaProvider getProvider() {
        return _provider;
    }

    @Override
    public DBMeta provideDBMeta(String tableFlexibleName) {
        return DBMetaInstanceHandler.byTableFlexibleName(tableFlexibleName);
    }

    @Override
    public DBMeta provideDBMeta(Class<?> entityType) {
        return DBMetaInstanceHandler.byEntityType(entityType);
    }

    @Override
    public DBMeta provideDBMetaChecked(String tableFlexibleName) {
        return DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
    }

    @Override
    public DBMeta provideDBMetaChecked(Class<?> entityType) {
        return DBMetaInstanceHandler.findDBMeta(entityType);
    }

    public static DBMeta findDBMeta(String tableFlexibleName) {
        DBMeta dbmeta = DBMetaInstanceHandler.byTableFlexibleName(tableFlexibleName);
        if (dbmeta == null) {
            String msg = "The DB meta was not found by the table flexible name: key=" + tableFlexibleName;
            throw new DBMetaNotFoundException(msg);
        }
        return dbmeta;
    }

    public static DBMeta findDBMeta(Class<?> entityType) {
        DBMeta dbmeta = DBMetaInstanceHandler.byEntityType(entityType);
        if (dbmeta == null) {
            String msg = "The DB meta was not found by the entity type: key=" + entityType;
            throw new DBMetaNotFoundException(msg);
        }
        return dbmeta;
    }

    protected static DBMeta byTableFlexibleName(String tableFlexibleName) {
        DBMetaInstanceHandler.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        String tableDbName = _tableDbNameFlexibleMap.get(tableFlexibleName);
        if (tableDbName == null) {
            tableDbName = DBMetaInstanceHandler.retryByNormalizedName(tableFlexibleName);
        }
        return tableDbName != null ? DBMetaInstanceHandler.byTableDbName(tableDbName) : null;
    }

    protected static String retryByNormalizedName(String tableFlexibleName) {
        String tableDbName = null;
        String pureName = DBMetaInstanceHandler.normalizeTableFlexibleName(tableFlexibleName);
        String schema = DBMetaInstanceHandler.extractSchemaIfExists(tableFlexibleName);
        if (schema != null) {
            tableDbName = _tableDbNameFlexibleMap.get(schema + "." + pureName);
        }
        if (tableDbName == null) {
            tableDbName = _tableDbNameFlexibleMap.get(pureName);
        }
        return tableDbName;
    }

    protected static String normalizeTableFlexibleName(String tableFlexibleName) {
        return DBMetaInstanceHandler.removeQuoteIfExists(DBMetaInstanceHandler.removeSchemaIfExists(tableFlexibleName));
    }

    protected static String removeQuoteIfExists(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return DBMetaInstanceHandler.strip(name);
        }
        if (name.startsWith("[") && name.endsWith("]")) {
            return DBMetaInstanceHandler.strip(name);
        }
        return name;
    }

    protected static String removeSchemaIfExists(String name) {
        int dotLastIndex = name.lastIndexOf(".");
        return dotLastIndex >= 0 ? name.substring(dotLastIndex + ".".length()) : name;
    }

    protected static String extractSchemaIfExists(String name) {
        int dotLastIndex = name.lastIndexOf(".");
        return dotLastIndex >= 0 ? name.substring(0, dotLastIndex) : null;
    }

    protected static String strip(String name) {
        return name.substring(1, name.length() - 1);
    }

    protected static DBMeta byTableDbName(String tableDbName) {
        DBMetaInstanceHandler.assertStringNotNullAndNotTrimmedEmpty("tableDbName", tableDbName);
        return DBMetaInstanceHandler.getCachedDBMeta(tableDbName);
    }

    protected static DBMeta byEntityType(Class<?> entityType) {
        DBMetaInstanceHandler.assertObjectNotNull("entityType", entityType);
        return DBMetaInstanceHandler.getCachedDBMeta(entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DBMeta getCachedDBMeta(String tableDbName) {
        DBMeta dbmeta = _tableDbNameInstanceMap.get(tableDbName);
        if (dbmeta != null) {
            return dbmeta;
        }
        Map<String, DBMeta> map = _tableDbNameInstanceMap;
        synchronized (map) {
            dbmeta = _tableDbNameInstanceMap.get(tableDbName);
            if (dbmeta != null) {
                return dbmeta;
            }
            String dbmetaName = _tableDbNameClassNameMap.get(tableDbName);
            if (dbmetaName == null) {
                return null;
            }
            _tableDbNameInstanceMap.put(tableDbName, DBMetaInstanceHandler.toDBMetaInstance(dbmetaName));
            return _tableDbNameInstanceMap.get(tableDbName);
        }
    }

    protected static DBMeta toDBMetaInstance(String dbmetaName) {
        try {
            Class<?> dbmetaType = Class.forName(dbmetaName);
            Method method = dbmetaType.getMethod("getInstance", null);
            Object result = method.invoke(null, (Object[])null);
            return (DBMeta)result;
        }
        catch (Exception e) {
            String msg = "Failed to get the instance: " + dbmetaName;
            throw new IllegalStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DBMeta getCachedDBMeta(Class<?> entityType) {
        DBMeta dbmeta = _entityTypeInstanceMap.get(entityType);
        if (dbmeta != null) {
            return dbmeta;
        }
        Map<Class<?>, DBMeta> map = _entityTypeInstanceMap;
        synchronized (map) {
            dbmeta = _entityTypeInstanceMap.get(entityType);
            if (dbmeta != null) {
                return dbmeta;
            }
            if (Entity.class.isAssignableFrom(entityType)) {
                Entity entity = DBMetaInstanceHandler.newEntity(entityType);
                dbmeta = DBMetaInstanceHandler.getCachedDBMeta(entity.getTableDbName());
            }
            if (dbmeta == null) {
                return null;
            }
            _entityTypeInstanceMap.put(entityType, dbmeta);
            return _entityTypeInstanceMap.get(entityType);
        }
    }

    protected static Entity newEntity(Class<?> entityType) {
        try {
            return (Entity)entityType.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to new the instance: " + entityType;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected static void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    static {
        HashMap tmpMap = DBMetaInstanceHandler.newHashMap();
        tmpMap.put("ACCESS_RESULT", "org.codelibs.robot.db.bsentity.dbmeta.AccessResultDbm");
        tmpMap.put("ACCESS_RESULT_DATA", "org.codelibs.robot.db.bsentity.dbmeta.AccessResultDataDbm");
        tmpMap.put("URL_FILTER", "org.codelibs.robot.db.bsentity.dbmeta.UrlFilterDbm");
        tmpMap.put("URL_QUEUE", "org.codelibs.robot.db.bsentity.dbmeta.UrlQueueDbm");
        _tableDbNameClassNameMap = Collections.unmodifiableMap(tmpMap);
        _tableDbNameFlexibleMap = StringKeyMap.createAsFlexible();
        for (String tableDbName : _tableDbNameClassNameMap.keySet()) {
            _tableDbNameFlexibleMap.put(tableDbName, tableDbName);
        }
        _provider = new DBMetaInstanceHandler();
    }
}

