/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.bhv;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelibs.robot.dbflute.BehaviorSelector;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.bhv.BehaviorReadable;
import org.codelibs.robot.dbflute.bhv.InsertOption;
import org.codelibs.robot.dbflute.bhv.LoadReferrerOption;
import org.codelibs.robot.dbflute.bhv.NestedReferrerLoader;
import org.codelibs.robot.dbflute.bhv.ReferrerConditionSetupper;
import org.codelibs.robot.dbflute.bhv.ReferrerListHandler;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommand;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommandInvoker;
import org.codelibs.robot.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.codelibs.robot.dbflute.bhv.core.command.AbstractEntityCommand;
import org.codelibs.robot.dbflute.bhv.core.command.InsertEntityCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectCountCBCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectCursorCBCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectListCBCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectNextValCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectNextValSubCommand;
import org.codelibs.robot.dbflute.bhv.core.command.SelectScalarCBCommand;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.cbean.EntityRowHandler;
import org.codelibs.robot.dbflute.cbean.ListResultBean;
import org.codelibs.robot.dbflute.cbean.PagingBean;
import org.codelibs.robot.dbflute.cbean.PagingHandler;
import org.codelibs.robot.dbflute.cbean.PagingInvoker;
import org.codelibs.robot.dbflute.cbean.PagingResultBean;
import org.codelibs.robot.dbflute.cbean.ResultBeanBuilder;
import org.codelibs.robot.dbflute.cbean.ScalarQuery;
import org.codelibs.robot.dbflute.cbean.UnionQuery;
import org.codelibs.robot.dbflute.cbean.coption.CursorSelectOption;
import org.codelibs.robot.dbflute.cbean.coption.ScalarSelectOption;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClause;
import org.codelibs.robot.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.codelibs.robot.dbflute.cbean.sqlclause.orderby.OrderByElement;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.dbmeta.info.ForeignInfo;
import org.codelibs.robot.dbflute.dbmeta.info.ReferrerInfo;
import org.codelibs.robot.dbflute.dbmeta.info.RelationInfo;
import org.codelibs.robot.dbflute.exception.DangerousResultSizeException;
import org.codelibs.robot.dbflute.exception.FetchingOverSafetySizeException;
import org.codelibs.robot.dbflute.exception.IllegalBehaviorStateException;
import org.codelibs.robot.dbflute.exception.IllegalConditionBeanOperationException;
import org.codelibs.robot.dbflute.exception.PagingOverSafetySizeException;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.codelibs.robot.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.codelibs.robot.dbflute.optional.OptionalEntity;
import org.codelibs.robot.dbflute.optional.OptionalObjectExceptionThrower;
import org.codelibs.robot.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.util.DfCollectionUtil;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.codelibs.robot.dbflute.util.Srl;

public abstract class AbstractBehaviorReadable
implements BehaviorReadable {
    protected static final NestedReferrerLoader<?> EMPTY_LOADER = new NestedReferrerLoader<Entity>(){

        @Override
        public void withNestedReferrer(ReferrerListHandler<Entity> handler) {
            List emptyList = DfCollectionUtil.emptyList();
            handler.handle(emptyList);
        }
    };
    protected BehaviorCommandInvoker _behaviorCommandInvoker;
    protected BehaviorSelector _behaviorSelector;

    @Override
    public int readCount(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadCount(cb);
    }

    protected abstract int doReadCount(ConditionBean var1);

    @Override
    public Entity readEntity(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadEntity(cb);
    }

    protected abstract Entity doReadEntity(ConditionBean var1);

    protected <ENTITY> OptionalEntity<ENTITY> createOptionalEntity(ENTITY entity, final Object ... searchKey) {
        return new OptionalEntity<ENTITY>(entity, new OptionalObjectExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                AbstractBehaviorReadable.this.throwSelectEntityAlreadyDeletedException(searchKey);
            }
        });
    }

    @Override
    public Entity readEntityWithDeletedCheck(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadEntityWithDeletedCheck(cb);
    }

    protected abstract Entity doReadEntityWithDeletedCheck(ConditionBean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityInternally(CB cb, Class<ENTITY> entityType, InternalSelectEntityCallback<ENTITY, CB> callback) {
        List<ENTITY> ls;
        if (cb.hasSelectAllPossible() && cb.getFetchSize() != 1) {
            this.throwSelectEntityConditionNotFoundException(cb);
        }
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOne(cb);
        try {
            ls = callback.callbackSelectList(cb, entityType);
        }
        catch (DangerousResultSizeException e) {
            this.throwSelectEntityDuplicatedException("{over safetyMaxResultSize '1'}", cb, e);
            ENTITY ENTITY = null;
            return ENTITY;
        }
        finally {
            this.xrestoreSafetyResult(cb, preSafetyMaxResultSize);
        }
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityWithDeletedCheckInternally(CB cb, Class<ENTITY> entityType, final InternalSelectEntityWithDeletedCheckCallback<ENTITY, CB> callback) {
        ENTITY entity = this.helpSelectEntityInternally(cb, entityType, new InternalSelectEntityCallback<ENTITY, CB>(){

            @Override
            public List<ENTITY> callbackSelectList(CB cb, Class<ENTITY> entityType) {
                return callback.callbackSelectList(cb, entityType);
            }
        });
        this.assertEntityNotDeleted((Entity)entity, (Object)cb);
        return entity;
    }

    protected int xcheckSafetyResultAsOne(ConditionBean cb) {
        int safetyMaxResultSize = cb.getSafetyMaxResultSize();
        cb.checkSafetyResult(1);
        return safetyMaxResultSize;
    }

    protected void xrestoreSafetyResult(ConditionBean cb, int preSafetyMaxResultSize) {
        cb.checkSafetyResult(preSafetyMaxResultSize);
    }

    protected void assertEntityNotDeleted(Entity entity, Object searchKey) {
        if (entity == null) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntityNotDeleted(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntitySelectedAsOne(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
        if (ls.size() > 1) {
            this.throwSelectEntityDuplicatedException(String.valueOf(ls.size()), searchKey, null);
        }
    }

    protected void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(searchKey);
    }

    protected void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        this.createBhvExThrower().throwSelectEntityDuplicatedException(resultCountExp, searchKey, cause);
    }

    protected void throwSelectEntityConditionNotFoundException(ConditionBean cb) {
        this.createBhvExThrower().throwSelectEntityConditionNotFoundException(cb);
    }

    @Override
    public <ENTITY extends Entity> ListResultBean<ENTITY> readList(ConditionBean cb) {
        this.assertCBStateValid(cb);
        ListResultBean<? extends Entity> entityList = this.doReadList(cb);
        return entityList;
    }

    protected abstract ListResultBean<? extends Entity> doReadList(ConditionBean var1);

    protected <ENTITY extends Entity> void assertSpecifyDerivedReferrerEntityProperty(ConditionBean cb, Class<ENTITY> entityType) {
        List<String> aliasList = cb.getSqlClause().getSpecifiedDerivingAliasList();
        for (String alias : aliasList) {
            Method[] methods = entityType.getMethods();
            String expectedName = "set" + Srl.replace(alias, "_", "");
            boolean exists = false;
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodName.startsWith("set") || !expectedName.equalsIgnoreCase(methodName)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
        }
    }

    protected void throwSpecifyDerivedReferrerEntityPropertyNotFoundException(String alias, Class<?> entityType) {
        this.createCBExThrower().throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ListResultBean<ENTITY> helpSelectListInternally(CB cb, Class<ENTITY> entityType, InternalSelectListCallback<ENTITY, CB> callback) {
        this.assertCBNotDreamCruise(cb);
        try {
            return this.createListResultBean(cb, callback.callbackSelectList(cb, entityType));
        }
        catch (FetchingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(cb, e);
            return null;
        }
    }

    protected <ENTITY extends Entity> ListResultBean<ENTITY> createListResultBean(ConditionBean cb, List<ENTITY> selectedList) {
        return new ResultBeanBuilder<ENTITY>(this.getTableDbName()).buildListResultBean(cb, selectedList);
    }

    @Override
    public <ENTITY extends Entity> PagingResultBean<ENTITY> readPage(ConditionBean cb) {
        this.assertCBStateValid(cb);
        PagingResultBean<? extends Entity> entityList = this.doReadPage(cb);
        return entityList;
    }

    protected abstract PagingResultBean<? extends Entity> doReadPage(ConditionBean var1);

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingResultBean<ENTITY> helpSelectPageInternally(CB cb, Class<ENTITY> entityType, InternalSelectPageCallback<ENTITY, CB> callback) {
        this.assertCBNotDreamCruise(cb);
        try {
            PagingHandler<ENTITY> handler = this.createPagingHandler(cb, entityType, callback);
            PagingInvoker<ENTITY> invoker = this.createPagingInvoker(cb);
            return invoker.invokePaging(handler);
        }
        catch (PagingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(cb, e);
            return null;
        }
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingHandler<ENTITY> createPagingHandler(final CB cb, final Class<ENTITY> entityType, final InternalSelectPageCallback<ENTITY, CB> callback) {
        return new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int count() {
                try {
                    cb.getSqlClause().makePagingAdjustmentEffective();
                    int n = callback.callbackSelectCount(cb);
                    return n;
                }
                finally {
                    cb.getSqlClause().ignorePagingAdjustment();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ENTITY> paging() {
                try {
                    cb.getSqlClause().makePagingAdjustmentEffective();
                    List list = callback.callbackSelectList(cb, entityType);
                    return list;
                }
                finally {
                    cb.getSqlClause().ignorePagingAdjustment();
                }
            }
        };
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingInvoker<ENTITY> createPagingInvoker(CB cb) {
        return cb.createPagingInvoker(this.getTableDbName());
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> void helpSelectCursorInternally(CB cb, EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType, InternalSelectCursorCallback<ENTITY, CB> callback) {
        this.assertCBNotDreamCruise(cb);
        CursorSelectOption option = cb.getCursorSelectOption();
        if (option != null && option.isByPaging()) {
            this.helpSelectCursorHandlingByPaging(cb, entityRowHandler, entityType, callback, option);
        } else {
            callback.callbackSelectCursor(cb, entityRowHandler, entityType);
        }
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> void helpSelectCursorHandlingByPaging(CB cb, EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType, InternalSelectCursorCallback<ENTITY, CB> callback, CursorSelectOption option) {
        this.helpSelectCursorCheckingByPagingAllowed(cb, option);
        this.helpSelectCursorCheckingOrderByPK(cb, option);
        int pageSize = option.getPageSize();
        int pageNumber = 1;
        while (true) {
            cb.paging(pageSize, pageNumber);
            List<ENTITY> pageList = callback.callbackSelectList(cb, entityType);
            for (Entity entity : pageList) {
                entityRowHandler.handle(entity);
            }
            if (pageList.size() < pageSize) break;
            ++pageNumber;
        }
    }

    protected <CB extends ConditionBean> void helpSelectCursorCheckingByPagingAllowed(CB cb, CursorSelectOption option) {
        if (!cb.getSqlClause().isCursorSelectByPagingAllowed()) {
            String msg = "The cursor select by paging is not allowed at the DBMS.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected <CB extends ConditionBean> void helpSelectCursorCheckingOrderByPK(CB cb, CursorSelectOption option) {
        OrderByClause orderByClause;
        OrderByElement orderByFirstElement;
        if (option.isOrderByPK() && ((orderByFirstElement = (orderByClause = cb.getOrderByComponent()).getOrderByFirstElement()) == null || !orderByFirstElement.getColumnInfo().isPrimary())) {
            String msg = "The cursor select by paging needs order by primary key: " + cb.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    @Override
    public <RESULT> SLFunction<ConditionBean, RESULT> readScalar(Class<RESULT> resultType) {
        SLFunction<ConditionBean, RESULT> func = this.doReadScalar(resultType);
        return func;
    }

    protected abstract <RESULT> SLFunction<? extends ConditionBean, RESULT> doReadScalar(Class<RESULT> var1);

    @Override
    public <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> readyOutsideSql() {
        return this.doOutsideSql();
    }

    protected <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> doOutsideSql() {
        this.assertBehaviorCommandInvoker("outsideSql");
        return this._behaviorCommandInvoker.createOutsideSqlBasicExecutor(this.getTableDbName());
    }

    @Override
    public Number readNextVal() {
        return this.doReadNextVal();
    }

    protected abstract Number doReadNextVal();

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerLoader<REFERRER_ENTITY> helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        return this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerLoader<REFERRER_ENTITY> doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, final InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        PK referrerListKey;
        boolean hasFixedCondition;
        this.assertBehaviorSelectorNotNull("loadReferrer");
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
        if (localEntityList.isEmpty()) {
            NestedReferrerLoader<?> empty = EMPTY_LOADER;
            return empty;
        }
        LinkedHashMap<PK, Entity> pkLocalEntityMap = new LinkedHashMap<PK, Entity>();
        final ArrayList<PK> pkList = new ArrayList<PK>();
        for (Entity localEntity : localEntityList) {
            PK primaryKeyValue = callback.getPKVal(localEntity);
            if (primaryKeyValue == null) {
                String msg = "PK value of local entity should not be null: " + localEntity;
                throw new IllegalArgumentException(msg);
            }
            pkList.add(primaryKeyValue);
            pkLocalEntityMap.put(this.toLoadReferrerMappingKey(primaryKeyValue), localEntity);
        }
        REFERRER_CB cb = loadReferrerOption.getReferrerConditionBean() != null ? loadReferrerOption.getReferrerConditionBean() : callback.newMyCB();
        callback.qyFKIn(cb, pkList);
        String referrerPropertyName = callback.getRfPrNm();
        final String fixedCondition = this.xbuildReferrerCorrelatedFixedCondition((ConditionBean)cb, referrerPropertyName);
        final String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        boolean bl = hasFixedCondition = fixedCondition != null && fixedCondition.trim().length() > 0;
        if (hasFixedCondition) {
            cb.getSqlClause().registerWhereClause(fixedCondition, basePointAliasName);
        }
        cb.xregisterUnionQuerySynchronizer(new UnionQuery<ConditionBean>(){

            @Override
            public void query(ConditionBean unionCB) {
                ConditionBean referrerUnionCB = unionCB;
                callback.qyFKIn(referrerUnionCB, pkList);
                if (hasFixedCondition) {
                    referrerUnionCB.getSqlClause().registerWhereClause(fixedCondition, basePointAliasName);
                }
            }
        });
        if (pkList.size() > 1) {
            callback.qyOdFKAsc(cb);
            cb.getOrderByComponent().exchangeFirstOrderByElementForLastOne();
        }
        loadReferrerOption.delegateConditionBeanSettingUp(cb);
        if (cb.getSqlClause().hasSpecifiedSelectColumn(basePointAliasName)) {
            callback.spFKCol(cb);
        }
        final List<REFERRER_ENTITY> referrerList = callback.selRfLs(cb);
        loadReferrerOption.delegateEntitySettingUp(referrerList);
        LinkedHashMap pkReferrerListMap = new LinkedHashMap();
        for (Entity referrerEntity : referrerList) {
            PK foreignKeyValue = callback.getFKVal(referrerEntity);
            referrerListKey = this.toLoadReferrerMappingKey(foreignKeyValue);
            if (!pkReferrerListMap.containsKey(referrerListKey)) {
                pkReferrerListMap.put(referrerListKey, new ArrayList());
            }
            ((List)pkReferrerListMap.get(referrerListKey)).add(referrerEntity);
            Entity localEntity = (Entity)pkLocalEntityMap.get(referrerListKey);
            callback.setlcEt(referrerEntity, localEntity);
        }
        for (Entity localEntity : localEntityList) {
            PK primaryKey = callback.getPKVal(localEntity);
            referrerListKey = this.toLoadReferrerMappingKey(primaryKey);
            if (pkReferrerListMap.containsKey(referrerListKey)) {
                callback.setRfLs(localEntity, (List)pkReferrerListMap.get(referrerListKey));
                continue;
            }
            callback.setRfLs(localEntity, new ArrayList());
        }
        return new NestedReferrerLoader<REFERRER_ENTITY>(){

            @Override
            public void withNestedReferrer(ReferrerListHandler<REFERRER_ENTITY> handler) {
                handler.handle(Collections.unmodifiableList(referrerList));
            }
        };
    }

    protected String xbuildReferrerCorrelatedFixedCondition(ConditionBean cb, String referrerPropertyName) {
        if (referrerPropertyName == null) {
            return null;
        }
        DBMeta localDBMeta = this.getDBMeta();
        if (!localDBMeta.hasReferrer(referrerPropertyName)) {
            return null;
        }
        ReferrerInfo referrerInfo = localDBMeta.findReferrerInfo(referrerPropertyName);
        return this.xdoBuildReferrerCorrelatedFixedCondition(cb, referrerInfo);
    }

    protected String xdoBuildReferrerCorrelatedFixedCondition(ConditionBean cb, ReferrerInfo referrerInfo) {
        RelationInfo reverseRelation = referrerInfo.getReverseRelation();
        if (reverseRelation == null) {
            return null;
        }
        if (!(reverseRelation instanceof ForeignInfo)) {
            String msg = "The reverse relation (referrer's reverse) should be foreign info: " + referrerInfo;
            throw new IllegalStateException(msg);
        }
        ForeignInfo foreignInfo = (ForeignInfo)reverseRelation;
        String fixedCondition = foreignInfo.getFixedCondition();
        if (fixedCondition == null || fixedCondition.trim().length() == 0) {
            return null;
        }
        String localAliasMark = "$$localAlias$$";
        String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        return Srl.replace(fixedCondition, "$$localAlias$$", basePointAliasName);
    }

    protected <PK> PK toLoadReferrerMappingKey(PK value) {
        return (PK)this.toLowerCaseIfString(value);
    }

    protected void xassLRArg(List<? extends Entity> entityList, ReferrerConditionSetupper<? extends ConditionBean> setupper) {
        this.assertObjectNotNull("List<" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ">", entityList);
        this.assertObjectNotNull("setupper", setupper);
    }

    protected void xassLRArg(Entity entity, ReferrerConditionSetupper<? extends ConditionBean> setupper) {
        this.assertObjectNotNull("entity(" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ")", entity);
        this.assertObjectNotNull("setupper", setupper);
    }

    protected void xassLRArg(List<? extends Entity> entityList, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("List<" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ">", entityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected void xassLRArg(Entity entity, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("entity(" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ")", entity);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected BehaviorSelector xgetBSFLR() {
        this.assertBehaviorSelectorNotNull("loadReferrer");
        return this.getBehaviorSelector();
    }

    private void assertBehaviorSelectorNotNull(String methodName) {
        if (this._behaviorSelector != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the selector of behavior in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the selector at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the selector instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected <ELEMENT> List<ELEMENT> xnewLRLs(ELEMENT element) {
        ArrayList<ELEMENT> ls = new ArrayList<ELEMENT>(1);
        ls.add(element);
        return ls;
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> helpPulloutInternally(List<LOCAL_ENTITY> localEntityList, InternalPulloutCallback<LOCAL_ENTITY, FOREIGN_ENTITY> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("callback", callback);
        LinkedHashSet<FOREIGN_ENTITY> foreignSet = new LinkedHashSet<FOREIGN_ENTITY>();
        LinkedHashMap foreignReferrerMap = new LinkedHashMap();
        boolean existsReferrer = callback.hasRf();
        for (Entity entity : localEntityList) {
            FOREIGN_ENTITY foreignEntity = callback.getFr(entity);
            if (foreignEntity == null) continue;
            if (!foreignSet.contains(foreignEntity)) {
                foreignSet.add(foreignEntity);
            }
            if (!existsReferrer) continue;
            if (!foreignReferrerMap.containsKey(foreignEntity)) {
                foreignReferrerMap.put(foreignEntity, new ArrayList());
            }
            ((List)foreignReferrerMap.get(foreignEntity)).add(entity);
        }
        Set entrySet = foreignReferrerMap.entrySet();
        for (Map.Entry entry : entrySet) {
            callback.setRfLs((Entity)entry.getKey(), (List)entry.getValue());
        }
        return new ArrayList(foreignSet);
    }

    protected <LOCAL_ENTITY extends Entity, COLUMN> List<COLUMN> helpExtractListInternally(List<LOCAL_ENTITY> localEntityList, InternalExtractCallback<LOCAL_ENTITY, COLUMN> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("callback", callback);
        ArrayList<COLUMN> valueList = new ArrayList<COLUMN>();
        for (Entity entity : localEntityList) {
            COLUMN column = callback.getCV(entity);
            if (column == null) continue;
            valueList.add(column);
        }
        return valueList;
    }

    protected <LOCAL_ENTITY extends Entity, COLUMN> Set<COLUMN> helpExtractSetInternally(List<LOCAL_ENTITY> localEntityList, InternalExtractCallback<LOCAL_ENTITY, COLUMN> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("callback", callback);
        LinkedHashSet<COLUMN> valueSet = new LinkedHashSet<COLUMN>();
        for (Entity entity : localEntityList) {
            COLUMN column = callback.getCV(entity);
            if (column == null) continue;
            valueSet.add(column);
        }
        return valueSet;
    }

    protected void filterEntityOfInsert(Entity targetEntity, InsertOption<? extends ConditionBean> option) {
    }

    @Override
    public void warmUpCommand() {
        SelectCountCBCommand cmd = this.createSelectCountCBCommand(this.newConditionBean(), true);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        cmd = this.createSelectCountCBCommand(this.newConditionBean(), false);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        Class<? extends Entity> entityType = this.getDBMeta().getEntityType();
        SelectListCBCommand<? extends Entity> cmd2 = this.createSelectListCBCommand(this.newConditionBean(), entityType);
        cmd2.setInitializeOnly(true);
        this.invoke(cmd2);
    }

    protected SelectCountCBCommand createSelectCountCBCommand(ConditionBean cb, boolean uniqueCount) {
        this.assertBehaviorCommandInvoker("createSelectCountCBCommand");
        SelectCountCBCommand cmd = this.newSelectCountCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setUniqueCount(uniqueCount);
        return cmd;
    }

    protected SelectCountCBCommand newSelectCountCBCommand() {
        return new SelectCountCBCommand();
    }

    protected <ENTITY extends Entity> SelectCursorCBCommand<ENTITY> createSelectCursorCBCommand(ConditionBean cb, EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectCursorCBCommand");
        SelectCursorCBCommand<ENTITY> cmd = this.newSelectCursorCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        cmd.setEntityRowHandler(entityRowHandler);
        return cmd;
    }

    protected <ENTITY extends Entity> SelectCursorCBCommand<ENTITY> newSelectCursorCBCommand() {
        return new SelectCursorCBCommand();
    }

    protected <ENTITY extends Entity> SelectListCBCommand<ENTITY> createSelectListCBCommand(ConditionBean cb, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectListCBCommand");
        SelectListCBCommand<ENTITY> cmd = this.newSelectListCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected <ENTITY extends Entity> SelectListCBCommand<ENTITY> newSelectListCBCommand() {
        return new SelectListCBCommand();
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValCommand(Class<RESULT> resultType) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValCommand<RESULT> cmd = this.newSelectNextValCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        return cmd;
    }

    protected <RESULT> SelectNextValCommand<RESULT> newSelectNextValCommand() {
        return new SelectNextValCommand();
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValSubCommand(Class<RESULT> resultType, String columnDbName, String sequenceName, Integer incrementSize, Integer cacheSize) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValSubCommand<RESULT> cmd = this.newSelectNextValSubCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        cmd.setColumnInfo(this.getDBMeta().findColumnInfo(columnDbName));
        cmd.setSequenceName(sequenceName);
        cmd.setIncrementSize(incrementSize);
        cmd.setCacheSize(cacheSize);
        return cmd;
    }

    protected <RESULT> SelectNextValSubCommand<RESULT> newSelectNextValSubCommand() {
        return new SelectNextValSubCommand();
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> createSelectScalarCBCommand(ConditionBean cb, Class<RESULT> resultType, SqlClause.SelectClauseType selectClauseType) {
        this.assertBehaviorCommandInvoker("createSelectScalarCBCommand");
        SelectScalarCBCommand<RESULT> cmd = this.newSelectScalarCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setResultType(resultType);
        cmd.setSelectClauseType(selectClauseType);
        return cmd;
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> newSelectScalarCBCommand() {
        return new SelectScalarCBCommand();
    }

    protected void xsetupSelectCommand(AbstractBehaviorCommand<?> cmd) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
    }

    protected InsertEntityCommand createInsertEntityCommand(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createInsertEntityCommand");
        InsertEntityCommand cmd = this.newInsertEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected InsertEntityCommand newInsertEntityCommand() {
        return new InsertEntityCommand();
    }

    protected void xsetupEntityCommand(AbstractEntityCommand cmd, Entity entity) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    protected void assertBehaviorCommandInvoker(String methodName) {
        if (this._behaviorCommandInvoker != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the invoker of behavior command in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the invoker instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected abstract boolean hasVersionNoValue(Entity var1);

    protected abstract boolean hasUpdateDateValue(Entity var1);

    protected <ENTITY extends Entity> ENTITY helpEntityDowncastInternally(Entity entity, Class<ENTITY> clazz) {
        this.assertObjectNotNull("entity", entity);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (ENTITY)entity;
        }
        catch (ClassCastException e) {
            String msg = "The entity should be " + DfTypeUtil.toClassTitle(clazz);
            msg = msg + " but it was: " + entity.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected <CB extends ConditionBean> CB helpConditionBeanDowncastInternally(ConditionBean cb, Class<CB> clazz) {
        this.assertObjectNotNull("cb", cb);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (CB)cb;
        }
        catch (ClassCastException e) {
            String msg = "The condition-bean should be " + DfTypeUtil.toClassTitle(clazz);
            msg = msg + " but it was: " + cb.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        this.assertBehaviorCommandInvoker("createBhvExThrower");
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNull(Entity entity) {
        this.assertObjectNotNull("entity", entity);
    }

    protected void assertCBStateValid(ConditionBean cb) {
        this.assertCBNotNull(cb);
        this.assertCBNotDreamCruise(cb);
    }

    protected void assertCBNotNull(ConditionBean cb) {
        this.assertObjectNotNull("cb", cb);
    }

    protected void assertCBNotDreamCruise(ConditionBean cb) {
        if (cb.xisDreamCruiseShip()) {
            String msg = "The condition-bean should not be dream cruise: " + cb.getClass();
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertEntityNotNullAndHasPrimaryKeyValue(Entity entity) {
        this.assertEntityNotNull(entity);
        Set<String> uniqueDrivenPropSet = entity.myuniqueDrivenProperties();
        if (uniqueDrivenPropSet.isEmpty()) {
            if (!entity.hasPrimaryKeyValue()) {
                this.createBhvExThrower().throwEntityPrimaryKeyNotFoundException(entity);
            }
        } else {
            for (String prop : uniqueDrivenPropSet) {
                Object value;
                ColumnInfo columnInfo = this.getDBMeta().findColumnInfo(prop);
                if (columnInfo == null || (value = columnInfo.read(entity)) != null) continue;
                this.createBhvExThrower().throwEntityUniqueKeyNotFoundException(entity);
            }
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (!ls.isEmpty()) {
            String msg = "The list should be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndNotEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.isEmpty()) {
            String msg = "The list should not be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndHasOnlyOne(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.size() != 1) {
            String msg = "The list should contain only one object: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object toLowerCaseIfString(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        return obj;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected BehaviorCommandInvoker getBehaviorCommandInvoker() {
        return this._behaviorCommandInvoker;
    }

    public void setBehaviorCommandInvoker(BehaviorCommandInvoker behaviorCommandInvoker) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
    }

    protected BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    protected static interface InternalExtractCallback<LOCAL_ENTITY extends Entity, COLUMN> {
        public COLUMN getCV(LOCAL_ENTITY var1);
    }

    protected static interface InternalPulloutCallback<LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> {
        public FOREIGN_ENTITY getFr(LOCAL_ENTITY var1);

        public boolean hasRf();

        public void setRfLs(FOREIGN_ENTITY var1, List<LOCAL_ENTITY> var2);
    }

    protected static interface InternalLoadReferrerCallback<LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> {
        public PK getPKVal(LOCAL_ENTITY var1);

        public void setRfLs(LOCAL_ENTITY var1, List<REFERRER_ENTITY> var2);

        public REFERRER_CB newMyCB();

        public void qyFKIn(REFERRER_CB var1, List<PK> var2);

        public void qyOdFKAsc(REFERRER_CB var1);

        public void spFKCol(REFERRER_CB var1);

        public List<REFERRER_ENTITY> selRfLs(REFERRER_CB var1);

        public PK getFKVal(REFERRER_ENTITY var1);

        public void setlcEt(REFERRER_ENTITY var1, LOCAL_ENTITY var2);

        public String getRfPrNm();
    }

    public static class SLFunction<CB extends ConditionBean, RESULT> {
        protected CB _conditionBean;
        protected Class<RESULT> _resultType;
        final /* synthetic */ AbstractBehaviorReadable this$0;

        public SLFunction(CB conditionBean, Class<RESULT> resultType) {
            this.this$0 = var1_1;
            this._conditionBean = conditionBean;
            this._resultType = resultType;
        }

        public RESULT count(ScalarQuery<CB> scalarQuery) {
            return this.doCount(scalarQuery, null);
        }

        public RESULT count(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doCount(scalarQuery, option);
        }

        protected RESULT doCount(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.UNIQUE_COUNT, option);
        }

        public RESULT countDistinct(ScalarQuery<CB> scalarQuery) {
            return this.doCountDistinct(scalarQuery, null);
        }

        public RESULT countDistinct(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doCountDistinct(scalarQuery, option);
        }

        protected RESULT doCountDistinct(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.COUNT_DISTINCT, option);
        }

        public RESULT max(ScalarQuery<CB> scalarQuery) {
            return this.doMax(scalarQuery, null);
        }

        public RESULT max(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doMax(scalarQuery, option);
        }

        protected RESULT doMax(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MAX, option);
        }

        public RESULT min(ScalarQuery<CB> scalarQuery) {
            return this.doMin(scalarQuery, null);
        }

        public RESULT min(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doMin(scalarQuery, option);
        }

        protected RESULT doMin(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MIN, option);
        }

        public RESULT sum(ScalarQuery<CB> scalarQuery) {
            return this.doSum(scalarQuery, null);
        }

        public RESULT sum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doSum(scalarQuery, option);
        }

        protected RESULT doSum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.SUM, option);
        }

        public RESULT avg(ScalarQuery<CB> scalarQuery) {
            return this.doAvg(scalarQuery, null);
        }

        public RESULT avg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doAvg(scalarQuery, option);
        }

        protected RESULT doAvg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.AVG, option);
        }

        protected RESULT exec(ScalarQuery<CB> scalarQuery, SqlClause.SelectClauseType selectClauseType, ScalarSelectOption option) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            this.this$0.assertObjectNotNull("selectClauseType", (Object)selectClauseType);
            this.this$0.assertObjectNotNull("conditionBean", this._conditionBean);
            this.this$0.assertObjectNotNull("resultType", this._resultType);
            scalarQuery.query(this._conditionBean);
            this.setupTargetColumnInfo(option);
            this.setupScalarSelectOption(option);
            this.assertScalarSelectRequiredSpecifyColumn();
            return this.this$0.invoke(this.this$0.createSelectScalarCBCommand((ConditionBean)this._conditionBean, this._resultType, selectClauseType));
        }

        protected void setupTargetColumnInfo(ScalarSelectOption option) {
            if (option == null) {
                return;
            }
            SqlClause sqlClause = this._conditionBean.getSqlClause();
            ColumnInfo columnInfo = sqlClause.getSpecifiedColumnInfoAsOne();
            if (columnInfo != null) {
                columnInfo = sqlClause.getSpecifiedDerivingColumnInfoAsOne();
            }
            option.xsetTargetColumnInfo(columnInfo);
        }

        protected void setupScalarSelectOption(ScalarSelectOption option) {
            if (option != null) {
                this._conditionBean.xacceptScalarSelectOption(option);
                this._conditionBean.localCQ().xregisterParameterOption(option);
            }
        }

        protected void assertScalarSelectRequiredSpecifyColumn() {
            SqlClause sqlClause = this._conditionBean.getSqlClause();
            String columnName = sqlClause.getSpecifiedColumnDbNameAsOne();
            String subQuery = sqlClause.getSpecifiedDerivingSubQueryAsOne();
            if (columnName != null && subQuery != null || columnName == null && subQuery == null) {
                this.throwScalarSelectInvalidColumnSpecificationException();
            }
        }

        protected void throwScalarSelectInvalidColumnSpecificationException() {
            this.this$0.createCBExThrower().throwScalarSelectInvalidColumnSpecificationException((ConditionBean)this._conditionBean, this._resultType);
        }

        protected void assertScalarQuery(ScalarQuery<?> scalarQuery) {
            if (scalarQuery == null) {
                String msg = "The argument 'scalarQuery' for ScalarSelect should not be null.";
                throw new IllegalArgumentException(msg);
            }
        }

        protected void assertScalarSelectOption(ScalarSelectOption option) {
            if (option == null) {
                String msg = "The argument 'option' for ScalarSelect should not be null.";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    protected static interface InternalSelectCursorCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public void callbackSelectCursor(CB var1, EntityRowHandler<ENTITY> var2, Class<ENTITY> var3);

        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    protected static interface InternalSelectPageCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public int callbackSelectCount(CB var1);

        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    protected static interface InternalSelectListCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    protected static interface InternalSelectEntityWithDeletedCheckCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    protected static interface InternalSelectEntityCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }
}

