/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.dbmeta.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.hierarchy.HierarchySourceColumn;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.dbmeta.info.RelationInfo;

public class HierarchyRequestElement {
    public static final String TOP_KEY = "$top$";
    protected HierarchySourceColumn sourceColumn;
    protected DBMeta destinationDBMeta;
    protected ColumnInfo destinationColumnInfo;
    protected List<RelationInfo> relationInfoList = new ArrayList<RelationInfo>();
    protected List<String> relationPropertyNameList = new ArrayList<String>();
    protected String relationPropertyKey = "$top$";

    public void mapping(HierarchySourceColumn sourceColumn, ColumnInfo destinationColumnInfo) {
        this.sourceColumn = sourceColumn;
        this.destinationColumnInfo = destinationColumnInfo;
    }

    public void relation(RelationInfo relationInfo) {
        this.addRelationInfoList(relationInfo);
    }

    protected void addRelationInfoList(RelationInfo relationInfo) {
        this.relationInfoList.add(relationInfo);
        this.addRelationPropertyNameList(relationInfo.getRelationPropertyName());
    }

    protected void addRelationPropertyNameList(String relationPropertyName) {
        this.relationPropertyNameList.add(relationPropertyName);
        this.setupRelationPropertyKey();
    }

    protected void setupRelationPropertyKey() {
        StringBuilder sb = new StringBuilder();
        for (String relationPropertyName : this.relationPropertyNameList) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(relationPropertyName);
        }
        this.relationPropertyKey = sb.toString();
    }

    public HierarchySourceColumn getSourceColumnInfo() {
        return this.sourceColumn;
    }

    public void setSourceColumnInfo(HierarchySourceColumn sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public void setDestinationDBMeta(DBMeta destinationDBMeta) {
        this.destinationDBMeta = destinationDBMeta;
    }

    public DBMeta getDestinationDBMeta() {
        return this.destinationDBMeta;
    }

    public ColumnInfo getDestinationColumnInfo() {
        return this.destinationColumnInfo;
    }

    public List<RelationInfo> getRelationInfoList() {
        return this.relationInfoList;
    }

    public List<String> getRelationPropertyNameList() {
        return this.relationPropertyNameList;
    }

    public String getRelationPropertyKey() {
        return this.relationPropertyKey;
    }

    public String toString() {
        return this.sourceColumn + "," + this.destinationColumnInfo;
    }
}

