/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.valuetype.plugin;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.s2dao.valuetype.plugin.GreatWallOfOracleType;
import org.codelibs.robot.dbflute.util.DfTypeUtil;

public abstract class OracleArrayType
extends GreatWallOfOracleType {
    public OracleArrayType(String arrayTypeName, Class<?> elementType) {
        super(2003, arrayTypeName, elementType);
    }

    @Override
    protected String getTitleName() {
        return "Array";
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.toPropertyValue(rs.getArray(index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.toPropertyValue(rs.getArray(columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toPropertyValue(cs.getArray(index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toPropertyValue(cs.getArray(parameterName));
    }

    protected Collection<Object> toPropertyValue(Object oracleArray) throws SQLException {
        return this.mappingOracleArrayToList(oracleArray, this._mainObjectType);
    }

    @Override
    protected Object toBindValue(Connection conn, Object paramExp, Object value) throws SQLException {
        this.assertArrayPropertyValueCollection(paramExp, value);
        return this.mappingListToOracleArray(conn, paramExp, (List)value, this._mainTypeName, this._mainObjectType);
    }

    protected void assertArrayPropertyValueCollection(Object paramExp, Object value) {
        if (!(value instanceof Collection)) {
            this.throwArrayPropertyValueNotCollectionException(paramExp, value);
        }
    }

    protected void throwArrayPropertyValueNotCollectionException(Object paramExp, Object value) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The property value for struct should be entity type:");
        br.addItem("Array");
        br.addElement(this._mainTypeName);
        br.addItem("Element");
        br.addElement(DfTypeUtil.toClassTitle(this._mainObjectType));
        br.addItem("Parameter");
        br.addElement(paramExp);
        br.addItem("Property Value");
        if (value != null) {
            br.addElement(value.getClass());
        }
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }
}

