/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private TaskAttemptFinished datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String taskStatus;
    private long finishTime;
    private String rackName;
    private String hostname;
    private String state;
    private Counters counters;

    public TaskAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long finishTime, String rackName, String hostname, String state, Counters counters) {
        this.attemptId = id;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.finishTime = finishTime;
        this.rackName = rackName;
        this.hostname = hostname;
        this.state = state;
        this.counters = counters;
    }

    TaskAttemptFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskAttemptFinished();
            this.datum.taskid = new Utf8(this.attemptId.getTaskID().toString());
            this.datum.attemptId = new Utf8(this.attemptId.toString());
            this.datum.taskType = new Utf8(this.taskType.name());
            this.datum.taskStatus = new Utf8(this.taskStatus);
            this.datum.finishTime = this.finishTime;
            if (this.rackName != null) {
                this.datum.rackname = new Utf8(this.rackName);
            }
            this.datum.hostname = new Utf8(this.hostname);
            this.datum.state = new Utf8(this.state);
            this.datum.counters = EventWriter.toAvro(this.counters);
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (TaskAttemptFinished)((Object)oDatum);
        this.attemptId = TaskAttemptID.forName(((Object)this.datum.attemptId).toString());
        this.taskType = TaskType.valueOf(((Object)this.datum.taskType).toString());
        this.taskStatus = ((Object)this.datum.taskStatus).toString();
        this.finishTime = this.datum.finishTime;
        this.rackName = ((Object)this.datum.rackname).toString();
        this.hostname = ((Object)this.datum.hostname).toString();
        this.state = ((Object)this.datum.state).toString();
        this.counters = EventReader.fromAvro(this.datum.counters);
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskAttemptID getAttemptId() {
        return this.attemptId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.taskStatus.toString();
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getHostname() {
        return this.hostname.toString();
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getState() {
        return this.state.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return this.getTaskId().getTaskType() == TaskType.MAP ? EventType.MAP_ATTEMPT_FINISHED : EventType.REDUCE_ATTEMPT_FINISHED;
    }
}

