/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.client.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codelibs.robot.MaxLengthExceededException;
import org.codelibs.robot.RobotCrawlAccessException;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.S2RobotContext;
import org.codelibs.robot.client.AbstractS2RobotClient;
import org.codelibs.robot.client.http.Authentication;
import org.codelibs.robot.client.http.HcConnectionMonitorTarget;
import org.codelibs.robot.client.http.RequestHeader;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.entity.RobotsTxt;
import org.codelibs.robot.helper.ContentLengthHelper;
import org.codelibs.robot.helper.RobotsTxtHelper;
import org.codelibs.robot.util.CrawlingParameterUtil;
import org.codelibs.robot.util.StreamUtil;
import org.codelibs.robot.util.TemporaryFileInputStream;
import org.seasar.extension.timer.TimeoutManager;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcHttpClient
extends AbstractS2RobotClient {
    public static final String ACCESS_TIMEOUT_PROPERTY = "accessTimeout";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    public static final String STALE_CHECKING_ENABLED_PROPERTY = "staleCheckingEnabled";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_AUTH_SCHEME_PROPERTY = "proxyAuthScheme";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String ROBOTS_TXT_ENABLED_PROPERTY = "robotsTxtEnabled";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    public static final String REQUERT_HEADERS_PROPERTY = "requestHeaders";
    public static final String COOKIES_PROPERTY = "cookies";
    public static final String AUTH_SCHEME_PROVIDERS_PROPERTY = "authSchemeProviders";
    private static final Logger logger = LoggerFactory.getLogger(HcHttpClient.class);
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected volatile CloseableHttpClient httpClient;
    private final List<Header> requestHeaderList = new ArrayList<Header>();
    private final Map<String, Object> httpClientPropertyMap = new HashMap<String, Object>();
    private TimeoutTask connectionMonitorTask;
    public Integer accessTimeout;
    public Integer connectionTimeout;
    public Integer maxTotalConnections;
    public Integer maxConnectionsPerRoute;
    public Boolean staleCheckingEnabled;
    public Integer soTimeout;
    public String cookieSpec;
    public String userAgent = "S2Robot";
    @Binding(bindingType=BindingType.MAY)
    public HttpClientContext httpClientContext = HttpClientContext.create();
    public String proxyHost;
    public Integer proxyPort;
    @Binding(bindingType=BindingType.MAY)
    public AuthScheme proxyAuthScheme = new BasicScheme();
    @Binding(bindingType=BindingType.MAY)
    public Credentials proxyCredentials;
    public int responseBodyInMemoryThresholdSize = 0x100000;
    public String defaultMimeType = "application/octet-stream";
    @Binding(bindingType=BindingType.MAY)
    public CookieStore cookieStore = new BasicCookieStore();
    public HttpClientConnectionManager clientConnectionManager;
    public Map<String, AuthSchemeProvider> authSchemeProviderMap;
    public int connectionCheckInterval = 5;
    public long idleConnectionTimeout = 60000L;
    public Pattern redirectHttpStatusPattern = Pattern.compile("[3][0-9][0-9]");
    public boolean useRobotsTxtDisallows = true;
    public boolean useRobotsTxtAllows = false;

    public synchronized void init() {
        RequestHeader[] requestHeaders;
        Authentication[] siteCredentialList;
        Integer soTimeoutParam;
        Boolean staleCheckingEnabledParam;
        Integer accessTimeoutParam;
        if (this.httpClient != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + HcHttpClient.class.getName());
        }
        if ((accessTimeoutParam = this.getInitParameter(ACCESS_TIMEOUT_PROPERTY, this.accessTimeout)) != null) {
            this.accessTimeout = accessTimeoutParam;
        }
        Boolean robotsTxtEnabled = this.getInitParameter(ROBOTS_TXT_ENABLED_PROPERTY, Boolean.TRUE);
        if (this.robotsTxtHelper != null) {
            this.robotsTxtHelper.setEnabled(robotsTxtEnabled);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Integer connectionTimeoutParam = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout);
        if (connectionTimeoutParam != null) {
            requestConfigBuilder.setConnectTimeout(connectionTimeoutParam.intValue());
        }
        if ((staleCheckingEnabledParam = this.getInitParameter(STALE_CHECKING_ENABLED_PROPERTY, this.staleCheckingEnabled)) != null) {
            requestConfigBuilder.setStaleConnectionCheckEnabled(staleCheckingEnabledParam.booleanValue());
        }
        if ((soTimeoutParam = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout)) != null) {
            requestConfigBuilder.setSocketTimeout(soTimeoutParam.intValue());
        }
        RegistryBuilder authSchemeProviderBuilder = RegistryBuilder.create();
        Map<String, AuthSchemeProvider> factoryMap = this.getInitParameter(AUTH_SCHEME_PROVIDERS_PROPERTY, this.authSchemeProviderMap);
        if (factoryMap != null) {
            for (Map.Entry<String, AuthSchemeProvider> entry : factoryMap.entrySet()) {
                authSchemeProviderBuilder.register(entry.getKey(), (Object)entry.getValue());
            }
        }
        this.userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent);
        if (StringUtil.isNotBlank((String)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        BasicCredentialsProvider credsProvider = null;
        BasicAuthCache authCache = null;
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort);
        if (proxyHost != null && proxyPort != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            Credentials credentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials);
            if (credentials != null) {
                authCache = new BasicAuthCache();
                credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), credentials);
                AuthScheme authScheme = this.getInitParameter(PROXY_AUTH_SCHEME_PROPERTY, this.proxyAuthScheme);
                if (authScheme != null) {
                    authCache.put(proxy, authScheme);
                }
            }
        }
        if ((siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new Authentication[0])) != null && siteCredentialList.length > 0 && authCache == null) {
            authCache = new BasicAuthCache();
            credsProvider = new BasicCredentialsProvider();
        }
        for (Authentication authentication : siteCredentialList) {
            AuthScope authScope = authentication.getAuthScope();
            credsProvider.setCredentials(authScope, authentication.getCredentials());
            AuthScheme authScheme = authentication.getAuthScheme();
            if (authScope.getHost() == null || authScheme == null) continue;
            HttpHost targetHost = new HttpHost(authScope.getHost(), authScope.getPort());
            authCache.put(targetHost, authScheme);
        }
        if (authCache != null) {
            this.httpClientContext.setAuthCache((AuthCache)authCache);
            this.httpClientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        for (RequestHeader requestHeader : requestHeaders = this.getInitParameter(REQUERT_HEADERS_PROPERTY, new RequestHeader[0])) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
        }
        requestConfigBuilder.setRedirectsEnabled(false);
        if (this.cookieSpec != null) {
            requestConfigBuilder.setCookieSpec(this.cookieSpec);
        }
        httpClientBuilder.setDefaultCookieStore(this.cookieStore);
        if (this.cookieStore != null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = this.getInitParameter(COOKIES_PROPERTY, new Cookie[0])) {
                this.cookieStore.addCookie(cookie);
            }
        }
        this.connectionMonitorTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)new HcConnectionMonitorTarget(this.clientConnectionManager, this.idleConnectionTimeout), this.connectionCheckInterval, true);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setConnectionManager(this.clientConnectionManager).setDefaultRequestConfig(requestConfigBuilder.build()).build();
        if (!this.httpClientPropertyMap.isEmpty()) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(closeableHttpClient.getClass());
            for (Map.Entry<String, Object> entry : this.httpClientPropertyMap.entrySet()) {
                String propertyName = entry.getKey();
                if (beanDesc.hasPropertyDesc(propertyName)) {
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
                    propertyDesc.setValue((Object)closeableHttpClient, entry.getValue());
                    continue;
                }
                logger.warn("DefaultHttpClient does not have " + propertyName + ".");
            }
        }
        this.httpClient = closeableHttpClient;
    }

    @DestroyMethod
    public void destroy() {
        if (this.connectionMonitorTask != null) {
            this.connectionMonitorTask.cancel();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpClient.", (Throwable)e);
            }
        }
    }

    public void addHttpClientProperty(String name, Object value) {
        if (StringUtil.isNotBlank((String)name) && value != null) {
            this.httpClientPropertyMap.put(name, value);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRobotsTxt(String url) {
        HttpEntity httpEntity;
        block18: {
            if (StringUtil.isBlank((String)url)) {
                throw new RobotSystemException("url is null or empty.");
            }
            if (this.robotsTxtHelper == null) {
                return;
            }
            S2RobotContext robotContext = CrawlingParameterUtil.getRobotContext();
            if (robotContext == null) {
                return;
            }
            int idx = url.indexOf(47, url.indexOf("://") + 3);
            String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
            String robotTxtUrl = hostUrl + "/robots.txt";
            if (robotContext.getRobotTxtUrlSet().contains(robotTxtUrl)) {
                if (!logger.isDebugEnabled()) return;
                logger.debug(robotTxtUrl + " is already visited.");
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Checking URL: " + robotTxtUrl);
            }
            robotContext.getRobotTxtUrlSet().add(robotTxtUrl);
            HttpGet httpGet = new HttpGet(robotTxtUrl);
            for (Header header : this.requestHeaderList) {
                httpGet.addHeader(header);
            }
            httpEntity = null;
            try {
                RobotsTxt.Directive directive;
                RobotsTxt robotsTxt;
                HttpResponse response = this.executeHttpClient((HttpUriRequest)httpGet);
                httpEntity = response.getEntity();
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode != 200) break block18;
                Header contentLengthHeader = response.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    long maxLength;
                    String value = contentLengthHeader.getValue();
                    long contentLength = Long.parseLong(value);
                    if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                        throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                    }
                }
                if (httpEntity == null || (robotsTxt = this.robotsTxtHelper.parse(httpEntity.getContent())) == null) break block18;
                String[] sitemaps = robotsTxt.getSitemaps();
                if (sitemaps.length > 0) {
                    robotContext.addSitemaps(sitemaps);
                }
                if ((directive = robotsTxt.getMatchedDirective(this.userAgent)) == null) break block18;
                if (this.useRobotsTxtDisallows) {
                    for (String urlPattern : directive.getDisallows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        robotContext.getUrlFilter().addExclude(hostUrl + urlPattern);
                    }
                }
                if (this.useRobotsTxtAllows) {
                    for (String urlPattern : directive.getAllows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        robotContext.getUrlFilter().addInclude(hostUrl + urlPattern);
                    }
                }
            }
            catch (RobotSystemException e) {
                try {
                    httpGet.abort();
                    throw e;
                    catch (Exception e2) {
                        httpGet.abort();
                        throw new RobotCrawlAccessException("Could not process " + robotTxtUrl + ". ", e2);
                    }
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly(httpEntity);
                    throw throwable;
                }
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
    }

    protected String convertRobotsTxtPathPattern(String path) {
        String newPath = path.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        if (newPath.charAt(0) != '/') {
            newPath = ".*" + newPath;
        }
        if (!newPath.endsWith("$") && !newPath.endsWith(".*")) {
            newPath = newPath + ".*";
        }
        return newPath.replaceAll("\\.\\*\\.\\*", ".*");
    }

    @Override
    public ResponseData doGet(String url) {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpGet);
    }

    @Override
    public ResponseData doHead(String url) {
        HttpHead httpHead;
        try {
            httpHead = new HttpHead(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData doHttpMethod(String url, HttpUriRequest httpRequest) {
        if (this.httpClient == null) {
            this.init();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Accessing " + url);
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.processHttpMethod(url, httpRequest);
            return responseData;
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResponseData processHttpMethod(String url, HttpUriRequest httpRequest) {
        ResponseData responseData;
        int httpStatusCode;
        HttpResponse response;
        HttpEntity httpEntity;
        InputStream inputStream;
        ResponseData responseData2;
        block41: {
            block40: {
                try {
                    this.processRobotsTxt(url);
                }
                catch (RobotCrawlAccessException e) {
                    if (logger.isInfoEnabled()) {
                        StringBuilder buf = new StringBuilder();
                        buf.append(e.getMessage());
                        if (e.getCause() != null) {
                            buf.append(e.getCause().getMessage());
                        }
                        logger.info(buf.toString());
                    }
                    if (!logger.isDebugEnabled()) break block40;
                    logger.debug("Crawling Access Exception at " + url, (Throwable)e);
                }
            }
            for (Header header : this.requestHeaderList) {
                httpRequest.addHeader(header);
            }
            responseData2 = null;
            inputStream = null;
            httpEntity = null;
            response = this.executeHttpClient(httpRequest);
            httpEntity = response.getEntity();
            httpStatusCode = response.getStatusLine().getStatusCode();
            if (!this.isRedirectHttpStatus(httpStatusCode)) break block41;
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null) {
                logger.warn("Invalid redirect location at " + url);
                break block41;
            }
            responseData2 = new ResponseData();
            responseData2.setRedirectLocation(locationHeader.getValue());
            ResponseData responseData3 = responseData2;
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            return responseData3;
        }
        try {
            Date d;
            String value;
            long maxLength;
            int idx;
            long contentLength = 0L;
            String contentEncoding = "UTF-8";
            if (httpEntity == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            } else {
                Header contentEncodingHeader;
                InputStream responseBodyStream = httpEntity.getContent();
                File outputFile = File.createTempFile("s2robot-HcHttpClient-", ".out");
                DeferredFileOutputStream dfos = null;
                try {
                    try {
                        dfos = new DeferredFileOutputStream(this.responseBodyInMemoryThresholdSize, outputFile);
                        StreamUtil.drain(responseBodyStream, (OutputStream)dfos);
                        dfos.flush();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(dfos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)dfos);
                }
                catch (Exception e) {
                    if (!outputFile.delete()) {
                        logger.warn("Could not delete " + outputFile.getAbsolutePath());
                    }
                    throw e;
                }
                if (dfos.isInMemory()) {
                    inputStream = new ByteArrayInputStream(dfos.getData());
                    contentLength = dfos.getData().length;
                    if (!outputFile.delete()) {
                        logger.warn("Could not delete " + outputFile.getAbsolutePath());
                    }
                } else {
                    inputStream = new TemporaryFileInputStream(outputFile);
                    contentLength = outputFile.length();
                }
                if ((contentEncodingHeader = httpEntity.getContentEncoding()) != null) {
                    contentEncoding = contentEncodingHeader.getValue();
                }
            }
            String contentType = null;
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(59)) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
            }
            responseData2 = new ResponseData();
            responseData2.setUrl(url);
            responseData2.setCharSet(contentEncoding);
            if (httpRequest instanceof HttpHead) {
                responseData2.setMethod("HEAD");
            } else {
                responseData2.setMethod("GET");
            }
            responseData2.setResponseBody(inputStream);
            responseData2.setHttpStatusCode(httpStatusCode);
            for (Header header : response.getAllHeaders()) {
                responseData2.addMetaData(header.getName(), header.getValue());
            }
            if (contentType == null) {
                responseData2.setMimeType(this.defaultMimeType);
            } else {
                responseData2.setMimeType(contentType);
            }
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader == null) {
                responseData2.setContentLength(contentLength);
            } else {
                String value2 = contentLengthHeader.getValue();
                try {
                    responseData2.setContentLength(Long.parseLong(value2));
                }
                catch (Exception e) {
                    responseData2.setContentLength(contentLength);
                }
            }
            Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
            if (lastModifiedHeader != null && StringUtil.isNotBlank((String)(value = lastModifiedHeader.getValue())) && (d = this.parseLastModified(value)) != null) {
                responseData2.setLastModified(d);
            }
            responseData = responseData2;
        }
        catch (UnknownHostException e) {
            try {
                httpRequest.abort();
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("Unknown host(" + e.getMessage() + "): " + url, e);
                catch (NoRouteToHostException e2) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw new RobotCrawlAccessException("No route to host(" + e2.getMessage() + "): " + url, e2);
                }
                catch (ConnectException e3) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw new RobotCrawlAccessException("Connection time out(" + e3.getMessage() + "): " + url, e3);
                }
                catch (SocketException e4) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw new RobotCrawlAccessException("Socket exception(" + e4.getMessage() + "): " + url, e4);
                }
                catch (IOException e5) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw new RobotCrawlAccessException("I/O exception(" + e5.getMessage() + "): " + url, e5);
                }
                catch (RobotSystemException e6) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw e6;
                }
                catch (Exception e7) {
                    httpRequest.abort();
                    IOUtils.closeQuietly(inputStream);
                    throw new RobotSystemException("Failed to access " + url, e7);
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseData;
    }

    protected boolean isRedirectHttpStatus(int httpStatusCode) {
        return this.redirectHttpStatusPattern.matcher(Integer.toString(httpStatusCode)).matches();
    }

    protected HttpResponse executeHttpClient(HttpUriRequest httpRequest) throws IOException {
        return this.httpClient.execute(httpRequest, (HttpContext)new BasicHttpContext((HttpContext)this.httpClientContext));
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected static class AccessTimeoutTarget
    implements TimeoutTarget {
        private static final int MAX_LOOP_COUNT = 10;
        protected Thread runninThread;
        protected AtomicBoolean running = new AtomicBoolean();

        protected AccessTimeoutTarget(Thread thread) {
            this.runninThread = thread;
            this.running.set(true);
        }

        public void expired() {
            for (int count = 0; this.running.get() && count < 10; ++count) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Interrupt " + this.runninThread);
                }
                this.runninThread.interrupt();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void stop() {
            this.running.set(false);
        }
    }
}

