/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.bhv.SqlStringFilter;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.execution.AbstractFixedSqlExecution;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractOutsideSqlExecution
extends AbstractFixedSqlExecution {
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected OutsideSqlFilter _outsideSqlFilter;

    public AbstractOutsideSqlExecution(DataSource dataSource, StatementFactory statementFactory, Map<String, Class<?>> argNameTypeMap, String twoWaySql) {
        super(dataSource, statementFactory, argNameTypeMap, twoWaySql);
    }

    @Override
    protected String filterExecutedSql(String executedSql) {
        executedSql = super.filterExecutedSql(executedSql);
        executedSql = this.doFilterExecutedSqlByOutsideSqlFilter(executedSql);
        if (this._removeBlockComment) {
            executedSql = Srl.removeBlockComment(executedSql);
        }
        if (this._removeLineComment) {
            executedSql = Srl.removeLineComment(executedSql);
        }
        if (this._formatSql) {
            executedSql = Srl.removeEmptyLine(executedSql);
        }
        executedSql = this.doFilterExecutedSqlByCallbackFilter(executedSql);
        return executedSql;
    }

    protected String doFilterExecutedSqlByOutsideSqlFilter(String executedSql) {
        if (this._outsideSqlFilter != null) {
            OutsideSqlFilter.ExecutionFilterType filterType = this.getOutsideSqlExecutionFilterType();
            return this._outsideSqlFilter.filterExecution(executedSql, filterType);
        }
        return executedSql;
    }

    protected abstract OutsideSqlFilter.ExecutionFilterType getOutsideSqlExecutionFilterType();

    protected String doFilterExecutedSqlByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterOutsideSql(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public void setRemoveBlockComment(boolean removeBlockComment) {
        this._removeBlockComment = removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this._removeLineComment = removeLineComment;
    }

    public boolean isRemoveEmptyLine() {
        return this._formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this._formatSql = formatSql;
    }

    public OutsideSqlFilter getOutsideSqlFilter() {
        return this._outsideSqlFilter;
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }
}

