/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.chelper.HpManualOrderThemeListHandler;
import org.seasar.dbflute.cbean.chelper.HpMobCaseWhenElement;
import org.seasar.dbflute.cbean.chelper.HpMobConnectedBean;
import org.seasar.dbflute.cbean.chelper.HpMobConnectionMode;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ColumnConversionOption;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ClassificationCodeType;
import org.seasar.dbflute.util.DfTypeUtil;

public class ManualOrderBean
implements HpCalculator {
    public static final String THEME_KEY = "ManualOrder";
    protected final List<HpMobCaseWhenElement> _caseWhenAcceptedList = new ArrayList<HpMobCaseWhenElement>();
    protected final List<HpMobCaseWhenElement> _caseWhenBoundList = new ArrayList<HpMobCaseWhenElement>();
    protected HpCalcSpecification<ConditionBean> _calcSpecification;
    protected HpMobConnectionMode _connectionMode;
    protected Object _elseAcceptedValue;
    protected Object _elseBoundValue;
    protected boolean _suppressThenBinding;
    protected boolean _suppressElseBinding;

    public HpMobConnectedBean when_Equal(Object orderValue) {
        return this.doWhen(ConditionKey.CK_EQUAL, orderValue);
    }

    public HpMobConnectedBean when_NotEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_NOT_EQUAL_STANDARD, orderValue);
    }

    public HpMobConnectedBean when_GreaterThan(Object orderValue) {
        return this.doWhen(ConditionKey.CK_GREATER_THAN, orderValue);
    }

    public HpMobConnectedBean when_LessThan(Object orderValue) {
        return this.doWhen(ConditionKey.CK_LESS_THAN, orderValue);
    }

    public HpMobConnectedBean when_GreaterEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_GREATER_EQUAL, orderValue);
    }

    public HpMobConnectedBean when_LessEqual(Object orderValue) {
        return this.doWhen(ConditionKey.CK_LESS_EQUAL, orderValue);
    }

    public HpMobConnectedBean when_IsNull() {
        return this.doWhen(ConditionKey.CK_IS_NULL, null);
    }

    public HpMobConnectedBean when_IsNotNull() {
        return this.doWhen(ConditionKey.CK_IS_NOT_NULL, null);
    }

    public HpMobConnectedBean when_FromTo(Date fromDate, Date toDate, FromToOption option) {
        return this.doWhen_FromTo(fromDate, toDate, option);
    }

    public HpMobConnectedBean when_DateFromTo(Date fromDate, Date toDate) {
        return this.doWhen_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected HpMobConnectedBean doWhen_FromTo(Date fromDate, Date toDate, FromToOption option) {
        if (option == null) {
            String msg = "The argument 'option' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        ConditionKey fromDateConditionKey = option.getFromDateConditionKey();
        ConditionKey toDateConditionKey = option.getToDateConditionKey();
        Date filteredFromDate = option.filterFromDate(fromDate);
        Date filteredToDate = option.filterToDate(toDate);
        return this.doWhen(fromDateConditionKey, filteredFromDate).doAnd(toDateConditionKey, filteredToDate);
    }

    public void acceptOrderValueList(List<? extends Object> orderValueList) {
        if (orderValueList == null) {
            String msg = "The argument 'orderValueList' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        for (Object object : orderValueList) {
            this.when_Equal(object);
        }
    }

    protected HpMobConnectedBean doWhen(ConditionKey conditionKey, Object orderValue) {
        if (orderValue == null && !this.isManualOrderConditionKeyNullHandling(conditionKey)) {
            String msg = "The argument 'orderValue' should not be null: conditionKey=" + conditionKey;
            throw new IllegalArgumentException(msg);
        }
        HpMobCaseWhenElement addedElement = this.createElement(conditionKey, orderValue);
        if (this._connectionMode != null) {
            HpMobCaseWhenElement previousConnected;
            HpMobConnectionMode previousMode;
            if (this._caseWhenAcceptedList.isEmpty()) {
                this.throwManualOrderPreviousConditionNotFoundException(this._connectionMode, conditionKey, orderValue);
            }
            addedElement.setConnectionMode(this._connectionMode);
            HpMobCaseWhenElement lastElement = this.getAcceptedLastElement();
            List<HpMobCaseWhenElement> connectedElementList = lastElement.getConnectedElementList();
            if (!connectedElementList.isEmpty() && (previousMode = (previousConnected = connectedElementList.get(connectedElementList.size() - 1)).getConnectionMode()) != null && !previousMode.equals((Object)addedElement.getConnectionMode())) {
                this.throwManualOrderTwoConnectorUnsupportedException(conditionKey, orderValue, lastElement);
            }
            lastElement.addConnectedElement(addedElement);
        } else {
            this._caseWhenAcceptedList.add(addedElement);
        }
        return this.createConnectedBean();
    }

    protected boolean isManualOrderConditionKeyNullHandling(ConditionKey conditionKey) {
        return conditionKey.equals(ConditionKey.CK_IS_NULL) || conditionKey.equals(ConditionKey.CK_IS_NOT_NULL);
    }

    protected HpMobCaseWhenElement getAcceptedLastElement() {
        return this._caseWhenAcceptedList.get(this._caseWhenAcceptedList.size() - 1);
    }

    protected HpMobConnectedBean createConnectedBean() {
        return new HpMobConnectedBean(this);
    }

    protected void throwManualOrderPreviousConditionNotFoundException(HpMobConnectionMode mode, ConditionKey conditionKey, Object orderValue) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found previous condition of 'case when' for connecting next condition.");
        br.addItem("Advice");
        br.addElement("You should set first condition before setting next condition.");
        br.addItem("Connection Mode");
        br.addElement((Object)mode);
        br.addItem("Added ConnectionKey");
        br.addElement(conditionKey);
        br.addItem("Added OrderValue");
        br.addElement(orderValue);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwManualOrderTwoConnectorUnsupportedException(ConditionKey conditionKey, Object orderValue, HpMobCaseWhenElement lastElement) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("both two connectors and/or were set.");
        br.addItem("Advice");
        br.addElement("Unsupported using both two connectors and/or in one case.");
        br.addElement("For example:");
        br.addElement("  (o): when FOO > 1 and FOO < 9 then ...");
        br.addElement("  (o): when FOO >= 1 or FOO >= 9 then ...");
        br.addElement("  (x): when FOO >= 1 and FOO >= 9 or FOO = 20 then ...");
        br.addItem("Added ConditionKey");
        br.addElement(conditionKey);
        br.addItem("Added OrderValue");
        br.addElement(orderValue);
        br.addItem("Fixed ConnectionMode");
        br.addElement((Object)lastElement.getConnectionMode());
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    public void xregisterThenValueToLastElement(Object thenValue) {
        if (thenValue == null) {
            String msg = "The argument 'thenValue' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._caseWhenAcceptedList.isEmpty()) {
            this.throwManualOrderThenValueCaseWhenElementNotFoundException(thenValue);
        }
        HpMobCaseWhenElement lastElement = this.getAcceptedLastElement();
        lastElement.setThenValue(thenValue);
    }

    protected void throwManualOrderThenValueCaseWhenElementNotFoundException(Object thenValue) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found 'case when' element for 'then' value.");
        br.addItem("Advice");
        br.addElement("You should set 'case when' element before setting 'then' value.");
        br.addItem("Added ThenValue");
        br.addElement(thenValue);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    public void elseEnd(Object elseValue) {
        if (elseValue == null) {
            String msg = "The argument 'elseValue' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._caseWhenAcceptedList.isEmpty()) {
            this.throwManualOrderElseValueCaseWhenElementNotFoundException(elseValue);
        }
        this._elseAcceptedValue = elseValue;
    }

    protected void throwManualOrderElseValueCaseWhenElementNotFoundException(Object elseValue) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found 'case when' element for 'else' value.");
        br.addItem("Advice");
        br.addElement("You should set 'case when' element before setting 'else' value.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.elseEnd(0); // *NG");
        br.addElement("  (o):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_Equal(...); // *Don't forget here");
        br.addElement("    mob.elseEnd(0); // OK");
        br.addItem("Added ThenValue");
        br.addElement(elseValue);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    public HpCalculator plus(Number plusValue) {
        this.assertObjectNotNull("plusValue", plusValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.plus(plusValue);
    }

    @Override
    public HpCalculator plus(HpSpecifiedColumn plusColumn) {
        this.assertObjectNotNull("plusColumn", plusColumn);
        this.assertCalculationColumnNumber(plusColumn);
        this.assertSpecifiedDreamCruiseTicket(plusColumn);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.plus(plusColumn);
    }

    @Override
    public HpCalculator minus(Number minusValue) {
        this.assertObjectNotNull("minusValue", minusValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.minus(minusValue);
    }

    @Override
    public HpCalculator minus(HpSpecifiedColumn minusColumn) {
        this.assertObjectNotNull("minusColumn", minusColumn);
        this.assertCalculationColumnNumber(minusColumn);
        this.assertSpecifiedDreamCruiseTicket(minusColumn);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.minus(minusColumn);
    }

    @Override
    public HpCalculator multiply(Number multiplyValue) {
        this.assertObjectNotNull("multiplyValue", multiplyValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.multiply(multiplyValue);
    }

    @Override
    public HpCalculator multiply(HpSpecifiedColumn multiplyColumn) {
        this.assertObjectNotNull("multiplyColumn", multiplyColumn);
        this.assertCalculationColumnNumber(multiplyColumn);
        this.assertSpecifiedDreamCruiseTicket(multiplyColumn);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.multiply(multiplyColumn);
    }

    @Override
    public HpCalculator divide(Number divideValue) {
        this.assertObjectNotNull("divideValue", divideValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.divide(divideValue);
    }

    @Override
    public HpCalculator divide(HpSpecifiedColumn divideColumn) {
        this.assertObjectNotNull("divideColumn", divideColumn);
        this.assertCalculationColumnNumber(divideColumn);
        this.assertSpecifiedDreamCruiseTicket(divideColumn);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.divide(divideColumn);
    }

    @Override
    public HpCalculator convert(ColumnConversionOption option) {
        this.assertObjectNotNull("option", option);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.convert(option);
    }

    @Override
    public HpCalculator left() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.left();
    }

    @Override
    public HpCalculator right() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.right();
    }

    protected void initializeCalcSpecificationIfNeeds() {
        if (this._calcSpecification == null) {
            this._calcSpecification = this.createCalcSpecification();
        }
    }

    protected HpCalcSpecification<ConditionBean> createCalcSpecification() {
        SpecifyQuery<ConditionBean> emptySpecifyQuery = this.createEmptySpecifyQuery();
        HpCalcSpecification<ConditionBean> spec = new HpCalcSpecification<ConditionBean>(emptySpecifyQuery);
        spec.synchronizeSetupSelectByJourneyLogBook();
        return spec;
    }

    protected SpecifyQuery<ConditionBean> createEmptySpecifyQuery() {
        return new SpecifyQuery<ConditionBean>(){

            @Override
            public void specify(ConditionBean cb) {
            }
        };
    }

    public boolean hasOrderByCalculation() {
        return this._calcSpecification != null;
    }

    public HpCalcSpecification<ConditionBean> getOrderByCalculation() {
        return this._calcSpecification;
    }

    public void xinitOrderByCalculation(ConditionBean baseCB, ConditionBean dreamCruiseCB) {
        if (!dreamCruiseCB.xisDreamCruiseShip()) {
            String msg = "The CB was not dream cruise: " + dreamCruiseCB.getClass();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._calcSpecification.setBaseCB(baseCB);
        this._calcSpecification.specify(dreamCruiseCB);
    }

    public void toBeConnectionModeAsAnd() {
        this._connectionMode = HpMobConnectionMode.AND;
    }

    public void toBeConnectionModeAsOr() {
        this._connectionMode = HpMobConnectionMode.OR;
    }

    public void clearConnectionMode() {
        this._connectionMode = null;
    }

    protected HpMobCaseWhenElement createElement(ConditionKey conditionKey, Object orderValue) {
        return new HpMobCaseWhenElement(conditionKey, orderValue);
    }

    public void bind(HpManualOrderThemeListHandler handler) {
        if (!this.hasManualOrder()) {
            return;
        }
        for (HpMobCaseWhenElement topElement : this._caseWhenAcceptedList) {
            HpMobCaseWhenElement boundTopElement = this.doBindCaseWhen(handler, topElement);
            List<HpMobCaseWhenElement> connectedList = topElement.getConnectedElementList();
            for (HpMobCaseWhenElement connectedElement : connectedList) {
                HpMobCaseWhenElement boundConnectedElement = this.doBindCaseWhen(handler, connectedElement);
                boundTopElement.addConnectedElement(boundConnectedElement);
            }
            this._caseWhenBoundList.add(boundTopElement);
        }
        this.doBindElseEnd(handler);
    }

    protected HpMobCaseWhenElement doBindCaseWhen(HpManualOrderThemeListHandler handler, HpMobCaseWhenElement element) {
        ConditionKey conditionKey = element.getConditionKey();
        Object orderValue = this.resolveBoundValue(handler, element.getOrderValue(), false);
        HpMobCaseWhenElement boundElement = this.createElement(conditionKey, orderValue);
        boundElement.setConnectionMode(element.getConnectionMode());
        boundElement.setThenValue(this.resolveBoundValue(handler, element.getThenValue(), this._suppressThenBinding));
        return boundElement;
    }

    protected void doBindElseEnd(HpManualOrderThemeListHandler handler) {
        if (this._elseAcceptedValue != null) {
            this._elseBoundValue = this.resolveBoundValue(handler, this._elseAcceptedValue, this._suppressElseBinding);
        }
    }

    protected Object resolveBoundValue(HpManualOrderThemeListHandler handler, Object plainValue, boolean suppressBinding) {
        Object boundExp;
        if (plainValue == null) {
            return null;
        }
        if (plainValue instanceof HpSpecifiedColumn) {
            return this.resolveDreamCruiseExp(plainValue);
        }
        ClassificationCodeType codeType = null;
        if (plainValue instanceof Classification) {
            Classification cls = (Classification)plainValue;
            plainValue = this.handleClassificationOrderValue(cls);
            codeType = cls.meta().codeType();
        }
        if (suppressBinding) {
            if (plainValue instanceof String) {
                if (this.canBeLiteralClassificationCodeType(codeType)) {
                    boundExp = plainValue;
                } else {
                    String notice = "The binding of string value is unsupported on the DBMS.";
                    this.throwUnsupportedTypeSpecifiedException(notice, plainValue);
                    boundExp = null;
                }
            } else if (plainValue instanceof Number) {
                boundExp = this.buildLiteralNumberExpression(plainValue);
            } else if (plainValue instanceof Date) {
                boundExp = this.buildLiteralDateExpression(plainValue);
            } else {
                String notice = "The binding of the type is unsupported on the DBMS.";
                this.throwUnsupportedTypeSpecifiedException(notice, plainValue);
                boundExp = null;
            }
        } else {
            boundExp = handler.register(THEME_KEY, plainValue);
        }
        return boundExp;
    }

    protected Object resolveDreamCruiseExp(Object plainValue) {
        HpSpecifiedColumn specifiedColumn = (HpSpecifiedColumn)plainValue;
        String columnExp = specifiedColumn.toColumnRealName().toString();
        if (specifiedColumn.hasSpecifyCalculation()) {
            specifiedColumn.xinitSpecifyCalculation();
            HpCalcSpecification<ConditionBean> calcSpecification = specifiedColumn.getSpecifyCalculation();
            return calcSpecification.buildStatementToSpecifidName(columnExp);
        }
        return columnExp;
    }

    protected Object handleClassificationOrderValue(Classification cls) {
        String plainCode = cls.code();
        ClassificationCodeType codeType = cls.meta().codeType();
        Object orderValue = ClassificationCodeType.Number.equals((Object)codeType) ? ("true".equalsIgnoreCase(plainCode) || "false".equalsIgnoreCase(plainCode) ? (Comparable<Boolean>)this.toClassificationBooleanValue(plainCode) : (Comparable<Boolean>)this.toClassificationIntegerValue(plainCode)) : (ClassificationCodeType.Boolean.equals((Object)codeType) ? this.toClassificationBooleanValue(plainCode) : plainCode);
        return orderValue;
    }

    protected Integer toClassificationIntegerValue(String plainCode) {
        return (Integer)DfTypeUtil.toNumber(plainCode, Integer.class);
    }

    protected Boolean toClassificationBooleanValue(String plainCode) {
        return DfTypeUtil.toBoolean(plainCode);
    }

    protected boolean canBeLiteralClassificationCodeType(ClassificationCodeType codeType) {
        return codeType != null && codeType.equals((Object)ClassificationCodeType.Number) && codeType.equals((Object)ClassificationCodeType.Boolean);
    }

    protected String buildLiteralNumberExpression(Object plainValue) {
        return plainValue.toString();
    }

    protected String buildLiteralDateExpression(Object plainValue) {
        return "'" + DfTypeUtil.toString(plainValue, "yyyy-MM-dd HH:mm:ss.SSS") + "'";
    }

    protected void throwUnsupportedTypeSpecifiedException(String notice, Object plainValue) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Advice");
        br.addElement("The binding for the part, 'when' or 'then' or 'else',");
        br.addElement("is unsupported with the value type.");
        br.addItem("Specified Value");
        br.addElement(plainValue.getClass());
        br.addElement(plainValue);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    public ManualOrderBean suppressThenBinding() {
        this._suppressThenBinding = true;
        return this;
    }

    public ManualOrderBean suppressElseBinding() {
        this._suppressElseBinding = true;
        return this;
    }

    public void validate() {
        this.doValidateCaseWhenConstraint();
    }

    protected void doValidateCaseWhenConstraint() {
        boolean elseExists;
        if (this._caseWhenAcceptedList.isEmpty()) {
            return;
        }
        HpMobCaseWhenElement first = this._caseWhenAcceptedList.get(0);
        boolean firstThenExists = first.getThenValue() != null;
        for (HpMobCaseWhenElement current : this._caseWhenAcceptedList) {
            boolean currentThenExists;
            boolean bl = currentThenExists = current.getThenValue() != null;
            if (firstThenExists && !currentThenExists) {
                this.throwManualOrderRequiredThenNotFoundException(current);
                continue;
            }
            if (firstThenExists || !currentThenExists) continue;
            this.throwManualOrderUnnecessaryThenFoundException(current);
        }
        boolean bl = elseExists = this._elseAcceptedValue != null;
        if (firstThenExists && !elseExists) {
            this.throwManualOrderRequiredElseNotFoundException();
        } else if (!firstThenExists && elseExists) {
            String msg = "Found unnecessary 'else', it doesn't need it if PriorityOrder: " + this.toString();
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void throwManualOrderRequiredThenNotFoundException(HpMobCaseWhenElement current) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found 'then', all elements need it (if SwitchOrder).");
        br.addItem("Advice");
        br.addElement("You should set 'then' value to all case-when elements");
        br.addElement("if you want to use SwitchOrder.");
        br.addElement("(settings for 'then' value means SwitchOrder)");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7).then(...);");
        br.addElement("    mob.when_LessThan(3); // *NG");
        br.addElement("  (o):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7).then(...);");
        br.addElement("    mob.when_LessThan(3).then(...); // OK");
        br.addItem("Target Element");
        br.addElement(current);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwManualOrderUnnecessaryThenFoundException(HpMobCaseWhenElement current) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Found unnecessary 'then', all elements doesn't need it (if PriorityOrder).");
        br.addItem("Advice");
        br.addElement("You should NOT set 'then' value to all case-when elements");
        br.addElement("if you want to use PriorityOrder.");
        br.addElement("(No 'then' value means PriorityOrder)");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7);");
        br.addElement("    mob.when_LessThan(3).then(...); // *NG");
        br.addElement("  (o):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7);");
        br.addElement("    mob.when_LessThan(3); // OK");
        br.addItem("Target Element");
        br.addElement(current);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwManualOrderRequiredElseNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found 'else', it needs it (if SwitchOrder).");
        br.addItem("Advice");
        br.addElement("You should set 'else' value if you want to use SwitchOrder.");
        br.addElement("(settings for 'then' value means SwitchOrder)");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7).then(...);");
        br.addElement("    mob.when_LessThan(3).then(...);");
        br.addElement("    cb.query().addOrderBy_...().withManualOrder(mob); // *NG");
        br.addElement("  (o):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7).then(...);");
        br.addElement("    mob.when_LessThan(3).then(...);");
        br.addElement("    mob.elseEnd(3); // OK");
        br.addElement("    cb.query().addOrderBy_...().withManualOrder(mob);");
        br.addItem("CaseWhen Element");
        for (HpMobCaseWhenElement element : this._caseWhenAcceptedList) {
            br.addElement(element);
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwManualOrderUnnecessaryElseNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Found unnecessary 'else', it doesn't need it (if PriorityOrder).");
        br.addItem("Advice");
        br.addElement("You should NOT set 'else' value if you want to use PriorityOrder.");
        br.addElement("(No 'then' value means PriorityOrder)");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7);");
        br.addElement("    mob.when_LessThan(3);");
        br.addElement("    mob.elseEnd(3); // *NG");
        br.addElement("  (o):");
        br.addElement("    ManualOrderBean mob = new ManualOrderBean();");
        br.addElement("    mob.when_GreaterThan(7);");
        br.addElement("    mob.when_LessThan(3);");
        br.addElement("    cb.query().addOrderBy_...().withManualOrder(mob); // OK");
        br.addItem("CaseWhen Element");
        for (HpMobCaseWhenElement element : this._caseWhenAcceptedList) {
            br.addElement(element);
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    public boolean hasManualOrder() {
        return !this._caseWhenAcceptedList.isEmpty() || this._calcSpecification != null;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(HpSpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isObjectNativeTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(HpSpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        return title + ":{case-when=" + this._caseWhenAcceptedList.size() + ", calc=" + this._calcSpecification + "}";
    }

    public List<HpMobCaseWhenElement> getCaseWhenAcceptedList() {
        return this._caseWhenAcceptedList;
    }

    public List<HpMobCaseWhenElement> getCaseWhenBoundList() {
        return this._caseWhenBoundList;
    }

    public Object getElseValue() {
        return this._elseBoundValue;
    }
}

