/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.dbflute.cbean.OrderByBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDefault;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.exception.PagingPageSizeNotPlusException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.twowaysql.pmbean.MapParameterBean;

public class SimplePagingBean
implements PagingBean,
MapParameterBean<Object> {
    protected final SqlClause _sqlClause = new SqlClauseDefault("dummy");
    protected Map<String, Object> _parameterMap;
    protected int _safetyMaxResultSize;
    protected boolean _paging = true;
    protected boolean _pagingCountLater;
    protected boolean _pagingReSelect = true;
    protected boolean _fetchNarrowing = true;

    @Override
    public boolean isPaging() {
        return this._paging;
    }

    @Override
    public boolean canPagingCountLater() {
        return this._pagingCountLater;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._pagingReSelect;
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        if (pageSize <= 0) {
            this.throwPagingPageSizeNotPlusException(pageSize, pageNumber);
        }
        this.fetchFirst(pageSize);
        this.fetchPage(pageNumber);
    }

    protected void throwPagingPageSizeNotPlusException(int pageSize, int pageNumber) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Page size for paging should not be minus or zero!");
        br.addItem("Advice");
        br.addElement("Confirm the value of your parameter 'pageSize'.");
        br.addElement("The first parameter of paging() should be a plus value!");
        br.addElement("For example:");
        br.addElement("  (x): pmb.paging(0, 1);");
        br.addElement("  (x): pmb.paging(-3, 2);");
        br.addElement("  (o): pmb.paging(4, 3);");
        br.addItem("Page Size");
        br.addElement(pageSize);
        br.addItem("Page Number");
        br.addElement(pageNumber);
        String msg = br.buildExceptionMessage();
        throw new PagingPageSizeNotPlusException(msg);
    }

    @Override
    public void xsetPaging(boolean paging) {
        if (paging) {
            this.getSqlClause().reviveFetchScope();
        } else {
            this.getSqlClause().suppressFetchScope();
        }
        this._paging = paging;
    }

    @Override
    public void enablePagingCountLater() {
        this._pagingCountLater = true;
    }

    @Override
    public void disablePagingCountLater() {
        this._pagingCountLater = false;
    }

    @Override
    public void enablePagingReSelect() {
        this._pagingReSelect = true;
    }

    @Override
    public void disablePagingReSelect() {
        this._pagingReSelect = false;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchScope(int fetchStartIndex, int fetchSize) {
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean fetchPage(int fetchPageNumber) {
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public <ENTITY> PagingInvoker<ENTITY> createPagingInvoker(String tableDbName) {
        return new PagingInvoker(tableDbName);
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._fetchNarrowing && this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void xdisableFetchNarrowing() {
        this._fetchNarrowing = false;
    }

    @Override
    public void xenableIgnoredFetchNarrowing() {
        this._fetchNarrowing = true;
    }

    @Override
    public String getOrderByClause() {
        return this.getSqlClause().getOrderByClause();
    }

    @Override
    public OrderByClause getOrderByComponent() {
        return this.getSqlClause().getOrderByComponent();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public Map<String, Object> getParameterMap() {
        this.initializeParameterMapIfNeeds();
        return this._parameterMap;
    }

    public void addParameter(String key, Object value) {
        this.initializeParameterMapIfNeeds();
        this._parameterMap.put(key, value);
    }

    protected void initializeParameterMapIfNeeds() {
        if (this._parameterMap == null) {
            this._parameterMap = new LinkedHashMap<String, Object>();
        }
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected SqlClause getSqlClause() {
        return this._sqlClause;
    }
}

