/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemHeadersSupport;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private String headerEncoding;
    private ProgressListener listener;

    public static final boolean isMultipartContent(RequestContext ctx) {
        String contentType = ctx.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static boolean isMultipartContent(HttpServletRequest req) {
        return ServletFileUpload.isMultipartContent(req);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public List parseRequest(HttpServletRequest req) throws FileUploadException {
        return this.parseRequest(new ServletRequestContext(req));
    }

    public FileItemIterator getItemIterator(RequestContext ctx) throws FileUploadException, IOException {
        return new FileItemIteratorImpl(ctx);
    }

    public List parseRequest(RequestContext ctx) throws FileUploadException {
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        boolean successful = false;
        try {
            FileItemIterator iter = this.getItemIterator(ctx);
            FileItemFactory fac = this.getFileItemFactory();
            if (fac == null) {
                throw new NullPointerException("No FileItemFactory has been set.");
            }
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fileName = ((FileItemIteratorImpl.FileItemStreamImpl)item).name;
                FileItem fileItem = fac.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), fileName);
                items.add(fileItem);
                try {
                    Streams.copy(item.openStream(), fileItem.getOutputStream(), true);
                }
                catch (FileUploadIOException e) {
                    throw (FileUploadException)e.getCause();
                }
                catch (IOException e) {
                    throw new IOFileUploadException("Processing of multipart/form-data request failed. " + e.getMessage(), e);
                }
                if (!(fileItem instanceof FileItemHeadersSupport)) continue;
                FileItemHeaders fih = item.getHeaders();
                ((FileItemHeadersSupport)((Object)fileItem)).setHeaders(fih);
            }
            successful = true;
            ArrayList<FileItem> arrayList = items;
            return arrayList;
        }
        catch (FileUploadIOException e) {
            throw (FileUploadException)e.getCause();
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), e);
        }
        finally {
            if (!successful) {
                Iterator iterator = items.iterator();
                while (iterator.hasNext()) {
                    FileItem fileItem = (FileItem)iterator.next();
                    try {
                        fileItem.delete();
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected String getFileName(Map headers) {
        return this.getFileName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    protected String getFileName(FileItemHeaders headers) {
        return this.getFileName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(pContentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    protected String getFieldName(FileItemHeaders headers) {
        return this.getFieldName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String pContentDisposition) {
        String fieldName = null;
        if (pContentDisposition != null && pContentDisposition.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(pContentDisposition, ';');
            fieldName = (String)params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected String getFieldName(Map headers) {
        return this.getFieldName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    protected FileItem createItem(Map headers, boolean isFormField) throws FileUploadException {
        return this.getFileItemFactory().createItem(this.getFieldName(headers), this.getHeader(headers, CONTENT_TYPE), isFormField, this.getFileName(headers));
    }

    protected FileItemHeaders getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        FileItemHeadersImpl headers = this.newFileItemHeaders();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            String header = headerPart.substring(start, end);
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header = header + " " + headerPart.substring(nonWs, end);
                start = end + 2;
            }
            this.parseHeaderLine(headers, header);
        }
        return headers;
    }

    protected FileItemHeadersImpl newFileItemHeaders() {
        return new FileItemHeadersImpl();
    }

    protected Map parseHeaders(String headerPart) {
        FileItemHeaders headers = this.getParsedHeaders(headerPart);
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iter = headers.getHeaderNames();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            Iterator iter2 = headers.getHeaders(headerName);
            String headerValue = (String)iter2.next();
            while (iter2.hasNext()) {
                headerValue = headerValue + "," + iter2.next();
            }
            result.put(headerName, headerValue);
        }
        return result;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(FileItemHeadersImpl headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        headers.addHeader(headerName, headerValue);
    }

    protected final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    public ProgressListener getProgressListener() {
        return this.listener;
    }

    public void setProgressListener(ProgressListener pListener) {
        this.listener = pListener;
    }

    public static class FileSizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = 8150776562029630058L;
        private String fileName;
        private String fieldName;

        public FileSizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String pFileName) {
            this.fileName = pFileName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String pFieldName) {
            this.fieldName = pFieldName;
        }
    }

    public static class SizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = -2474893167098052828L;

        public SizeLimitExceededException() {
            this(null, 0L, 0L);
        }

        public SizeLimitExceededException(String message) {
            this(message, 0L, 0L);
        }

        public SizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }
    }

    public static class UnknownSizeException
    extends FileUploadException {
        private static final long serialVersionUID = 7062279004812015273L;

        public UnknownSizeException() {
        }

        public UnknownSizeException(String message) {
            super(message);
        }
    }

    protected static abstract class SizeException
    extends FileUploadException {
        private static final long serialVersionUID = -8776225574705254126L;
        private final long actual;
        private final long permitted;

        protected SizeException(String message, long actual, long permitted) {
            super(message);
            this.actual = actual;
            this.permitted = permitted;
        }

        public long getActualSize() {
            return this.actual;
        }

        public long getPermittedSize() {
            return this.permitted;
        }
    }

    public static class IOFileUploadException
    extends FileUploadException {
        private static final long serialVersionUID = 1749796615868477269L;
        private final IOException cause;

        public IOFileUploadException(String pMsg, IOException pException) {
            super(pMsg);
            this.cause = pException;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        private static final long serialVersionUID = -9073026332015646668L;

        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String message) {
            super(message);
        }

        public InvalidContentTypeException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class FileUploadIOException
    extends IOException {
        private static final long serialVersionUID = -7047616958165584154L;
        private final FileUploadException cause;

        public FileUploadIOException(FileUploadException pCause) {
            this.cause = pCause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private class FileItemIteratorImpl
    implements FileItemIterator {
        private final MultipartStream multi;
        private final MultipartStream.ProgressNotifier notifier;
        private final byte[] boundary;
        private FileItemStreamImpl currentItem;
        private String currentFieldName;
        private boolean skipPreamble;
        private boolean itemValid;
        private boolean eof;

        FileItemIteratorImpl(RequestContext ctx) throws FileUploadException, IOException {
            String charEncoding;
            if (ctx == null) {
                throw new NullPointerException("ctx parameter");
            }
            String contentType = ctx.getContentType();
            if (null == contentType || !contentType.toLowerCase().startsWith(FileUploadBase.MULTIPART)) {
                throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
            }
            InputStream input = ctx.getInputStream();
            if (FileUploadBase.this.sizeMax >= 0L) {
                int requestSize = ctx.getContentLength();
                if (requestSize == -1) {
                    input = new LimitedInputStream(input, FileUploadBase.this.sizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            SizeLimitExceededException ex = new SizeLimitExceededException("the request was rejected because its size (" + pCount + ") exceeds the configured maximum" + " (" + pSizeMax + ")", pCount, pSizeMax);
                            throw new FileUploadIOException(ex);
                        }
                    };
                } else if (FileUploadBase.this.sizeMax >= 0L && (long)requestSize > FileUploadBase.this.sizeMax) {
                    throw new SizeLimitExceededException("the request was rejected because its size (" + requestSize + ") exceeds the configured maximum (" + FileUploadBase.this.sizeMax + ")", requestSize, FileUploadBase.this.sizeMax);
                }
            }
            if ((charEncoding = FileUploadBase.this.headerEncoding) == null) {
                charEncoding = ctx.getCharacterEncoding();
            }
            this.boundary = FileUploadBase.this.getBoundary(contentType);
            if (this.boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            this.notifier = new MultipartStream.ProgressNotifier(FileUploadBase.this.listener, ctx.getContentLength());
            try {
                this.multi = new MultipartStream(input, this.boundary, this.notifier);
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidContentTypeException("The boundary specified in the Content-type header is too long", iae);
            }
            this.multi.setHeaderEncoding(charEncoding);
            this.skipPreamble = true;
            this.findNextItem();
        }

        private boolean findNextItem() throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.currentItem != null) {
                this.currentItem.close();
                this.currentItem = null;
            }
            while (true) {
                boolean nextPart;
                if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                    if (this.currentFieldName == null) {
                        this.eof = true;
                        return false;
                    }
                    this.multi.setBoundary(this.boundary);
                    this.currentFieldName = null;
                    continue;
                }
                FileItemHeaders headers = FileUploadBase.this.getParsedHeaders(this.multi.readHeaders());
                if (this.currentFieldName == null) {
                    String fieldName = FileUploadBase.this.getFieldName(headers);
                    if (fieldName != null) {
                        String subContentType = headers.getHeader(FileUploadBase.CONTENT_TYPE);
                        if (subContentType != null && subContentType.toLowerCase().startsWith(FileUploadBase.MULTIPART_MIXED)) {
                            this.currentFieldName = fieldName;
                            byte[] subBoundary = FileUploadBase.this.getBoundary(subContentType);
                            this.multi.setBoundary(subBoundary);
                            this.skipPreamble = true;
                            continue;
                        }
                        String fileName = FileUploadBase.this.getFileName(headers);
                        this.currentItem = new FileItemStreamImpl(fileName, fieldName, headers.getHeader(FileUploadBase.CONTENT_TYPE), fileName == null, this.getContentLength(headers));
                        this.notifier.noteItem();
                        this.itemValid = true;
                        return true;
                    }
                } else {
                    String fileName = FileUploadBase.this.getFileName(headers);
                    if (fileName != null) {
                        this.currentItem = new FileItemStreamImpl(fileName, this.currentFieldName, headers.getHeader(FileUploadBase.CONTENT_TYPE), false, this.getContentLength(headers));
                        this.notifier.noteItem();
                        this.itemValid = true;
                        return true;
                    }
                }
                this.multi.discardBodyData();
            }
        }

        private long getContentLength(FileItemHeaders pHeaders) {
            try {
                return Long.parseLong(pHeaders.getHeader(FileUploadBase.CONTENT_LENGTH));
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public boolean hasNext() throws FileUploadException, IOException {
            if (this.eof) {
                return false;
            }
            if (this.itemValid) {
                return true;
            }
            return this.findNextItem();
        }

        public FileItemStream next() throws FileUploadException, IOException {
            if (this.eof || !this.itemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.itemValid = false;
            return this.currentItem;
        }

        class FileItemStreamImpl
        implements FileItemStream {
            private final String contentType;
            private final String fieldName;
            private final String name;
            private final boolean formField;
            private final InputStream stream;
            private boolean opened;
            private FileItemHeaders headers;

            FileItemStreamImpl(String pName, String pFieldName, String pContentType, boolean pFormField, long pContentLength) throws IOException {
                MultipartStream.ItemInputStream itemStream;
                this.name = pName;
                this.fieldName = pFieldName;
                this.contentType = pContentType;
                this.formField = pFormField;
                InputStream istream = itemStream = FileItemIteratorImpl.this.multi.newInputStream();
                if (FileUploadBase.this.fileSizeMax != -1L) {
                    if (pContentLength != -1L && pContentLength > FileUploadBase.this.fileSizeMax) {
                        FileSizeLimitExceededException e = new FileSizeLimitExceededException("The field " + this.fieldName + " exceeds its maximum permitted " + " size of " + FileUploadBase.this.fileSizeMax + " bytes.", pContentLength, FileUploadBase.this.fileSizeMax);
                        e.setFileName(pName);
                        e.setFieldName(pFieldName);
                        throw new FileUploadIOException(e);
                    }
                    istream = new LimitedInputStream(istream, FileUploadBase.this.fileSizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            itemStream.close(true);
                            FileSizeLimitExceededException e = new FileSizeLimitExceededException("The field " + FileItemStreamImpl.this.fieldName + " exceeds its maximum permitted " + " size of " + pSizeMax + " bytes.", pCount, pSizeMax);
                            e.setFieldName(FileItemStreamImpl.this.fieldName);
                            e.setFileName(FileItemStreamImpl.this.name);
                            throw new FileUploadIOException(e);
                        }
                    };
                }
                this.stream = istream;
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getName() {
                return Streams.checkFileName(this.name);
            }

            public boolean isFormField() {
                return this.formField;
            }

            public InputStream openStream() throws IOException {
                if (this.opened) {
                    throw new IllegalStateException("The stream was already opened.");
                }
                if (((Closeable)((Object)this.stream)).isClosed()) {
                    throw new FileItemStream.ItemSkippedException();
                }
                return this.stream;
            }

            void close() throws IOException {
                this.stream.close();
            }

            public FileItemHeaders getHeaders() {
                return this.headers;
            }

            public void setHeaders(FileItemHeaders pHeaders) {
                this.headers = pHeaders;
            }
        }
    }
}

