/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.hierarchy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchyRequest;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchyRequestElement;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchySourceColumn;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchySourceIterator;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchySourceRow;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfTypeUtil;

public class HierarchyArranger<LOCAL_ENTITY extends Entity> {
    public List<LOCAL_ENTITY> arrangeHierarchy(HierarchyRequest<LOCAL_ENTITY> request) {
        ArrayList<Entity> localTableList = new ArrayList<Entity>();
        HashMap<String, Entity> alreadyRegisteredEntityMap = new HashMap<String, Entity>();
        HierarchySourceIterator sourceIterator = request.getSourceIterator();
        while (sourceIterator.hasNext()) {
            Entity localEntity;
            HierarchySourceRow sourceRow = sourceIterator.next();
            TopInfo<LOCAL_ENTITY> topInfo = new TopInfo<LOCAL_ENTITY>();
            topInfo.setHierarchyRequest(request);
            topInfo.setSourceRow(sourceRow);
            topInfo.setAlreadyRegisteredEntityMap(alreadyRegisteredEntityMap);
            Map<String, Object> primaryKeyMap = this.extractTopPrimaryKeyMapFromSource(topInfo);
            String alreadyRegisteredKey = this.buildTopAlreadyRegisteredKey(primaryKeyMap);
            if (alreadyRegisteredEntityMap.containsKey(alreadyRegisteredKey)) {
                localEntity = (Entity)alreadyRegisteredEntityMap.get(alreadyRegisteredKey);
                topInfo.setLocalEntity(localEntity);
            } else {
                localEntity = this.newLocalEntity(request.getDestinationDBMeta());
                topInfo.setLocalEntity(localEntity);
                localTableList.add(localEntity);
                alreadyRegisteredEntityMap.put(alreadyRegisteredKey, localEntity);
            }
            this.doColumnLoop(topInfo);
        }
        Set entrySet = alreadyRegisteredEntityMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Entity currentRegisteredEntity = (Entity)entry.getValue();
            currentRegisteredEntity.clearModifiedInfo();
            currentRegisteredEntity.markAsSelect();
        }
        return localTableList;
    }

    protected String buildTopAlreadyRegisteredKey(Map<String, Object> primaryKeyMap) {
        return "$top$:" + primaryKeyMap;
    }

    protected void doColumnLoop(TopInfo<LOCAL_ENTITY> topInfo) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Entity localEntity = topInfo.getLocalEntity();
        List<HierarchyRequestElement> requestElementList = request.getRequestElementList();
        for (HierarchyRequestElement requestElement : requestElementList) {
            List<String> relationPropertyNameList = requestElement.getRelationPropertyNameList();
            if (relationPropertyNameList == null || relationPropertyNameList.isEmpty()) {
                HierarchySourceColumn sourceColumn = requestElement.getSourceColumnInfo();
                HierarchySourceRow sourceRow = topInfo.getSourceRow();
                Object sourceColumnValue = this.extractColumnValueFromSource(sourceRow, sourceColumn);
                ColumnInfo destinationColumnInfo = requestElement.getDestinationColumnInfo();
                this.injectColumnValueToDestinationIfNotNull(localEntity, destinationColumnInfo, sourceColumnValue);
                continue;
            }
            this.doRelationLoop(topInfo, requestElement, relationPropertyNameList);
        }
    }

    protected void doRelationLoop(TopInfo<LOCAL_ENTITY> topInfo, HierarchyRequestElement requestElement, List<String> relationPropNameList) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Entity> alreadyRegisteredEntityMap = topInfo.getAlreadyRegisteredEntityMap();
        Entity localEntity = topInfo.getLocalEntity();
        DBMeta localDBMeta = request.getDestinationDBMeta();
        String localRelationPath = "$top$";
        StringBuilder relationPropKeyStringBuilder = new StringBuilder();
        int relationLoopCount = 0;
        for (String relationPropName : relationPropNameList) {
            String alreadyRegisteredEntityKey;
            Map<String, Object> targetPrimaryKeyMap;
            if (relationPropKeyStringBuilder.length() > 0) {
                relationPropKeyStringBuilder.append("_");
            }
            relationPropKeyStringBuilder.append(relationPropName);
            String targetRelationPath = relationPropKeyStringBuilder.toString();
            RelationInfo relationInfo = localDBMeta.findRelationInfo(relationPropName);
            if (!relationInfo.isReferrer()) {
                Entity foreignEntity;
                ForeignInfo foreignInfo = localDBMeta.findForeignInfo(relationPropName);
                String foreignPropName = foreignInfo.getForeignPropertyName();
                if (this.isNotExistPrimaryKey(topInfo, targetRelationPath)) break;
                targetPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, targetRelationPath);
                alreadyRegisteredEntityKey = targetRelationPath + ":" + targetPrimaryKeyMap.toString();
                if (!alreadyRegisteredEntityMap.containsKey(alreadyRegisteredEntityKey)) {
                    foreignEntity = foreignInfo.getForeignDBMeta().newEntity();
                    this.injectForeignEntity(localEntity, foreignPropName, foreignEntity);
                    this.injectForeignPrimaryKey(foreignEntity, targetPrimaryKeyMap);
                    this.injectLocalForeignKey(topInfo, localEntity, foreignInfo, targetRelationPath);
                    alreadyRegisteredEntityMap.put(alreadyRegisteredEntityKey.toString(), foreignEntity);
                } else {
                    foreignEntity = alreadyRegisteredEntityMap.get(alreadyRegisteredEntityKey);
                    this.injectForeignEntity(localEntity, foreignPropName, foreignEntity);
                }
            } else {
                ReferrerInfo referrerInfo = localDBMeta.findReferrerInfo(relationPropName);
                List<Entity> referrerList = this.extractReferrerList(localEntity, referrerInfo);
                if (referrerList == null) {
                    referrerList = new ArrayList<Entity>();
                    this.injectReferrerList(localEntity, referrerInfo, referrerList);
                }
                if (this.isNotExistPrimaryKey(topInfo, targetRelationPath)) break;
                targetPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, targetRelationPath);
                alreadyRegisteredEntityKey = targetRelationPath + ":" + targetPrimaryKeyMap.toString();
                if (!alreadyRegisteredEntityMap.containsKey(alreadyRegisteredEntityKey)) {
                    Entity referrerEntity = relationInfo.getTargetDBMeta().newEntity();
                    referrerList.add(referrerEntity);
                    this.injectReferrerPrimaryKey(referrerEntity, targetPrimaryKeyMap);
                    this.injectReferrerForeignKey(topInfo, referrerEntity, referrerInfo, localRelationPath);
                    alreadyRegisteredEntityMap.put(alreadyRegisteredEntityKey.toString(), referrerEntity);
                }
            }
            localEntity = alreadyRegisteredEntityMap.get(alreadyRegisteredEntityKey);
            localDBMeta = localEntity.getDBMeta();
            localRelationPath = targetRelationPath;
            if (relationLoopCount == relationPropNameList.size() - 1) {
                this.doLastLoopInjection(topInfo, requestElement, localEntity, targetPrimaryKeyMap);
            }
            ++relationLoopCount;
        }
    }

    protected boolean isNotExistPrimaryKey(TopInfo<LOCAL_ENTITY> topInfo, String relationPath) {
        Map<String, Object> primaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, relationPath);
        Set<Map.Entry<String, Object>> entrySet = primaryKeyMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object value = entry.getValue();
            if (value != null) continue;
            return true;
        }
        return false;
    }

    protected void doLastLoopInjection(TopInfo<LOCAL_ENTITY> topInfo, HierarchyRequestElement requestElement, Entity localEntity, Map<String, Object> primaryKeyMap) {
        HierarchySourceColumn sourceColumnInfo;
        HierarchySourceRow sourceRow;
        Object sourceColumnValue;
        ColumnInfo destinationColumnInfo = requestElement.getDestinationColumnInfo();
        if (!primaryKeyMap.containsKey(destinationColumnInfo.getColumnDbName()) && (sourceColumnValue = this.extractColumnValueFromSource(sourceRow = topInfo.getSourceRow(), sourceColumnInfo = requestElement.getSourceColumnInfo())) != null) {
            this.injectColumnValueToDestinationIfNotNull(localEntity, destinationColumnInfo, sourceColumnValue);
        }
    }

    protected Map<String, Object> extractTopPrimaryKeyMapFromSource(TopInfo<LOCAL_ENTITY> topInfo) {
        return this.extractPrimaryKeyMapFromSource(topInfo, "$top$");
    }

    protected Map<String, Object> extractPrimaryKeyMapFromSource(TopInfo<LOCAL_ENTITY> topInfo, String relationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        HierarchySourceRow sourceRow = topInfo.getSourceRow();
        List<HierarchyRequestElement> primaryKeyElement = request.findPrimaryKeyElement(relationPath);
        LinkedHashMap<String, Object> primaryKeyMap = new LinkedHashMap<String, Object>();
        for (HierarchyRequestElement element : primaryKeyElement) {
            HierarchySourceColumn sourcePrimaryKey = element.getSourceColumnInfo();
            Object sourcePrimaryKeyValue = this.extractColumnValueFromSource(sourceRow, sourcePrimaryKey);
            primaryKeyMap.put(element.getDestinationColumnInfo().getColumnDbName(), sourcePrimaryKeyValue);
        }
        return primaryKeyMap;
    }

    protected Object extractColumnValueFromSource(HierarchySourceRow sourceRow, HierarchySourceColumn sourceColumn) {
        return sourceRow.extractColumnValue(sourceColumn);
    }

    protected List<Entity> extractReferrerList(Entity entity, ReferrerInfo referrerInfo) {
        return (List)referrerInfo.read(entity);
    }

    protected void injectColumnValueToDestinationIfNotNull(Entity entity, ColumnInfo columnInfo, Object columnValue) {
        if (columnValue != null) {
            this.injectColumnValueToDestination(entity, columnInfo.getColumnDbName(), columnValue);
        }
    }

    protected void injectColumnValueToDestination(Entity entity, String columnDbName, Object columnValue) {
        if (columnValue == null) {
            String msg = "The argument[columnValue] should not be null: ";
            msg = msg + " table=" + entity.getTableDbName() + " column=" + columnDbName;
            throw new IllegalStateException(msg);
        }
        entity.getDBMeta().findColumnInfo(columnDbName).write(entity, columnValue);
    }

    protected void injectColumnValueMapToDestination(Entity entity, Map<String, Object> columnValueMap) {
        Set<Map.Entry<String, Object>> entrySet = columnValueMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String columnName = entry.getKey();
            Object columnValue = entry.getValue();
            this.injectColumnValueToDestination(entity, columnName, columnValue);
        }
    }

    protected void injectForeignEntity(Entity entity, String foreignPropName, Entity foreignEntity) {
        String capPropReferrerName = this.initCap(foreignPropName);
        Method method = this.findMethod(entity.getClass(), "set" + capPropReferrerName, new Class[]{foreignEntity.getDBMeta().getEntityType()});
        this.invoke(method, entity, new Object[]{foreignEntity});
    }

    protected void injectReferrerList(Entity entity, ReferrerInfo referrerInfo, List<Entity> referrerList) {
        referrerInfo.write(entity, referrerList);
    }

    protected void injectForeignPrimaryKey(Entity foreignEntity, Map<String, Object> foreigPrimaryKeyMap) {
        this.injectColumnValueMapToDestination(foreignEntity, foreigPrimaryKeyMap);
    }

    protected void injectReferrerPrimaryKey(Entity referrerEntity, Map<String, Object> referrerPrimaryKeyMap) {
        this.injectColumnValueMapToDestination(referrerEntity, referrerPrimaryKeyMap);
    }

    protected void injectLocalForeignKey(TopInfo<LOCAL_ENTITY> topInfo, Entity localEntity, ForeignInfo foreignInfo, String foreignRelationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Object> foreignPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, foreignRelationPath);
        List<HierarchyRequestElement> primaryKeyElementList = request.findPrimaryKeyElement(foreignRelationPath);
        HashMap<String, Object> localForeignKeyMap = new HashMap<String, Object>();
        for (HierarchyRequestElement foreignElement : primaryKeyElementList) {
            String foreignPrimaryKeyColumnName = foreignElement.getDestinationColumnInfo().getColumnDbName();
            ColumnInfo localForeignKeyInfo = foreignInfo.findLocalByForeign(foreignPrimaryKeyColumnName);
            Object localForeignKeyValue = foreignPrimaryKeyMap.get(foreignPrimaryKeyColumnName);
            localForeignKeyMap.put(localForeignKeyInfo.getColumnDbName(), localForeignKeyValue);
        }
        this.injectColumnValueMapToDestination(localEntity, localForeignKeyMap);
    }

    protected void injectReferrerForeignKey(TopInfo<LOCAL_ENTITY> topInfo, Entity referrerEntity, ReferrerInfo referrerInfo, String localRelationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Object> localPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, localRelationPath);
        List<HierarchyRequestElement> primaryKeyElementList = request.findPrimaryKeyElement(localRelationPath);
        HashMap<String, Object> referrerForeignKeyMap = new HashMap<String, Object>();
        for (HierarchyRequestElement localElement : primaryKeyElementList) {
            String localPrimaryKeyName = localElement.getDestinationColumnInfo().getColumnDbName();
            ColumnInfo referrerForeignKeyInfo = referrerInfo.findReferrerByLocal(localPrimaryKeyName);
            Object referrerForeignKeyValue = localPrimaryKeyMap.get(localPrimaryKeyName);
            referrerForeignKeyMap.put(referrerForeignKeyInfo.getColumnDbName(), referrerForeignKeyValue);
        }
        this.injectColumnValueMapToDestination(referrerEntity, referrerForeignKeyMap);
    }

    protected LOCAL_ENTITY newLocalEntity(DBMeta destinationDBMeta) {
        Entity localEntity;
        try {
            localEntity = destinationDBMeta.getEntityType().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return (LOCAL_ENTITY)localEntity;
    }

    protected String initCap(String name) {
        String capPropReferrerName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return capPropReferrerName;
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    private Object invoke(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (RuntimeException e) {
            String ln = DBFluteSystem.getBasicLn();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String msg = "Invoking method threw the exception:" + ln;
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ln;
            msg = msg + "[" + DfTypeUtil.toClassTitle(method.getDeclaringClass()) + "." + method.getName() + "()]" + ln;
            msg = msg + " methodArgTypes     = {" + this.createTypeViewFromTypeArray(parameterTypes) + "}" + ln;
            msg = msg + " specifiedArgValues = {" + this.createValueViewFromValueArray(args) + "}" + ln;
            msg = msg + " specifiedArgTypes  = {" + this.createTypeViewFromValueArray(args) + "}" + ln;
            if (parameterTypes.length > 0 && args.length > 0 && args[0] != null && !parameterTypes[0].equals(args[0].getClass())) {
                msg = msg + " " + ln;
                String compareString = "{" + parameterTypes[0] + " -- " + args[0].getClass() + "}";
                msg = msg + " *Warning! The argType is ummatched: " + compareString + ln;
            }
            msg = msg + "* * * * * * * * * */" + ln;
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
    }

    private String createValueViewFromValueArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            Object value = array[i];
            if (sb.length() == 0) {
                sb.append(value);
                continue;
            }
            sb.append(", ").append(value);
        }
        return sb.toString();
    }

    private String createTypeViewFromValueArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String typeName;
            Object value = array[i];
            String string = typeName = value != null ? DfTypeUtil.toClassTitle(value) : "null";
            if (sb.length() == 0) {
                sb.append(typeName);
                continue;
            }
            sb.append(", ").append(typeName);
        }
        return sb.toString();
    }

    private String createTypeViewFromTypeArray(Class<?>[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            Class<?> type = array[i];
            if (sb.length() == 0) {
                sb.append(DfTypeUtil.toClassTitle(type));
                continue;
            }
            sb.append(", ").append(DfTypeUtil.toClassTitle(type));
        }
        return sb.toString();
    }

    protected static class TopInfo<LOCAL_ENTITY extends Entity> {
        private HierarchyRequest<LOCAL_ENTITY> hierarchyRequest;
        private HierarchySourceRow sourceRow;
        private Entity localEntity;
        private Map<String, Entity> alreadyRegisteredEntityMap;

        protected TopInfo() {
        }

        public HierarchySourceRow getSourceRow() {
            return this.sourceRow;
        }

        public void setSourceRow(HierarchySourceRow sourceRow) {
            this.sourceRow = sourceRow;
        }

        public Entity getLocalEntity() {
            return this.localEntity;
        }

        public void setLocalEntity(Entity localEntity) {
            this.localEntity = localEntity;
        }

        public Map<String, Entity> getAlreadyRegisteredEntityMap() {
            return this.alreadyRegisteredEntityMap;
        }

        public void setAlreadyRegisteredEntityMap(Map<String, Entity> alreadyRegisteredEntityMap) {
            this.alreadyRegisteredEntityMap = alreadyRegisteredEntityMap;
        }

        public HierarchyRequest<LOCAL_ENTITY> getHierarchyRequest() {
            return this.hierarchyRequest;
        }

        public void setHierarchyRequest(HierarchyRequest<LOCAL_ENTITY> hierarchyRequest) {
            this.hierarchyRequest = hierarchyRequest;
        }
    }
}

