/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.jdbc.LazyDatabaseMetaDataWrapper;
import org.seasar.dbflute.jdbc.MetaDataConnectionProvider;
import org.seasar.dbflute.optional.RelationOptionalFactory;
import org.seasar.dbflute.resource.ManualThreadDataSourceHandler;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.extension.TnRelationRowOptionalHandler;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGeneratorFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnModifiedPropertySupport;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactoryBuilder;
import org.seasar.dbflute.s2dao.metadata.impl.TnBeanMetaDataFactoryImpl;
import org.seasar.dbflute.s2dao.metadata.impl.TnBeanMetaDataImpl;
import org.seasar.dbflute.s2dao.metadata.impl.TnDBMetaBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeFactoryBuilderImpl;
import org.seasar.dbflute.util.DfTypeUtil;

public class TnBeanMetaDataFactoryExtension
extends TnBeanMetaDataFactoryImpl {
    private static final Log _log = LogFactory.getLog(TnBeanMetaDataFactoryExtension.class);
    protected final TnRelationRowOptionalHandler _relationRowOptionalHandler;
    protected final Map<Class<?>, TnBeanMetaData> _metaMap = this.newConcurrentHashMap();
    protected boolean _internalDebug;

    public TnBeanMetaDataFactoryExtension(RelationOptionalFactory relationOptionalFactory) {
        this._relationRowOptionalHandler = this.createRelationRowOptionalHandler(relationOptionalFactory);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass) {
        TnBeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass, int relationNestLevel) {
        TnBeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass, relationNestLevel);
    }

    @Override
    protected LazyDatabaseMetaDataWrapper createLazyDatabaseMetaDataWrapper(Class<?> beanClass) {
        MetaDataConnectionProvider connectionProvider = this.createMetaDataConnectionProvider();
        LazyDatabaseMetaDataWrapper metaDataWrapper = new LazyDatabaseMetaDataWrapper(connectionProvider);
        metaDataWrapper.restrictMetaData();
        return metaDataWrapper;
    }

    protected MetaDataConnectionProvider createMetaDataConnectionProvider() {
        return new MetaDataConnectionProvider(){

            @Override
            public Connection getConnection() throws SQLException {
                ManualThreadDataSourceHandler handler = TnBeanMetaDataFactoryExtension.this.getManualThreadDataSourceHandler();
                if (handler != null) {
                    return handler.getConnection(TnBeanMetaDataFactoryExtension.this._dataSource);
                }
                return TnBeanMetaDataFactoryExtension.this._dataSource.getConnection();
            }
        };
    }

    protected ManualThreadDataSourceHandler getManualThreadDataSourceHandler() {
        return ManualThreadDataSourceHandler.getDataSourceHandler();
    }

    @Override
    public TnBeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        TnBeanMetaData cachedMeta = this.findOrCreateCachedMetaIfNeeds(dbMetaData, beanClass, relationNestLevel);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(dbMetaData, beanClass, relationNestLevel);
    }

    protected TnBeanMetaData findCachedMeta(Class<?> beanClass) {
        TnBeanMetaData cachedMeta;
        if (this.isDBFluteEntity(beanClass) && (cachedMeta = this.getMetaFromCache(beanClass)) != null) {
            return cachedMeta;
        }
        return null;
    }

    protected TnBeanMetaData findOrCreateCachedMetaIfNeeds(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        if (this.isDBFluteEntity(beanClass)) {
            TnBeanMetaData cachedMeta = this.getMetaFromCache(beanClass);
            if (cachedMeta != null) {
                return cachedMeta;
            }
            return super.createBeanMetaData(dbMetaData, beanClass, 0);
        }
        return null;
    }

    @Override
    protected TnBeanMetaDataImpl createBeanMetaDataImpl(Class<?> beanClass) {
        DBMeta dbmeta = this.provideDBMeta(beanClass);
        return new TnBeanMetaDataImpl(beanClass, dbmeta){
            protected final List<TnIdentifierGenerator> _internalIdentifierGeneratorList;
            protected final Map<String, TnIdentifierGenerator> _internalIdentifierGeneratorsByPropertyName;
            {
                this._internalIdentifierGeneratorList = new ArrayList<TnIdentifierGenerator>();
                this._internalIdentifierGeneratorsByPropertyName = TnBeanMetaDataFactoryExtension.this.newConcurrentHashMap();
            }

            @Override
            public void initialize() {
                TnBeanMetaData cachedMeta;
                Class<?> myBeanClass = this.getBeanClass();
                if (TnBeanMetaDataFactoryExtension.this.isDBFluteEntity(myBeanClass) && (cachedMeta = TnBeanMetaDataFactoryExtension.this.getMetaFromCache(myBeanClass)) == null) {
                    if (TnBeanMetaDataFactoryExtension.this.isInternalDebugEnabled()) {
                        _log.debug((Object)("...Caching the bean: " + DfTypeUtil.toClassTitle(myBeanClass)));
                    }
                    TnBeanMetaDataFactoryExtension.this._metaMap.put(myBeanClass, this);
                }
                super.initialize();
            }

            @Override
            protected void setupIdentifierGenerator(TnPropertyType propertyType) {
                DfPropertyDesc pd = propertyType.getPropertyDesc();
                String propertyName = propertyType.getPropertyName();
                String idType = this._beanAnnotationReader.getId(pd);
                TnIdentifierGenerator generator = this.createInternalIdentifierGenerator(propertyType, idType);
                this._internalIdentifierGeneratorList.add(generator);
                this._internalIdentifierGeneratorsByPropertyName.put(propertyName, generator);
            }

            protected TnIdentifierGenerator createInternalIdentifierGenerator(TnPropertyType propertyType, String idType) {
                return TnIdentifierGeneratorFactory.createIdentifierGenerator(propertyType, idType);
            }

            @Override
            public TnIdentifierGenerator getIdentifierGenerator(int index) {
                return this._internalIdentifierGeneratorList.get(index);
            }

            @Override
            public int getIdentifierGeneratorSize() {
                return this._internalIdentifierGeneratorList.size();
            }

            @Override
            public TnIdentifierGenerator getIdentifierGenerator(String propertyName) {
                return this._internalIdentifierGeneratorsByPropertyName.get(propertyName);
            }
        };
    }

    @Override
    protected TnModifiedPropertySupport createModifiedPropertySupport() {
        return new TnModifiedPropertySupport(){

            @Override
            public Set<String> getModifiedPropertyNames(Object bean) {
                if (bean instanceof Entity) {
                    return ((Entity)bean).modifiedProperties();
                }
                DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(bean.getClass());
                String propertyName = "modifiedPropertyNames";
                if (!beanDesc.hasPropertyDesc("modifiedPropertyNames")) {
                    return Collections.EMPTY_SET;
                }
                DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc("modifiedPropertyNames");
                Object value = propertyDesc.getValue(bean);
                if (value != null) {
                    return (Set)value;
                }
                return Collections.EMPTY_SET;
            }
        };
    }

    @Override
    protected TnBeanAnnotationReader createBeanAnnotationReader(Class<?> beanClass) {
        return new TnDBMetaBeanAnnotationReader(beanClass);
    }

    @Override
    protected TnRelationPropertyTypeFactory createRelationPropertyTypeFactory(Class<?> beanClass, TnBeanMetaDataImpl localBeanMetaData, TnBeanAnnotationReader beanAnnotationReader, DatabaseMetaData dbMetaData, int relationNestLevel, boolean stopRelationCreation) {
        TnRelationPropertyTypeFactoryBuilder builder = this.createRelationPropertyTypeFactoryBuilder();
        return builder.build(beanClass, localBeanMetaData, beanAnnotationReader, dbMetaData, relationNestLevel, stopRelationCreation, this.getRelationOptionalEntityType());
    }

    protected TnRelationPropertyTypeFactoryBuilder createRelationPropertyTypeFactoryBuilder() {
        return new TnRelationPropertyTypeFactoryBuilderImpl(this);
    }

    protected Class<?> getRelationOptionalEntityType() {
        return this._relationRowOptionalHandler.getOptionalEntityType();
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }

    @Override
    public TnRelationRowOptionalHandler getRelationRowOptionalHandler() {
        return this._relationRowOptionalHandler;
    }

    protected TnRelationRowOptionalHandler createRelationRowOptionalHandler(RelationOptionalFactory factory) {
        return new TnRelationRowOptionalHandler(factory);
    }

    protected boolean isDBFluteEntity(Class<?> beanClass) {
        return Entity.class.isAssignableFrom(beanClass);
    }

    protected DBMeta provideDBMeta(Class<?> entityType) {
        return ResourceContext.provideDBMeta(entityType);
    }

    protected TnBeanMetaData getMetaFromCache(Class<?> beanClass) {
        return this._metaMap.get(beanClass);
    }

    private boolean isInternalDebugEnabled() {
        return ResourceContext.isInternalDebug() && _log.isDebugEnabled();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }
}

