/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.identity;

import javax.sql.DataSource;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbway.WayOfSQLServer;
import org.seasar.dbflute.dbway.WayOfSybase;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.identity.TnIdentityAdjustmentSqlHandler;

public class TnIdentityGenerationHandler {
    public void disableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        if (this.isDatabaseSQLServer()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String disableSql = this.getWayOfSQLServer().buildIdentityDisableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
        } else if (this.isDatabaseSybase()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String disableSql = this.getWayOfSybase().buildIdentityDisableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
        }
    }

    public void enableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        if (this.isDatabaseSQLServer()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String enableSql = this.getWayOfSQLServer().buildIdentityEnableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
        } else if (this.isDatabaseSybase()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String enableSql = this.getWayOfSybase().buildIdentityEnableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
        }
    }

    protected DBMeta findDBMeta(String tableDbName) {
        return ResourceContext.dbmetaProvider().provideDBMeta(tableDbName);
    }

    protected boolean isDatabaseSQLServer() {
        return ResourceContext.isCurrentDBDef(DBDef.SQLServer);
    }

    protected boolean isDatabaseSybase() {
        return ResourceContext.isCurrentDBDef(DBDef.Sybase);
    }

    protected WayOfSQLServer getWayOfSQLServer() {
        return (WayOfSQLServer)ResourceContext.currentDBDef().dbway();
    }

    protected WayOfSybase getWayOfSybase() {
        return (WayOfSybase)ResourceContext.currentDBDef().dbway();
    }

    protected void doExecuteIdentityAdjustment(String sql, DataSource dataSource, StatementFactory statementFactory) {
        TnIdentityAdjustmentSqlHandler handler = this.createIdentityAdjustmentSqlHandler(sql, dataSource, statementFactory);
        handler.execute(new Object[0]);
    }

    protected TnIdentityAdjustmentSqlHandler createIdentityAdjustmentSqlHandler(String sql, DataSource dataSource, StatementFactory statementFactory) {
        return new TnIdentityAdjustmentSqlHandler(dataSource, statementFactory, sql);
    }
}

