/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(name="NameNodeActivity", about="NameNode metrics", context="dfs")
public class NameNodeMetrics {
    final MetricsRegistry registry = new MetricsRegistry("namenode");
    @Metric
    MutableCounterLong createFileOps;
    @Metric
    MutableCounterLong filesCreated;
    @Metric
    MutableCounterLong filesAppended;
    @Metric
    MutableCounterLong getBlockLocations;
    @Metric
    MutableCounterLong filesRenamed;
    @Metric
    MutableCounterLong getListingOps;
    @Metric
    MutableCounterLong deleteFileOps;
    @Metric(value={"Number of files/dirs deleted by delete or rename operations"})
    MutableCounterLong filesDeleted;
    @Metric
    MutableCounterLong fileInfoOps;
    @Metric
    MutableCounterLong addBlockOps;
    @Metric
    MutableCounterLong getAdditionalDatanodeOps;
    @Metric
    MutableCounterLong createSymlinkOps;
    @Metric
    MutableCounterLong getLinkTargetOps;
    @Metric
    MutableCounterLong filesInGetListingOps;
    @Metric(value={"Number of allowSnapshot operations"})
    MutableCounterLong allowSnapshotOps;
    @Metric(value={"Number of disallowSnapshot operations"})
    MutableCounterLong disallowSnapshotOps;
    @Metric(value={"Number of createSnapshot operations"})
    MutableCounterLong createSnapshotOps;
    @Metric(value={"Number of deleteSnapshot operations"})
    MutableCounterLong deleteSnapshotOps;
    @Metric(value={"Number of renameSnapshot operations"})
    MutableCounterLong renameSnapshotOps;
    @Metric(value={"Number of listSnapshottableDirectory operations"})
    MutableCounterLong listSnapshottableDirOps;
    @Metric(value={"Number of snapshotDiffReport operations"})
    MutableCounterLong snapshotDiffReportOps;
    @Metric(value={"Journal transactions"})
    MutableRate transactions;
    @Metric(value={"Journal syncs"})
    MutableRate syncs;
    MutableQuantiles[] syncsQuantiles;
    @Metric(value={"Journal transactions batched in sync"})
    MutableCounterLong transactionsBatchedInSync;
    @Metric(value={"Block report"})
    MutableRate blockReport;
    MutableQuantiles[] blockReportQuantiles;
    @Metric(value={"Duration in SafeMode at startup"})
    MutableGaugeInt safeModeTime;
    @Metric(value={"Time loading FS Image at startup"})
    MutableGaugeInt fsImageLoadTime;

    NameNodeMetrics(String processName, String sessionId, int[] intervals) {
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, processName).tag((MetricsInfo)MsInfo.SessionId, sessionId);
        int len = intervals.length;
        this.syncsQuantiles = new MutableQuantiles[len];
        this.blockReportQuantiles = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.syncsQuantiles[i] = this.registry.newQuantiles("syncs" + interval + "s", "Journal syncs", "ops", "latency", interval);
            this.blockReportQuantiles[i] = this.registry.newQuantiles("blockReport" + interval + "s", "Block report", "ops", "latency", interval);
        }
    }

    public static NameNodeMetrics create(Configuration conf, HdfsServerConstants.NamenodeRole r) {
        String sessionId = conf.get("dfs.metrics.session-id");
        String processName = r.toString();
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics.create((String)processName, (String)sessionId, (MetricsSystem)ms);
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        return (NameNodeMetrics)ms.register((Object)new NameNodeMetrics(processName, sessionId, intervals));
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incrGetBlockLocations() {
        this.getBlockLocations.incr();
    }

    public void incrFilesCreated() {
        this.filesCreated.incr();
    }

    public void incrCreateFileOps() {
        this.createFileOps.incr();
    }

    public void incrFilesAppended() {
        this.filesAppended.incr();
    }

    public void incrAddBlockOps() {
        this.addBlockOps.incr();
    }

    public void incrGetAdditionalDatanodeOps() {
        this.getAdditionalDatanodeOps.incr();
    }

    public void incrFilesRenamed() {
        this.filesRenamed.incr();
    }

    public void incrFilesDeleted(long delta) {
        this.filesDeleted.incr(delta);
    }

    public void incrDeleteFileOps() {
        this.deleteFileOps.incr();
    }

    public void incrGetListingOps() {
        this.getListingOps.incr();
    }

    public void incrFilesInGetListingOps(int delta) {
        this.filesInGetListingOps.incr((long)delta);
    }

    public void incrFileInfoOps() {
        this.fileInfoOps.incr();
    }

    public void incrCreateSymlinkOps() {
        this.createSymlinkOps.incr();
    }

    public void incrGetLinkTargetOps() {
        this.getLinkTargetOps.incr();
    }

    public void incrAllowSnapshotOps() {
        this.allowSnapshotOps.incr();
    }

    public void incrDisAllowSnapshotOps() {
        this.disallowSnapshotOps.incr();
    }

    public void incrCreateSnapshotOps() {
        this.createSnapshotOps.incr();
    }

    public void incrDeleteSnapshotOps() {
        this.deleteSnapshotOps.incr();
    }

    public void incrRenameSnapshotOps() {
        this.renameSnapshotOps.incr();
    }

    public void incrListSnapshottableDirOps() {
        this.listSnapshottableDirOps.incr();
    }

    public void incrSnapshotDiffReportOps() {
        this.snapshotDiffReportOps.incr();
    }

    public void addTransaction(long latency) {
        this.transactions.add(latency);
    }

    public void incrTransactionsBatchedInSync() {
        this.transactionsBatchedInSync.incr();
    }

    public void addSync(long elapsed) {
        this.syncs.add(elapsed);
        for (MutableQuantiles q : this.syncsQuantiles) {
            q.add(elapsed);
        }
    }

    public void setFsImageLoadTime(long elapsed) {
        this.fsImageLoadTime.set((int)elapsed);
    }

    public void addBlockReport(long latency) {
        this.blockReport.add(latency);
        for (MutableQuantiles q : this.blockReportQuantiles) {
            q.add(latency);
        }
    }

    public void setSafeModeTime(long elapsed) {
        this.safeModeTime.set((int)elapsed);
    }
}

