/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.sqlclause.subquery;

import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClause;
import org.codelibs.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnRealName;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.util.Srl;

public class SubQueryClause {
    protected final SubQueryPath _subQueryPath;
    protected final String _selectClause;
    protected final SqlClause _subQuerySqlClause;
    protected final String _localAliasName;

    public SubQueryClause(SubQueryPath subQueryPath, String selectClause, SqlClause subQuerySqlClause, String localAliasName) {
        this._subQueryPath = subQueryPath;
        this._selectClause = selectClause;
        this._subQuerySqlClause = subQuerySqlClause;
        this._localAliasName = localAliasName;
    }

    public String buildPlainSubQueryFromWhereClause(String correlatedFixedCondition) {
        if (correlatedFixedCondition == null) {
            String clause = this._subQuerySqlClause.getClauseFromWhereWithUnionTemplate();
            clause = this.resolveParameterLocationPath(clause, this._subQueryPath);
            clause = this.replaceString(clause, this.getUnionSelectClauseMark(), this._selectClause);
            clause = this.replaceString(clause, this.getUnionWhereClauseMark(), "");
            clause = this.replaceString(clause, this.getUnionWhereFirstConditionMark(), "");
            return clause;
        }
        String correlationCondition = correlatedFixedCondition;
        String firstConditionAfter = this.ln() + "   and ";
        String clause = this._subQuerySqlClause.getClauseFromWhereWithWhereUnionTemplate();
        clause = this.resolveParameterLocationPath(clause, this._subQueryPath);
        clause = this.replaceString(clause, this.getWhereClauseMark(), this.ln() + " where " + correlationCondition);
        clause = this.replaceString(clause, this.getWhereFirstConditionMark(), correlationCondition + firstConditionAfter);
        clause = this.replaceString(clause, this.getUnionSelectClauseMark(), this._selectClause);
        clause = this.replaceString(clause, this.getUnionWhereClauseMark(), this.ln() + " where " + correlationCondition);
        clause = this.replaceString(clause, this.getUnionWhereFirstConditionMark(), correlationCondition + firstConditionAfter);
        return clause;
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnRealName correlatedColumnRealName, ColumnSqlName relatedColumnSqlName, String correlatedFixedCondition) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        String joinCondition = this._localAliasName + "." + relatedColumnSqlName + " = " + correlatedColumnRealName;
        return this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition, correlatedFixedCondition);
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnRealName[] correlatedColumnRealNames, ColumnSqlName[] relatedColumnSqlNames, String correlatedFixedCondition) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < relatedColumnSqlNames.length; ++i) {
            if (sb.length() > 0) {
                sb.append(this.ln()).append("   and ");
            }
            sb.append(this._localAliasName).append(".").append(relatedColumnSqlNames[i]);
            sb.append(" = ").append(correlatedColumnRealNames[i]);
        }
        String joinCondition = sb.toString();
        clause = this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition, correlatedFixedCondition);
        return clause;
    }

    protected String xprepareCorrelationSubQueryFromWhereClause() {
        String clause = this._subQuerySqlClause.getClauseFromWhereWithWhereUnionTemplate();
        return this.resolveParameterLocationPath(clause, this._subQueryPath);
    }

    protected String xreplaceCorrelationSubQueryFromWhereClause(String clause, String joinCondition, String fixedCondition) {
        String correlationCondition = fixedCondition != null && fixedCondition.trim().length() > 0 ? joinCondition + this.ln() + "   and " + fixedCondition : joinCondition;
        String firstConditionAfter = this.ln() + "   and ";
        clause = this.replaceString(clause, this.getWhereClauseMark(), this.ln() + " where " + correlationCondition);
        clause = this.replaceString(clause, this.getWhereFirstConditionMark(), correlationCondition + firstConditionAfter);
        clause = this.replaceString(clause, this.getUnionSelectClauseMark(), this._selectClause);
        clause = this.replaceString(clause, this.getUnionWhereClauseMark(), this.ln() + " where " + correlationCondition);
        clause = this.replaceString(clause, this.getUnionWhereFirstConditionMark(), correlationCondition + firstConditionAfter);
        return clause;
    }

    protected String resolveParameterLocationPath(String clause, SubQueryPath subQueryPath) {
        return subQueryPath.resolveParameterLocationPath(clause);
    }

    protected String getBasePointAliasName() {
        return this._subQuerySqlClause.getBasePointAliasName();
    }

    protected String getWhereClauseMark() {
        return this._subQuerySqlClause.getWhereClauseMark();
    }

    protected String getWhereFirstConditionMark() {
        return this._subQuerySqlClause.getWhereFirstConditionMark();
    }

    protected String getUnionSelectClauseMark() {
        return this._subQuerySqlClause.getUnionSelectClauseMark();
    }

    protected String getUnionWhereClauseMark() {
        return this._subQuerySqlClause.getUnionWhereClauseMark();
    }

    protected String getUnionWhereFirstConditionMark() {
        return this._subQuerySqlClause.getUnionWhereFirstConditionMark();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

