/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.sqlclause.subquery;

import java.io.Serializable;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.util.Srl;

public class SubQueryIndentProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BEGIN_MARK_PREFIX = "--#df:sqbegin#";
    public static final String END_MARK_PREFIX = "--#df:sqend#";
    public static final String IDENTITY_TERMINAL = "#df:idterm#";

    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return BEGIN_MARK_PREFIX + subQueryIdentity + IDENTITY_TERMINAL;
    }

    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return END_MARK_PREFIX + subQueryIdentity + IDENTITY_TERMINAL;
    }

    public String processSubQueryIndent(String sql, String preIndent, String originalSql) {
        String beginMarkPrefix = BEGIN_MARK_PREFIX;
        if (!sql.contains(BEGIN_MARK_PREFIX)) {
            return sql;
        }
        String[] lines = sql.split(SubQueryIndentProcessor.ln());
        String endMarkPrefix = END_MARK_PREFIX;
        String identityTerminal = IDENTITY_TERMINAL;
        int terminalLength = IDENTITY_TERMINAL.length();
        StringBuilder mainSb = new StringBuilder();
        StringBuilder subSb = null;
        boolean throughBegin = false;
        boolean throughBeginFirst = false;
        String subQueryIdentity = null;
        String indent = null;
        for (String line : lines) {
            String clause;
            String msg;
            int terminalIndex;
            int markIndex;
            if (!throughBegin) {
                if (line.contains(BEGIN_MARK_PREFIX)) {
                    throughBegin = true;
                    subSb = new StringBuilder();
                    markIndex = line.indexOf(BEGIN_MARK_PREFIX);
                    terminalIndex = line.indexOf(IDENTITY_TERMINAL);
                    if (terminalIndex < 0) {
                        msg = "Identity terminal was not found at the begin line: [" + line + "]";
                        throw new SubQueryIndentFailureException(msg);
                    }
                    clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                    subQueryIdentity = line.substring(markIndex + BEGIN_MARK_PREFIX.length(), terminalIndex);
                    subSb.append(clause);
                    indent = this.buildSpaceBar(markIndex - preIndent.length());
                    continue;
                }
                if (this.needsLineConnection(mainSb)) {
                    mainSb.append(SubQueryIndentProcessor.ln());
                }
                mainSb.append(line).append(SubQueryIndentProcessor.ln());
                continue;
            }
            if (line.contains(END_MARK_PREFIX + subQueryIdentity)) {
                markIndex = line.indexOf(END_MARK_PREFIX);
                terminalIndex = line.indexOf(IDENTITY_TERMINAL);
                if (terminalIndex < 0) {
                    msg = "Identity terminal was not found at the begin line: [" + line + "]";
                    throw new SubQueryIndentFailureException(msg);
                }
                clause = line.substring(0, markIndex);
                String preRemainder = line.substring(terminalIndex + terminalLength);
                subSb.append(clause);
                String subQuerySql = subSb.toString();
                String nestedPreIndent = preIndent + indent;
                String currentSql = this.processSubQueryIndent(subQuerySql, nestedPreIndent, originalSql);
                if (this.needsLineConnection(mainSb)) {
                    mainSb.append(SubQueryIndentProcessor.ln());
                }
                mainSb.append(currentSql);
                if (Srl.is_NotNull_and_NotTrimmedEmpty(preRemainder)) {
                    mainSb.append(preRemainder);
                }
                throughBegin = false;
                throughBeginFirst = false;
                continue;
            }
            if (!throughBeginFirst) {
                subSb.append(line.trim()).append(SubQueryIndentProcessor.ln());
                throughBeginFirst = true;
                continue;
            }
            subSb.append(indent).append(line).append(SubQueryIndentProcessor.ln());
        }
        String filteredSql = Srl.rtrim(mainSb.toString());
        if (throughBegin) {
            this.throwSubQueryNotFoundEndMarkException(subQueryIdentity, sql, filteredSql, originalSql);
        }
        if (filteredSql.contains(BEGIN_MARK_PREFIX)) {
            this.throwSubQueryAnyBeginMarkNotHandledException(subQueryIdentity, sql, filteredSql, originalSql);
        }
        return filteredSql;
    }

    protected boolean needsLineConnection(StringBuilder sb) {
        int length = sb.length();
        if (length == 0) {
            return false;
        }
        String lastStr = sb.substring(length - 1, length);
        return !lastStr.equals(SubQueryIndentProcessor.ln());
    }

    protected void throwSubQueryNotFoundEndMarkException(String subQueryIdentity, String sql, String filteredSql, String originalSql) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the end mark for sub-query.");
        br.addItem("SubQueryIdentity");
        br.addElement(subQueryIdentity);
        br.addItem("Before Filter");
        br.addElement(sql);
        br.addItem("After Filter");
        br.addElement(filteredSql);
        br.addItem("Original SQL");
        br.addElement(originalSql);
        String msg = br.buildExceptionMessage();
        throw new SubQueryIndentFailureException(msg);
    }

    protected void throwSubQueryAnyBeginMarkNotHandledException(String subQueryIdentity, String sql, String filteredSql, String originalSql) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Any begin marks are not handled.");
        br.addItem("SubQueryIdentity");
        br.addElement(subQueryIdentity);
        br.addItem("Before Filter");
        br.addElement(sql);
        br.addItem("After Filter");
        br.addElement(filteredSql);
        br.addItem("Original SQL");
        br.addElement(originalSql);
        String msg = br.buildExceptionMessage();
        throw new SubQueryIndentFailureException(msg);
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static boolean hasSubQueryBeginOnFirstLine(String exp) {
        String firstLine;
        String sqbegin = BEGIN_MARK_PREFIX;
        return exp.contains(SubQueryIndentProcessor.ln()) && (firstLine = Srl.substringFirstFront(exp, SubQueryIndentProcessor.ln())).contains(BEGIN_MARK_PREFIX);
    }

    public static boolean hasSubQueryEndOnLastLine(String exp) {
        String lastLine;
        String sqend = END_MARK_PREFIX;
        return exp.contains(SubQueryIndentProcessor.ln()) && (lastLine = Srl.substringLastRear(exp, SubQueryIndentProcessor.ln())).contains(END_MARK_PREFIX);
    }

    public static String moveSubQueryEndToRear(String exp) {
        String sqend = END_MARK_PREFIX;
        String idterm = IDENTITY_TERMINAL;
        Srl.ScopeInfo lastScope = Srl.extractScopeLast(exp, END_MARK_PREFIX, IDENTITY_TERMINAL);
        String scopeStr = lastScope.getScope();
        String front = exp.substring(0, lastScope.getBeginIndex());
        String rear = exp.substring(lastScope.getEndIndex());
        return front + rear + scopeStr;
    }

    protected String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected static String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public static class SubQueryIndentFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SubQueryIndentFailureException(String msg) {
            super(msg);
        }
    }
}

