/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.optional;

import org.codelibs.robot.dbflute.exception.EntityAlreadyDeletedException;
import org.codelibs.robot.dbflute.exception.NonSetupSelectRelationAccessException;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.optional.BaseOptional;
import org.codelibs.robot.dbflute.optional.OptionalObject;
import org.codelibs.robot.dbflute.optional.OptionalObjectConsumer;
import org.codelibs.robot.dbflute.optional.OptionalObjectExceptionThrower;
import org.codelibs.robot.dbflute.optional.OptionalObjectFunction;
import org.codelibs.robot.dbflute.optional.OptionalObjectPredicate;

public class OptionalEntity<ENTITY>
extends BaseOptional<ENTITY> {
    protected static final OptionalEntity<Object> EMPTY_INSTANCE = new OptionalEntity<Object>(null, new OptionalObjectExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            String msg = "The empty optional so the value is null.";
            throw new EntityAlreadyDeletedException(msg);
        }
    });
    protected static final OptionalObjectExceptionThrower NOWAY_THROWER = new OptionalObjectExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            throw new EntityAlreadyDeletedException("no way");
        }
    };

    public OptionalEntity(ENTITY entity, OptionalObjectExceptionThrower thrower) {
        super(entity, thrower);
    }

    public static <EMPTY> OptionalEntity<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <ENTITY> OptionalEntity<ENTITY> of(ENTITY entity) {
        if (entity == null) {
            String msg = "The argument 'entity' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalEntity<ENTITY>(entity, NOWAY_THROWER);
    }

    public static <ENTITY> OptionalEntity<ENTITY> ofNullable(ENTITY entity, OptionalObjectExceptionThrower thrower) {
        if (entity != null) {
            return OptionalEntity.of(entity);
        }
        return new OptionalEntity<ENTITY>(entity, thrower);
    }

    public static <EMPTY> OptionalEntity<EMPTY> relationEmpty(final Object entity, final String relation) {
        if (entity == null) {
            String msg = "The argument 'entity' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (relation == null) {
            String msg = "The argument 'relation' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalEntity<Object>(null, new OptionalObjectExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                OptionalEntity.throwNonSetupSelectRelationAccessException(entity, relation);
            }
        });
    }

    protected static void throwNonSetupSelectRelationAccessException(Object entity, String relation) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("NON-setupSelect relation was accessed.");
        br.addItem("Advice");
        br.addElement("Confirm your access to the relation.");
        br.addElement("Call setupSelect or fix your access.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    MemberCB cb = new MemberCB()");
        br.addElement("    cb.setupSelect_MemberStatus();");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb);");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        ... = member.getMemberSecurityAsOne().required(...); // *NG");
        br.addElement("    }");
        br.addElement("  (o): (fix access mistake)");
        br.addElement("    MemberCB cb = new MemberCB()");
        br.addElement("    cb.setupSelect_MemberStatus();");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb);");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        ... = member.getMemberStatus().required(...); // OK");
        br.addElement("    }");
        br.addElement("  (o): (fix setupSelect mistake)");
        br.addElement("    MemberCB cb = new MemberCB()");
        br.addElement("    cb.setupSelect_MemberSecurityAsOne(); // OK");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb);");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        ... = member.getMemberSecurityAsOne().required(...);");
        br.addElement("    }");
        br.addItem("Your Relation");
        br.addElement(entity.getClass().getSimpleName() + "." + relation);
        String msg = br.buildExceptionMessage();
        throw new NonSetupSelectRelationAccessException(msg);
    }

    public ENTITY get() {
        return (ENTITY)this.directlyGet();
    }

    public void ifPresent(OptionalObjectConsumer<ENTITY> consumer) {
        this.callbackIfPresent(consumer);
    }

    public boolean isPresent() {
        return this.exists();
    }

    public OptionalEntity<ENTITY> filter(OptionalObjectPredicate<ENTITY> predicate) {
        return (OptionalEntity)this.callbackFilter(predicate);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    public <RESULT> OptionalObject<RESULT> map(OptionalObjectFunction<? super ENTITY, ? extends RESULT> mapper) {
        return (OptionalObject)this.callbackMapping(mapper);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    public ENTITY orElseNull() {
        return this.directlyGetOrElse(null);
    }

    public void required(OptionalObjectConsumer<ENTITY> consumer) {
        this.callbackRequired(consumer);
    }
}

