/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.codelibs.robot.dbflute.helper.beans.DfBeanDesc;
import org.codelibs.robot.dbflute.helper.beans.DfPropertyDesc;
import org.codelibs.robot.dbflute.jdbc.Classification;
import org.codelibs.robot.dbflute.s2dao.metadata.TnAbstractPropertyTypeFactory;
import org.codelibs.robot.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.codelibs.robot.dbflute.s2dao.metadata.TnPropertyType;

public class TnDBMetaPropertyTypeFactory
extends TnAbstractPropertyTypeFactory {
    protected DBMeta _dbmeta;

    public TnDBMetaPropertyTypeFactory(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader) {
        super(beanClass, beanAnnotationReader);
        this.initializeResources();
    }

    protected void initializeResources() {
        if (this.isEntity()) {
            this._dbmeta = this.findDBMeta();
        }
    }

    protected boolean isEntity() {
        return Entity.class.isAssignableFrom(this._beanClass);
    }

    protected DBMeta findDBMeta() {
        try {
            Entity entity = (Entity)this._beanClass.newInstance();
            return entity.getDBMeta();
        }
        catch (Exception e) {
            String msg = "beanClass.newInstance() threw the exception: beanClass=" + this._beanClass;
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public TnPropertyType[] createBeanPropertyTypes() {
        ArrayList<TnPropertyType> list = new ArrayList<TnPropertyType>();
        DfBeanDesc beanDesc = this.getBeanDesc();
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            DfPropertyDesc pd = beanDesc.getPropertyDesc(proppertyName);
            if (!pd.isWritable() && !this.isColumn(pd) || this.isClassification(pd) || this.isRelation(pd)) continue;
            TnPropertyType pt = this.createPropertyType(pd);
            pt.setPrimaryKey(this.isPrimaryKey(pd));
            pt.setPersistent(this.isPersistent(pt));
            list.add(pt);
        }
        return list.toArray(new TnPropertyType[list.size()]);
    }

    protected boolean isColumn(DfPropertyDesc propertyDesc) {
        return this.hasDBMeta() ? this._dbmeta.hasColumn(propertyDesc.getPropertyName()) : false;
    }

    protected boolean isClassification(DfPropertyDesc propertyDesc) {
        return Classification.class.isAssignableFrom(propertyDesc.getPropertyType());
    }

    protected boolean isRelation(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        if (this.hasDBMeta() && (this._dbmeta.hasForeign(propertyName) || this._dbmeta.hasReferrer(propertyName))) {
            return true;
        }
        return this.hasRelationNoAnnotation(propertyDesc);
    }

    protected boolean hasRelationNoAnnotation(DfPropertyDesc propertyDesc) {
        return this._beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected boolean isPrimaryKey(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        if (this.hasDBMeta() && this._dbmeta.hasPrimaryKey() && this._dbmeta.hasColumn(propertyName) && this._dbmeta.findColumnInfo(propertyName).isPrimary()) {
            return true;
        }
        return this.hasIdAnnotation(propertyDesc);
    }

    protected boolean hasIdAnnotation(DfPropertyDesc propertyDesc) {
        return this._beanAnnotationReader.getId(propertyDesc) != null;
    }

    protected boolean isPersistent(TnPropertyType propertyType) {
        String propertyName = propertyType.getPropertyName();
        DfPropertyDesc propertyDesc = propertyType.getPropertyDesc();
        return this.hasDBMeta() && this._dbmeta.hasColumn(propertyName) || this.hasColumnAnnotation(propertyDesc);
    }

    protected boolean hasColumnAnnotation(DfPropertyDesc propertyDesc) {
        return this._beanAnnotationReader.getColumnAnnotation(propertyDesc) != null;
    }

    protected boolean hasDBMeta() {
        return this._dbmeta != null;
    }

    @Override
    protected ColumnSqlName getColumnSqlName(String columnDbName) {
        if (this.hasDBMeta() && this._dbmeta.hasColumn(columnDbName)) {
            return this._dbmeta.findColumnInfo(columnDbName).getColumnSqlName();
        }
        return new ColumnSqlName(columnDbName);
    }

    @Override
    protected ColumnInfo getEntityColumnInfo(String columnDbName) {
        if (this.hasDBMeta() && this._dbmeta.hasColumn(columnDbName)) {
            return this._dbmeta.findColumnInfo(columnDbName);
        }
        return null;
    }
}

