/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.valuetype.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codelibs.robot.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.codelibs.robot.dbflute.util.DfResourceUtil;

public class BinaryStreamType
extends TnAbstractValueType {
    public BinaryStreamType() {
        super(-2);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return rs.getBinaryStream(index);
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return rs.getBinaryStream(columnName);
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toBinaryStream(cs.getBytes(index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toBinaryStream(cs.getBytes(parameterName));
    }

    private InputStream toBinaryStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            ps.setBinaryStream(index, is, DfResourceUtil.available(is));
        } else {
            ps.setObject(index, value);
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            cs.setBinaryStream(parameterName, is, DfResourceUtil.available(is));
        } else {
            cs.setObject(parameterName, value);
        }
    }
}

