/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.taglib;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.ActionUtil;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.ResponseUtil;
import org.seasar.struts.util.RoutingUtil;
import org.seasar.struts.util.URLEncoderUtil;

public class S2Functions {
    private static final int HIGHEST_SPECIAL = 62;
    private static String BR = "<br />";
    private static String NBSP = "&nbsp;";
    private static char[][] specialCharactersRepresentation = new char[63][];

    public static String h(Object input) {
        Class<?> clazz;
        if (input == null) {
            return "";
        }
        String str = "";
        str = input.getClass().isArray() ? ((clazz = input.getClass().getComponentType()) == String.class ? Arrays.toString((Object[])input) : (clazz == Boolean.TYPE ? Arrays.toString((boolean[])input) : (clazz == Integer.TYPE ? Arrays.toString((int[])input) : (clazz == Long.TYPE ? Arrays.toString((long[])input) : (clazz == Byte.TYPE ? Arrays.toString((byte[])input) : (clazz == Short.TYPE ? Arrays.toString((short[])input) : (clazz == Float.TYPE ? Arrays.toString((float[])input) : (clazz == Double.TYPE ? Arrays.toString((double[])input) : (clazz == Character.TYPE ? Arrays.toString((char[])input) : Arrays.toString((Object[])input)))))))))) : input.toString();
        return S2Functions.escape(str);
    }

    public static String escape(String buffer) {
        int start = 0;
        int length = buffer.length();
        char[] arrayBuffer = buffer.toCharArray();
        StringBuilder escapedBuffer = null;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = arrayBuffer[i];
            if (c > '>' || (escaped = specialCharactersRepresentation[c]) == null) continue;
            if (start == 0) {
                escapedBuffer = new StringBuilder(length + 5);
            }
            if (start < i) {
                escapedBuffer.append(arrayBuffer, start, i - start);
            }
            start = i + 1;
            escapedBuffer.append(escaped);
        }
        if (start == 0) {
            return buffer;
        }
        if (start < length) {
            escapedBuffer.append(arrayBuffer, start, length - start);
        }
        return escapedBuffer.toString();
    }

    public static String u(String input) {
        return URLEncoderUtil.encode(input);
    }

    public static String url(String input) {
        String contextPath = RequestUtil.getRequest().getContextPath();
        StringBuilder sb = new StringBuilder();
        if (contextPath.length() > 1) {
            sb.append(contextPath);
        }
        if (StringUtil.isEmpty((String)input)) {
            sb.append(ActionUtil.calcActionPath());
        } else if (!input.startsWith("/")) {
            sb.append(ActionUtil.calcActionPath()).append(input);
        } else {
            String[] names = StringUtil.split((String)input, (String)"/");
            S2Container container = SingletonS2ContainerFactory.getContainer();
            StringBuilder sb2 = new StringBuilder(50);
            String input2 = input;
            for (int i = 0; i < names.length; ++i) {
                if (container.hasComponentDef((Object)(sb2 + names[i] + "Action"))) {
                    String actionPath = RoutingUtil.getActionPath(names, i);
                    String paramPath = RoutingUtil.getParamPath(names, i + 1);
                    if (StringUtil.isEmpty((String)paramPath)) {
                        input2 = actionPath + "/";
                        break;
                    }
                }
                sb2.append(names[i] + "_");
            }
            sb.append(input2);
        }
        return ResponseUtil.getResponse().encodeURL(sb.toString());
    }

    public static Date date(String input, String pattern) {
        if (StringUtil.isEmpty((String)input)) {
            return null;
        }
        if (StringUtil.isEmpty((String)pattern)) {
            throw new NullPointerException("pattern");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.parse(input);
        }
        catch (ParseException e) {
            throw new ParseRuntimeException(e);
        }
    }

    public static Number number(String input, String pattern) {
        if (StringUtil.isEmpty((String)input)) {
            return null;
        }
        if (StringUtil.isEmpty((String)pattern)) {
            throw new NullPointerException("pattern");
        }
        try {
            DecimalFormat format = new DecimalFormat(pattern);
            return format.parse(input);
        }
        catch (ParseException e) {
            throw new ParseRuntimeException(e);
        }
    }

    public static String br(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return "";
        }
        return input.replaceAll("\r\n", BR).replaceAll("\r", BR).replaceAll("\n", BR);
    }

    public static String nbsp(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return "";
        }
        return input.replaceAll(" ", NBSP);
    }

    public static String label(Object value, List dataList, String valueName, String labelName) {
        if (valueName == null) {
            throw new NullPointerException("valueName");
        }
        if (labelName == null) {
            throw new NullPointerException("labelName");
        }
        if (dataList == null) {
            throw new NullPointerException("dataList");
        }
        for (Object o : dataList) {
            Object v;
            if (o instanceof Map) {
                Map m = (Map)o;
                v = m.get(valueName);
                if (!S2Functions.equals(value, v)) continue;
                return (String)m.get(labelName);
            }
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(o.getClass());
            v = beanDesc.getPropertyDesc(valueName).getValue(o);
            if (!S2Functions.equals(value, v)) continue;
            return (String)beanDesc.getPropertyDesc(labelName).getValue(o);
        }
        return "";
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof String && StringUtil.isEmpty((String)((String)o2));
        }
        if (o2 == null) {
            return o1 instanceof String && StringUtil.isEmpty((String)((String)o1));
        }
        if (o1.getClass() == o2.getClass()) {
            return o1.equals(o2);
        }
        return o1.toString().equals(o2.toString());
    }

    static {
        S2Functions.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        S2Functions.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        S2Functions.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        S2Functions.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        S2Functions.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

