/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.memory.FSTTermOutputs;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class FSTTermsWriter
extends FieldsConsumer {
    static final String TERMS_EXTENSION = "tmp";
    static final String TERMS_CODEC_NAME = "FST_TERMS_DICT";
    public static final int TERMS_VERSION_START = 0;
    public static final int TERMS_VERSION_CHECKSUM = 1;
    public static final int TERMS_VERSION_CURRENT = 1;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    IndexOutput out;
    final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.postingsWriter = postingsWriter;
        this.fieldInfos = state.fieldInfos;
        this.out = state.directory.createOutput(termsFileName, state.context);
        boolean success = false;
        try {
            this.writeHeader(this.out);
            this.postingsWriter.init(this.out);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader((DataOutput)out, (String)TERMS_CODEC_NAME, (int)1);
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    public TermsConsumer addField(FieldInfo field) throws IOException {
        return new TermsWriter(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            block8: {
                block6: {
                    if (this.out == null) break block7;
                    boolean success = false;
                    try {
                        long dirStart = this.out.getFilePointer();
                        this.out.writeVInt(this.fields.size());
                        for (FieldMetaData field : this.fields) {
                            this.out.writeVInt(field.fieldInfo.number);
                            this.out.writeVLong(field.numTerms);
                            if (field.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                                this.out.writeVLong(field.sumTotalTermFreq);
                            }
                            this.out.writeVLong(field.sumDocFreq);
                            this.out.writeVInt(field.docCount);
                            this.out.writeVInt(field.longsSize);
                            field.dict.save((DataOutput)this.out);
                        }
                        this.writeTrailer(this.out, dirStart);
                        CodecUtil.writeFooter((IndexOutput)this.out);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                        }
                        this.out = null;
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                    break block8;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.postingsWriter});
            }
            this.out = null;
        }
    }

    final class TermsWriter
    extends TermsConsumer {
        private final Builder<FSTTermOutputs.TermData> builder;
        private final FSTTermOutputs outputs;
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms = 0L;
        private final IntsRefBuilder scratchTerm = new IntsRefBuilder();
        private final RAMOutputStream statsWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.longsSize = FSTTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.outputs = new FSTTermOutputs(fieldInfo, this.longsSize);
            this.builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)this.outputs);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            FSTTermsWriter.this.postingsWriter.startTerm();
            return FSTTermsWriter.this.postingsWriter;
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            BlockTermState state = FSTTermsWriter.this.postingsWriter.newTermState();
            FSTTermOutputs.TermData meta = new FSTTermOutputs.TermData();
            meta.longs = new long[this.longsSize];
            meta.bytes = null;
            meta.docFreq = state.docFreq = stats.docFreq;
            meta.totalTermFreq = state.totalTermFreq = stats.totalTermFreq;
            FSTTermsWriter.this.postingsWriter.finishTerm(state);
            FSTTermsWriter.this.postingsWriter.encodeTerm(meta.longs, (DataOutput)this.metaWriter, this.fieldInfo, state, true);
            int bytesSize = (int)this.metaWriter.getFilePointer();
            if (bytesSize > 0) {
                meta.bytes = new byte[bytesSize];
                this.metaWriter.writeTo(meta.bytes, 0);
                this.metaWriter.reset();
            }
            this.builder.add(Util.toIntsRef((BytesRef)text, (IntsRefBuilder)this.scratchTerm), (Object)meta);
            ++this.numTerms;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.numTerms > 0L) {
                FST fst = this.builder.finish();
                FSTTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, sumTotalTermFreq, sumDocFreq, docCount, this.longsSize, (FST<FSTTermOutputs.TermData>)fst));
            }
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        public final int longsSize;
        public final FST<FSTTermOutputs.TermData> dict;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize, FST<FSTTermOutputs.TermData> fst) {
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
            this.dict = fst;
        }
    }
}

