/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.typesafe.config.Config;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.stdlib.PatternMetricFilter;

public final class StartReportingMetricsToCSVBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("startReportingMetricsToCSV");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new StartReportingMetricsToCSV(this, config, parent, child, context);
    }

    private static final class StartReportingMetricsToCSV
    extends AbstractCommand {
        private final File outputDir;
        private static final Map<MetricRegistry, Map<File, CsvReporter>> REGISTRIES = new IdentityHashMap<MetricRegistry, Map<File, CsvReporter>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StartReportingMetricsToCSV(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            MetricFilter filter = PatternMetricFilter.parse(this.getConfigs(), config);
            TimeUnit defaultDurationUnit = this.getConfigs().getTimeUnit(config, "defaultDurationUnit", TimeUnit.MILLISECONDS);
            TimeUnit defaultRateUnit = this.getConfigs().getTimeUnit(config, "defaultRateUnit", TimeUnit.SECONDS);
            long frequency = this.getConfigs().getNanoseconds(config, "frequency", 10000000000L);
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace("availableLocales: {}", (Object)Joiner.on((String)"\n").join((Object[])Locale.getAvailableLocales()));
            }
            Locale locale = this.getConfigs().getLocale(config, "locale", Locale.getDefault());
            this.outputDir = new File(this.getConfigs().getString(config, "outputDir"));
            this.validateArguments();
            MetricRegistry registry = context.getMetricRegistry();
            Map<MetricRegistry, Map<File, CsvReporter>> map = REGISTRIES;
            synchronized (map) {
                CsvReporter reporter;
                Map<File, CsvReporter> reporters = REGISTRIES.get(registry);
                if (reporters == null) {
                    reporters = new HashMap<File, CsvReporter>();
                    REGISTRIES.put(registry, reporters);
                }
                if ((reporter = reporters.get(this.outputDir)) == null) {
                    CsvReporter.Builder reporterBuilder = CsvReporter.forRegistry((MetricRegistry)registry).filter(filter).convertDurationsTo(defaultDurationUnit).convertRatesTo(defaultRateUnit).formatFor(locale);
                    reporter = reporterBuilder.build(this.outputDir);
                    this.outputDir.mkdirs();
                    if (!this.outputDir.isDirectory()) {
                        throw new MorphlineCompilationException("Directory not found: " + this.outputDir, config);
                    }
                    if (!this.outputDir.canWrite()) {
                        throw new MorphlineCompilationException("Directory not writeable: " + this.outputDir, config);
                    }
                    reporter.start(frequency, TimeUnit.NANOSECONDS);
                    reporters.put(this.outputDir, reporter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents(notification)) {
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                Map<MetricRegistry, Map<File, CsvReporter>> map = REGISTRIES;
                synchronized (map) {
                    CsvReporter reporter;
                    Map<File, CsvReporter> reporters = REGISTRIES.get(this.getContext().getMetricRegistry());
                    if (reporters != null && (reporter = reporters.remove(this.outputDir)) != null) {
                        reporter.stop();
                    }
                }
            }
            super.doNotify(notification);
        }
    }
}

