/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ComponentContext;
import org.restlet.engine.util.ChildContext;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Restlet
implements Uniform {
    private static final String UNABLE_TO_START = "Unable to start the Restlet";
    private volatile String author;
    private volatile Context context;
    private volatile String description;
    private volatile Class<? extends Finder> finderClass;
    private volatile String name;
    private volatile String owner;
    private volatile boolean started;

    private static void fireContextChanged(Restlet restlet, Context context) {
        if (context != null) {
            if (context instanceof ChildContext) {
                ChildContext childContext = (ChildContext)context;
                if (childContext.getChild() == null) {
                    childContext.setChild(restlet);
                }
            } else if (!(restlet instanceof Component) && context instanceof ComponentContext) {
                context.getLogger().severe("For security reasons, don't pass the component context to child Restlets anymore. Use the Context#createChildContext() method instead. " + restlet.getClass());
            }
        }
    }

    public Restlet() {
        this(null);
    }

    public Restlet(Context context) {
        this.context = context;
        this.started = false;
        this.name = this.toString();
        this.description = null;
        this.author = null;
        this.owner = null;
        this.finderClass = null;
        if (Engine.getInstance() == null) {
            Context.getCurrentLogger().severe("Unable to fully initialize the Restlet. No Restlet engine available.");
            throw new RuntimeException("Unable to fully initialize the Restlet. No Restlet engine available.");
        }
        Restlet.fireContextChanged(this, context);
    }

    public Finder createFinder(Class<? extends ServerResource> resourceClass) {
        Finder result = null;
        result = this.getFinderClass() != null ? Finder.createFinder(resourceClass, this.getFinderClass(), this.getContext(), this.getLogger()) : (this.getApplication() != null && this.getApplication() != this ? this.getApplication().createFinder(resourceClass) : Finder.createFinder(resourceClass, Finder.class, this.getContext(), this.getLogger()));
        return result;
    }

    protected void finalize() throws Throwable {
        if (this.isStarted()) {
            this.stop();
        }
    }

    public Application getApplication() {
        return Application.getCurrent();
    }

    public String getAuthor() {
        return this.author;
    }

    public Context getContext() {
        return this.context;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    public Logger getLogger() {
        Logger result = null;
        Context context = this.getContext();
        if (context == null) {
            context = Context.getCurrent();
        }
        if (context != null) {
            result = context.getLogger();
        }
        if (result == null) {
            result = Engine.getLogger(this, "org.restlet");
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public final Response handle(Request request) {
        Response response = new Response(request);
        this.handle(request, response);
        return response;
    }

    @Override
    public void handle(Request request, Response response) {
        Response.setCurrent(response);
        if (this.getContext() != null) {
            Context.setCurrent(this.getContext());
        }
        if (this.isStopped()) {
            try {
                this.start();
            }
            catch (Exception e) {
                if (this.getContext() != null) {
                    this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START, e);
                } else {
                    Context.getCurrentLogger().log(Level.WARNING, UNABLE_TO_START, e);
                }
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
            if (!this.isStarted()) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public final void handle(Request request, Response response, Uniform onResponseCallback) {
        request.setOnResponse(onResponseCallback);
        this.handle(request, response);
    }

    public final void handle(Request request, Uniform onReceivedCallback) {
        Response response = new Response(request);
        this.handle(request, response, onReceivedCallback);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setContext(Context context) {
        this.context = context;
        Restlet.fireContextChanged(this, context);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }
}

