/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.BytePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DConstructor;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.DVector;
import opendap.dap.Float32PrimitiveVector;
import opendap.dap.Float64PrimitiveVector;
import opendap.dap.Int16PrimitiveVector;
import opendap.dap.Int32PrimitiveVector;
import opendap.dap.PrimitiveVector;
import opendap.dap.UInt16PrimitiveVector;
import opendap.dap.UInt32PrimitiveVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequenceNested;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DodsV;

public class ConvertD2N {
    private static Logger logger = LoggerFactory.getLogger(DODSNetcdfFile.class);

    public Array convertNestedVariable(Variable v, List<Range> section, DodsV dataV, boolean flatten) throws IOException, DAP2Exception {
        Array data = this.convertTopVariable(v, section, dataV);
        if (flatten) {
            ArrayStructure as = (ArrayStructure)data;
            ArrayList<String> names = new ArrayList<String>();
            Variable nested = v;
            while (nested.isMemberOfStructure()) {
                names.add(0, nested.getShortName());
                nested = nested.getParentStructure();
            }
            StructureMembers.Member m = this.findNested(as, names, v.getShortName());
            Array mdata = m.getDataArray();
            if (mdata instanceof ArraySequenceNested) {
                ArraySequenceNested arraySeq = (ArraySequenceNested)mdata;
                return arraySeq.flatten();
            }
            return mdata;
        }
        return data;
    }

    private StructureMembers.Member findNested(ArrayStructure as, List<String> names, String want) {
        String name = names.get(0);
        StructureMembers sm = as.getStructureMembers();
        StructureMembers.Member m = sm.findMember(name);
        if (name.equals(want)) {
            return m;
        }
        ArrayStructure nested = (ArrayStructure)m.getDataArray();
        names.remove(0);
        return this.findNested(nested, names, want);
    }

    public Array convertTopVariable(Variable v, List<Range> section, DodsV dataV) throws IOException, DAP2Exception {
        Array data = this.convert(dataV);
        if (dataV.darray != null && dataV.bt instanceof DString) {
            if (v.getDataType() == DataType.STRING) {
                return this.convertStringArray(data, v);
            }
            if (v.getDataType() == DataType.CHAR) {
                return this.convertStringArrayToChar(dataV.darray, v, section);
            }
            String mess = "DODSVariable convertArray String invalid dataType= " + (Object)((Object)v.getDataType());
            logger.error(mess);
            throw new IllegalArgumentException(mess);
        }
        if (dataV.bt instanceof DString && v.getDataType() == DataType.CHAR) {
            return this.convertStringToChar(data, v);
        }
        return data;
    }

    public Array convert(DodsV dataV) throws IOException, DAP2Exception {
        if (dataV.darray == null) {
            if (dataV.bt instanceof DStructure) {
                ArrayStructure structArray = this.makeArrayStructure(dataV);
                this.iconvertDataStructure((DConstructor)((DStructure)dataV.bt), structArray.getStructureMembers());
                return structArray;
            }
            if (dataV.bt instanceof DGrid) {
                throw new IllegalStateException("DGrid without a darray");
            }
            if (dataV.bt instanceof DSequence) {
                ArrayStructure structArray = this.makeArrayStructure(dataV);
                this.iconvertDataSequenceArray((DSequence)dataV.bt, structArray.getStructureMembers());
                return structArray;
            }
            DataType dtype = DODSNetcdfFile.convertToNCType(dataV.elemType);
            Array scalarData = Array.factory(dtype, new int[0]);
            IndexIterator scalarIndex = scalarData.getIndexIterator();
            this.iconvertDataPrimitiveScalar(dataV.bt, scalarIndex);
            return scalarData;
        }
        if (dataV.darray != null) {
            if (dataV.bt instanceof DStructure) {
                ArrayStructure structArray = this.makeArrayStructure(dataV);
                this.iconvertDataStructureArray((DVector)dataV.darray, structArray.getStructureMembers());
                return structArray;
            }
            if (dataV.bt instanceof DString) {
                return this.convertStringArray(dataV.darray);
            }
            PrimitiveVector pv = dataV.darray.getPrimitiveVector();
            Object storage = pv.getInternalStorage();
            DataType dtype = DODSNetcdfFile.convertToNCType(dataV.elemType);
            return Array.factory(dtype.getPrimitiveClassType(), this.makeShape(dataV.darray), storage);
        }
        String mess = "Unknown baseType " + dataV.bt.getClass().getName() + " name=" + dataV.getName();
        logger.error(mess);
        throw new IllegalStateException(mess);
    }

    private ArrayStructure makeArrayStructure(DodsV dataV) {
        StructureMembers members = new StructureMembers(dataV.getNetcdfShortName());
        for (DodsV dodsV : dataV.children) {
            Array data;
            StructureMembers.Member m = members.addMember(dodsV.getNetcdfShortName(), null, null, dodsV.getDataType(), dodsV.getShape());
            if (dodsV.bt instanceof DStructure || dodsV.bt instanceof DGrid) {
                data = this.makeArrayStructure(dodsV);
            } else if (dodsV.bt instanceof DSequence) {
                data = this.makeArrayNestedSequence(dodsV);
                m.setShape(data.getShape());
            } else {
                data = Array.factory(dodsV.getDataType(), dodsV.getShapeAll());
            }
            m.setDataArray(data);
            m.setDataObject(data.getIndexIterator());
        }
        return new ArrayStructureMA(members, dataV.getShapeAll());
    }

    private ArrayStructure makeArrayNestedSequence(DodsV dataV) {
        StructureMembers members = new StructureMembers(dataV.getName());
        for (DodsV dodsV : dataV.children) {
            members.addMember(dodsV.getNetcdfShortName(), null, null, dodsV.getDataType(), dodsV.getShape());
        }
        DSequence outerSeq = (DSequence)dataV.parent.bt;
        int outerLength = outerSeq.getRowCount();
        ArraySequenceNested aseq = new ArraySequenceNested(members, outerLength);
        String name = dataV.getName();
        for (int row = 0; row < outerLength; ++row) {
            Vector dv = outerSeq.getRow(row);
            for (int j = 0; j < dv.size(); ++j) {
                BaseType bt = (BaseType)dv.elementAt(j);
                if (!bt.getName().equals(name)) continue;
                DSequence innerSeq = (DSequence)bt;
                int innerLength = innerSeq.getRowCount();
                aseq.setSequenceLength(row, innerLength);
            }
        }
        aseq.finish();
        List<StructureMembers.Member> memberList = members.getMembers();
        for (StructureMembers.Member m : memberList) {
            Array data = m.getDataArray();
            m.setDataObject(data.getIndexIterator());
        }
        return aseq;
    }

    private void iconvertDataStructureArray(DVector darray, StructureMembers members) throws DAP2Exception {
        List<StructureMembers.Member> mlist = members.getMembers();
        for (StructureMembers.Member member : mlist) {
            String name = member.getName();
            IndexIterator ii = (IndexIterator)member.getDataObject();
            BaseTypePrimitiveVector pv = (BaseTypePrimitiveVector)darray.getPrimitiveVector();
            for (int row = 0; row < pv.getLength(); ++row) {
                DStructure ds_data = (DStructure)pv.getValue(row);
                BaseType member_data = ds_data.getVariable(name);
                this.iconvertData(member_data, ii);
            }
        }
    }

    private void iconvertDataSequenceArray(DSequence dseq, StructureMembers members) throws DAP2Exception {
        for (int row = 0; row < dseq.getRowCount(); ++row) {
            Vector dv = dseq.getRow(row);
            for (int j = 0; j < dv.size(); ++j) {
                BaseType member_data = (BaseType)dv.elementAt(j);
                StructureMembers.Member member = members.findMember(member_data.getName());
                IndexIterator ii = (IndexIterator)member.getDataObject();
                this.iconvertData(member_data, ii);
            }
        }
    }

    private void iconvertDataStructure(DConstructor ds, StructureMembers members) throws DAP2Exception {
        List<StructureMembers.Member> mlist = members.getMembers();
        for (StructureMembers.Member member : mlist) {
            IndexIterator ii = (IndexIterator)member.getDataObject();
            String name = member.getName();
            String dodsName = name;
            if (dodsName == null) {
                throw new DAP2Exception("Cant find dodsName for member variable " + name);
            }
            BaseType bt = ds.getVariable(dodsName);
            this.iconvertData(bt, ii);
        }
    }

    private void iconvertData(BaseType dodsVar, IndexIterator ii) throws DAP2Exception {
        if (dodsVar instanceof DSequence) {
            DSequence dseq = (DSequence)dodsVar;
            StructureData sd = (StructureData)ii.getObjectNext();
            this.iconvertDataSequenceArray(dseq, sd.getStructureMembers());
        } else if (dodsVar instanceof DStructure || dodsVar instanceof DGrid) {
            DConstructor ds = (DConstructor)dodsVar;
            StructureData sd = (StructureData)ii.getObjectNext();
            this.iconvertDataStructure(ds, sd.getStructureMembers());
        } else if (dodsVar instanceof DVector) {
            DVector da = (DVector)dodsVar;
            BaseType bt = da.getPrimitiveVector().getTemplate();
            if (bt instanceof DStructure) {
                StructureData sd = (StructureData)ii.getObjectNext();
                this.iconvertDataStructureArray(da, sd.getStructureMembers());
            } else {
                if (bt instanceof DGrid) {
                    throw new UnsupportedOperationException();
                }
                if (bt instanceof DSequence) {
                    throw new UnsupportedOperationException();
                }
                this.iconvertDataPrimitiveArray(da.getPrimitiveVector(), ii);
            }
        } else {
            this.iconvertDataPrimitiveScalar(dodsVar, ii);
        }
    }

    private void iconvertDataPrimitiveScalar(BaseType dodsScalar, IndexIterator ii) {
        if (dodsScalar instanceof DString) {
            String sval = ((DString)dodsScalar).getValue();
            ii.setObjectNext(sval);
        } else if (dodsScalar instanceof DUInt32) {
            int ival = ((DUInt32)dodsScalar).getValue();
            long lval = DataType.unsignedIntToLong(ival);
            ii.setLongNext(lval);
        } else if (dodsScalar instanceof DUInt16) {
            short sval = ((DUInt16)dodsScalar).getValue();
            int ival = DataType.unsignedShortToInt(sval);
            ii.setIntNext(ival);
        } else if (dodsScalar instanceof DFloat32) {
            ii.setFloatNext(((DFloat32)dodsScalar).getValue());
        } else if (dodsScalar instanceof DFloat64) {
            ii.setDoubleNext(((DFloat64)dodsScalar).getValue());
        } else if (dodsScalar instanceof DInt32) {
            ii.setIntNext(((DInt32)dodsScalar).getValue());
        } else if (dodsScalar instanceof DInt16) {
            ii.setShortNext(((DInt16)dodsScalar).getValue());
        } else if (dodsScalar instanceof DByte) {
            ii.setByteNext(((DByte)dodsScalar).getValue());
        } else {
            throw new IllegalArgumentException("DODSVariable extractScalar invalid dataType= " + dodsScalar.getClass().getName());
        }
    }

    private void iconvertDataPrimitiveArray(PrimitiveVector pv, IndexIterator ii) {
        BaseType bt = pv.getTemplate();
        if (bt instanceof DString) {
            BaseTypePrimitiveVector bpv = (BaseTypePrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                DString ds = (DString)bpv.getValue(row);
                ii.setObjectNext(ds.getValue());
            }
        } else if (bt instanceof DUInt32) {
            UInt32PrimitiveVector bpv = (UInt32PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                int ival = bpv.getValue(row);
                long lval = DataType.unsignedIntToLong(ival);
                ii.setLongNext(lval);
            }
        } else if (bt instanceof DUInt16) {
            UInt16PrimitiveVector bpv = (UInt16PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                short sval = bpv.getValue(row);
                int ival = DataType.unsignedShortToInt(sval);
                ii.setIntNext(ival);
            }
        } else if (bt instanceof DFloat32) {
            Float32PrimitiveVector bpv = (Float32PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                ii.setFloatNext(bpv.getValue(row));
            }
        } else if (bt instanceof DFloat64) {
            Float64PrimitiveVector bpv = (Float64PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                ii.setDoubleNext(bpv.getValue(row));
            }
        } else if (bt instanceof DInt32) {
            Int32PrimitiveVector bpv = (Int32PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                ii.setIntNext(bpv.getValue(row));
            }
        } else if (bt instanceof DInt16) {
            Int16PrimitiveVector bpv = (Int16PrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                ii.setShortNext(bpv.getValue(row));
            }
        } else if (bt instanceof DByte) {
            BytePrimitiveVector bpv = (BytePrimitiveVector)pv;
            for (int row = 0; row < bpv.getLength(); ++row) {
                ii.setByteNext(bpv.getValue(row));
            }
        } else {
            throw new IllegalArgumentException("DODSVariable extractScalar invalid dataType= " + bt.getClass().getName());
        }
    }

    private Array convertStringArray(DArray dv) {
        PrimitiveVector pv = dv.getPrimitiveVector();
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)pv;
        int nStrings = btpv.getLength();
        String[] storage = new String[nStrings];
        for (int i = 0; i < nStrings; ++i) {
            DString bb = (DString)btpv.getValue(i);
            storage[i] = bb.getValue();
        }
        return Array.factory(DataType.STRING.getPrimitiveClassType(), this.makeShape(dv), (Object)storage);
    }

    private Array convertStringArray(Array data, Variable ncVar) {
        String[] storage = (String[])data.getStorage();
        int max_len = 0;
        for (String s : storage) {
            max_len = Math.max(max_len, s.length());
        }
        if (max_len > 1) {
            return data;
        }
        int count = 0;
        int n = (int)data.getSize();
        char[] charStorage = new char[n];
        for (String s : storage) {
            if (s.length() <= 0) continue;
            charStorage[count++] = s.charAt(0);
        }
        ncVar.setDataType(DataType.CHAR);
        return Array.factory(DataType.CHAR.getPrimitiveClassType(), data.getShape(), (Object)charStorage);
    }

    private Array convertStringArrayToChar(DArray dv, Variable ncVar, List<Range> section) {
        PrimitiveVector pv = dv.getPrimitiveVector();
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)pv;
        int nStrings = btpv.getLength();
        if (section == null) {
            section = ncVar.getRanges();
        }
        int[] shape = Range.getShape(section);
        int total = (int)Index.computeSize(shape);
        int max_len = 0;
        for (int i = 0; i < nStrings; ++i) {
            DString bb = (DString)btpv.getValue(i);
            String val = bb.getValue();
            max_len = Math.max(max_len, val.length());
        }
        if (max_len == 1) {
            char[] charStorage = new char[total];
            for (int i = 0; i < nStrings; ++i) {
                DString bb = (DString)btpv.getValue(i);
                String val = bb.getValue();
                charStorage[i] = val.length() > 0 ? val.charAt(0) : (char)'\u0000';
            }
            return Array.factory(DataType.CHAR.getPrimitiveClassType(), shape, (Object)charStorage);
        }
        int[] varShape = ncVar.getShape();
        int strLen = varShape[ncVar.getRank() - 1];
        char[] storage = new char[total];
        int pos = 0;
        for (int i = 0; i < nStrings; ++i) {
            DString bb = (DString)btpv.getValue(i);
            String val = bb.getValue();
            int len = Math.min(val.length(), strLen);
            for (int k = 0; k < len; ++k) {
                storage[pos + k] = val.charAt(k);
            }
            pos += strLen;
        }
        return Array.factory(DataType.CHAR.getPrimitiveClassType(), shape, (Object)storage);
    }

    private Array convertStringToChar(Array data, Variable ncVar) {
        String s = (String)data.getObject(Index.scalarIndexImmutable);
        int total = (int)ncVar.getSize();
        char[] storage = new char[total];
        int len = Math.min(s.length(), total);
        for (int k = 0; k < len; ++k) {
            storage[k] = s.charAt(k);
        }
        return Array.factory(DataType.CHAR.getPrimitiveClassType(), ncVar.getShape(), (Object)storage);
    }

    private int[] makeShape(DArray dodsArray) {
        int count = 0;
        Enumeration enumerate = dodsArray.getDimensions();
        while (enumerate.hasMoreElements()) {
            ++count;
            enumerate.nextElement();
        }
        int[] shape = new int[count];
        enumerate = dodsArray.getDimensions();
        count = 0;
        while (enumerate.hasMoreElements()) {
            DArrayDimension dad = (DArrayDimension)enumerate.nextElement();
            shape[count++] = dad.getSize();
        }
        return shape;
    }
}

