/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.util.List;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.filters.ColumnPositionExpression;
import jp.sf.orangesignal.csv.filters.CsvExpressionUtils;

public class ColumnPositionRegexExpression
extends ColumnPositionExpression {
    private Pattern pattern;

    protected ColumnPositionRegexExpression(int position, String pattern) {
        this(position, pattern, 0);
    }

    protected ColumnPositionRegexExpression(int position, String pattern, boolean ignoreCase) {
        this(position, pattern, ignoreCase ? 2 : 0);
    }

    protected ColumnPositionRegexExpression(int position, String pattern, int flags) {
        super(position);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    protected ColumnPositionRegexExpression(int position, Pattern pattern) {
        super(position);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = pattern;
    }

    @Override
    public boolean accept(List<String> values) {
        return CsvExpressionUtils.regex(values, this.position, this.pattern);
    }

    @Override
    public boolean accept(List<String> header, List<String> values) {
        return CsvExpressionUtils.regex(values, this.position, this.pattern);
    }
}

