/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ProxyUsers {
    private static final String CONF_HOSTS = ".hosts";
    public static final String CONF_GROUPS = ".groups";
    public static final String CONF_HADOOP_PROXYUSER = "hadoop.proxyuser.";
    public static final String CONF_HADOOP_PROXYUSER_RE = "hadoop\\.proxyuser\\.";
    private static boolean init = false;
    private static Map<String, Collection<String>> proxyGroups = new HashMap<String, Collection<String>>();
    private static Map<String, Collection<String>> proxyHosts = new HashMap<String, Collection<String>>();

    public static void refreshSuperUserGroupsConfiguration() {
        ProxyUsers.refreshSuperUserGroupsConfiguration(new Configuration());
    }

    public static synchronized void refreshSuperUserGroupsConfiguration(Configuration conf) {
        proxyGroups.clear();
        proxyHosts.clear();
        String regex = "hadoop\\.proxyuser\\.[^.]*\\.groups";
        Map<String, String> allMatchKeys = conf.getValByRegex(regex);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            proxyGroups.put(entry.getKey(), StringUtils.getStringCollection(entry.getValue()));
        }
        regex = "hadoop\\.proxyuser\\.[^.]*\\.hosts";
        allMatchKeys = conf.getValByRegex(regex);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            proxyHosts.put(entry.getKey(), StringUtils.getStringCollection(entry.getValue()));
        }
        init = true;
    }

    public static String getProxySuperuserGroupConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_GROUPS;
    }

    public static String getProxySuperuserIpConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_HOSTS;
    }

    public static synchronized void authorize(UserGroupInformation user, String remoteAddress, Configuration newConf) throws AuthorizationException {
        if (!init) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        if (user.getRealUser() == null) {
            return;
        }
        boolean groupAuthorized = false;
        boolean ipAuthorized = false;
        UserGroupInformation superUser = user.getRealUser();
        Collection<String> allowedUserGroups = proxyGroups.get(ProxyUsers.getProxySuperuserGroupConfKey(superUser.getShortUserName()));
        if (ProxyUsers.isWildcardList(allowedUserGroups)) {
            groupAuthorized = true;
        } else if (allowedUserGroups != null && !allowedUserGroups.isEmpty()) {
            for (String group : user.getGroupNames()) {
                if (!allowedUserGroups.contains(group)) continue;
                groupAuthorized = true;
                break;
            }
        }
        if (!groupAuthorized) {
            throw new AuthorizationException("User: " + superUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
        }
        Collection<String> ipList = proxyHosts.get(ProxyUsers.getProxySuperuserIpConfKey(superUser.getShortUserName()));
        if (ProxyUsers.isWildcardList(ipList)) {
            ipAuthorized = true;
        } else if (ipList != null && !ipList.isEmpty()) {
            for (String allowedHost : ipList) {
                InetAddress hostAddr;
                try {
                    hostAddr = InetAddress.getByName(allowedHost);
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (!hostAddr.getHostAddress().equals(remoteAddress)) continue;
                ipAuthorized = true;
            }
        }
        if (!ipAuthorized) {
            throw new AuthorizationException("Unauthorized connection for super-user: " + superUser.getUserName() + " from IP " + remoteAddress);
        }
    }

    private static boolean isWildcardList(Collection<String> list) {
        return list != null && list.size() == 1 && list.contains("*");
    }
}

