/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.extractor.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.ExtractData;
import org.codelibs.robot.extractor.ExtractException;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlExtractor {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractXmlExtractor.class);
    protected String encoding = "UTF-8";
    protected int preloadSizeForCharset = 2048;
    protected boolean ignoreCommentTag = false;

    protected abstract Pattern getEncodingPattern();

    protected abstract Pattern getTagPattern();

    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(in);
            String enc = this.getEncoding(bis);
            String content = StringEscapeUtils.unescapeHtml4((String)new String(InputStreamUtil.getBytes((InputStream)bis), enc));
            return new ExtractData(this.extractString(content));
        }
        catch (Exception e) {
            throw new ExtractException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEncoding(BufferedInputStream bis) {
        byte[] b = new byte[this.preloadSizeForCharset];
        try {
            String enc;
            bis.mark(this.preloadSizeForCharset);
            int c = bis.read(b);
            if (c == -1) {
                String string = this.encoding;
                return string;
            }
            String head = new String(b, 0, c, this.encoding);
            if (StringUtil.isBlank((String)head)) {
                String e = this.encoding;
                return e;
            }
            Matcher matcher = this.getEncodingPattern().matcher(head);
            if (matcher.find() && Charset.isSupported(enc = matcher.group(1))) {
                String string = enc;
                return string;
            }
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Use a default encoding: " + this.encoding, (Throwable)e);
            }
        }
        finally {
            try {
                bis.reset();
            }
            catch (IOException e) {
                throw new ExtractException(e);
            }
        }
        return this.encoding;
    }

    protected String extractString(String content) {
        String input = content.replaceAll("[\\r\\n]", " ");
        input = this.ignoreCommentTag ? input.replaceAll("<!--[^>]+-->", "") : input.replace("<!--", "").replace("-->", "");
        Matcher matcher = this.getTagPattern().matcher(input);
        StringBuffer sb = new StringBuffer();
        Pattern attrPattern = Pattern.compile("\\s[^ ]+=\"([^\"]*)\"");
        while (matcher.find()) {
            String tagStr = matcher.group();
            Matcher attrMatcher = attrPattern.matcher(tagStr);
            StringBuilder buf = new StringBuilder();
            while (attrMatcher.find()) {
                buf.append(attrMatcher.group(1)).append(' ');
            }
            matcher.appendReplacement(sb, buf.toString().replace("\\", "\\\\").replace("$", "\\$"));
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll("\\s+", " ").trim();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getPreloadSizeForCharset() {
        return this.preloadSizeForCharset;
    }

    public void setPreloadSizeForCharset(int preloadSizeForCharset) {
        this.preloadSizeForCharset = preloadSizeForCharset;
    }

    public boolean isIgnoreCommentTag() {
        return this.ignoreCommentTag;
    }

    public void setIgnoreCommentTag(boolean ignoreCommentTag) {
        this.ignoreCommentTag = ignoreCommentTag;
    }
}

