/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.extractor.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.util.PDFTextStripper;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.ExtractData;
import org.codelibs.robot.extractor.ExtractException;
import org.codelibs.robot.extractor.Extractor;
import org.seasar.framework.util.StringUtil;

public class PdfExtractor
implements Extractor {
    protected String encoding = "UTF-8";
    protected boolean force = false;
    protected Map<String, String> passwordMap = new HashMap<String, String>();
    protected Object pdfBoxLockObj = new Object();
    protected long timeout = 30000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        Object object = this.pdfBoxLockObj;
        synchronized (object) {
            ExtractData extractData;
            PDDocument document = null;
            try {
                document = PDDocument.load((InputStream)in, null, (boolean)this.force);
                if (document.isEncrypted() && params != null) {
                    String password = params.get("org.apache.tika.parser.pdf.password");
                    if (password == null) {
                        password = this.getPassword(params.get("url"), params.get("resourceName"));
                    }
                    if (password != null) {
                        StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                        document.openProtection((DecryptionMaterial)sdm);
                        AccessPermission ap = document.getCurrentAccessPermission();
                        if (!ap.canExtractContent()) {
                            throw new IOException("You do not have permission to extract text.");
                        }
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                final OutputStreamWriter output = new OutputStreamWriter((OutputStream)baos, this.encoding);
                final PDFTextStripper stripper = new PDFTextStripper(this.encoding);
                stripper.setForceParsing(this.force);
                final AtomicBoolean done = new AtomicBoolean(false);
                final PDDocument doc = document;
                final HashSet exceptionSet = new HashSet();
                Thread task = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            stripper.writeText(doc, output);
                        }
                        catch (Exception e) {
                            exceptionSet.add(e);
                        }
                        finally {
                            done.set(true);
                        }
                    }
                });
                task.setDaemon(true);
                task.start();
                task.join(this.timeout);
                if (!done.get()) {
                    for (int i = 0; i < 100 && !done.get(); ++i) {
                        task.interrupt();
                        Thread.sleep(50L);
                    }
                    throw new ExtractException("PDFBox process cannot finish in " + this.timeout + " sec.");
                }
                if (!exceptionSet.isEmpty()) {
                    throw (Exception)exceptionSet.iterator().next();
                }
                ((Writer)output).flush();
                ExtractData extractData2 = new ExtractData(baos.toString(this.encoding));
                this.extractMetadata(document, extractData2);
                extractData = extractData2;
            }
            catch (Exception e) {
                throw new ExtractException(e);
            }
            return extractData;
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void extractMetadata(PDDocument document, ExtractData extractData) {
        PDDocumentInformation info = document.getDocumentInformation();
        if (info == null) {
            return;
        }
        for (String key : info.getMetadataKeys()) {
            String value = info.getCustomMetadataValue(key);
            this.addMetadata(extractData, key, value);
        }
    }

    private void addMetadata(ExtractData extractData, String name, String value) {
        if (value != null) {
            extractData.putValue(name, value);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void addPassword(String regex, String password) {
        this.passwordMap.put(regex, password);
    }

    String getPassword(String url, String resourceName) {
        if (this.passwordMap.isEmpty()) {
            return null;
        }
        String value = null;
        if (StringUtil.isNotEmpty((String)url)) {
            value = url;
        } else if (StringUtil.isNotEmpty((String)resourceName)) {
            value = resourceName;
        }
        if (value != null) {
            for (Map.Entry<String, String> entry : this.passwordMap.entrySet()) {
                if (!value.matches(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

