/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.extractor.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.ExtractData;
import org.codelibs.robot.extractor.ExtractException;
import org.codelibs.robot.extractor.Extractor;
import org.codelibs.robot.extractor.ExtractorFactory;
import org.codelibs.robot.helper.MimeTypeHelper;
import org.codelibs.robot.util.IgnoreCloseInputStream;
import org.seasar.framework.container.SingletonS2Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(TarExtractor.class);
    @Resource
    protected ArchiveStreamFactory archiveStreamFactory;

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
        if (mimeTypeHelper == null) {
            throw new RobotSystemException("MimeTypeHelper is unavailable.");
        }
        ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
        if (extractorFactory == null) {
            throw new RobotSystemException("ExtractorFactory is unavailable.");
        }
        return new ExtractData(this.getTextInternal(in, mimeTypeHelper, extractorFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTextInternal(InputStream in, MimeTypeHelper mimeTypeHelper, ExtractorFactory extractorFactory) {
        StringBuilder buf = new StringBuilder(1000);
        ArchiveInputStream ais = null;
        try {
            ais = this.archiveStreamFactory.createArchiveInputStream("tar", in);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)ais.getNextEntry()) != null) {
                Extractor extractor;
                String filename = entry.getName();
                String mimeType = mimeTypeHelper.getContentType(null, filename);
                if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceName", filename);
                    buf.append(extractor.getText(new IgnoreCloseInputStream((InputStream)ais), map).getContent());
                    buf.append('\n');
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Exception in an internal extractor.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            block7: {
                try {
                    if (buf.length() != 0) break block7;
                    throw new ExtractException("Could not extract a content.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ais);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)ais);
        }
        IOUtils.closeQuietly((InputStream)ais);
        return buf.toString();
    }
}

