/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public abstract class AttributeCreator
extends SimpleNodeConstructor
implements ValidatingInstruction {
    SimpleType schemaType = null;
    private int validationAction;
    private int options;

    public void setSchemaType(SimpleType type) {
        this.schemaType = type;
    }

    public SimpleType getSchemaType() {
        return this.schemaType;
    }

    public void setValidationAction(int action) {
        this.validationAction = action;
    }

    public int getValidationAction() {
        return this.validationAction;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public int getOptions() {
        return this.options;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.getValidationAction() == 4) {
            p |= 0x4000000;
        }
        return p;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        SimpleType ann;
        int opt;
        SequenceReceiver out;
        NodeName attName;
        block11: {
            attName = this.evaluateNodeName(context);
            out = context.getReceiver();
            opt = this.getOptions();
            SimpleType schemaType = this.getSchemaType();
            int validationAction = this.getValidationAction();
            if (schemaType != null) {
                ann = schemaType;
                try {
                    ValidationFailure err = schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
                    if (err != null) {
                        ValidationException ve = new ValidationException("Attribute value " + Err.wrap(value, 4) + " does not match the required type " + schemaType.getDescription() + ". " + err.getMessage());
                        ve.setErrorCode("XTTE1540");
                        throw ve;
                    }
                    break block11;
                }
                catch (UnresolvedReferenceException ure) {
                    throw new ValidationException(ure);
                }
            }
            if (validationAction == 1 || validationAction == 2) {
                try {
                    Configuration config = context.getConfiguration();
                    ann = config.validateAttribute(attName.allocateNameCode(config.getNamePool()), value, validationAction);
                }
                catch (ValidationException e) {
                    XPathException err = XPathException.makeXPathException(e);
                    err.maybeSetErrorCode(validationAction == 1 ? "XTTE1510" : "XTTE1515");
                    err.setXPathContext(context);
                    err.maybeSetLocation(this);
                    err.setIsTypeError(true);
                    throw err;
                }
            } else {
                ann = BuiltInAtomicType.UNTYPED_ATOMIC;
            }
        }
        if (attName.equals(StandardNames.XML_ID_NAME)) {
            value = Whitespace.collapseWhitespace(value);
        }
        try {
            out.attribute(attName, ann, value, this.locationId, opt);
        }
        catch (XPathException err) {
            throw AttributeCreator.dynamicError(this, err, context);
        }
    }

    protected void validateOrphanAttribute(Orphan orphan, XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        SimpleType schemaType = this.getSchemaType();
        int validationAction = this.getValidationAction();
        if (schemaType != null) {
            ValidationFailure err = schemaType.validateContent(orphan.getStringValueCS(), DummyNamespaceResolver.getInstance(), rules);
            if (err != null) {
                ValidationException ve = new ValidationException("Attribute value " + Err.wrap(orphan.getStringValueCS(), 4) + " does not the match the required type " + schemaType.getDescription() + ". " + err.getMessage());
                ve.setErrorCode("XTTE1555");
                ve.setLocator(this);
                throw ve;
            }
            orphan.setTypeAnnotation(schemaType.getFingerprint());
            if (schemaType.isNamespaceSensitive()) {
                throw new XPathException("Cannot validate a parentless attribute whose content is namespace-sensitive", "XTTE1545");
            }
        } else if (validationAction == 1 || validationAction == 2) {
            try {
                Controller controller = context.getController();
                assert (controller != null);
                SimpleType ann = controller.getConfiguration().validateAttribute(orphan.getNameCode(), orphan.getStringValueCS(), validationAction);
                orphan.setTypeAnnotation(ann);
            }
            catch (ValidationException e) {
                XPathException err = XPathException.makeXPathException(e);
                err.setErrorCodeQName(e.getErrorCodeQName());
                err.setXPathContext(context);
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
    }
}

