/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.db.cbean.AccessResultCB;
import org.codelibs.robot.db.exbhv.AccessResultBhv;
import org.codelibs.robot.db.exbhv.AccessResultDataBhv;
import org.codelibs.robot.db.exbhv.cursor.AccessResultDiffCursor;
import org.codelibs.robot.db.exbhv.cursor.AccessResultDiffCursorHandler;
import org.codelibs.robot.db.exbhv.pmbean.AccessResultPmb;
import org.codelibs.robot.dbflute.cbean.EntityRowHandler;
import org.codelibs.robot.dbflute.cbean.ListResultBean;
import org.codelibs.robot.dbflute.jdbc.CursorHandler;
import org.codelibs.robot.entity.AccessResult;
import org.codelibs.robot.entity.AccessResultData;
import org.codelibs.robot.service.DataService;
import org.codelibs.robot.util.AccessResultCallback;
import org.seasar.framework.beans.util.Beans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDataServiceImpl
implements DataService {
    private static final Logger logger = LoggerFactory.getLogger(DBDataServiceImpl.class);
    @Resource
    protected AccessResultBhv accessResultBhv;
    @Resource
    protected AccessResultDataBhv accessResultDataBhv;

    public void store(AccessResult accessResult) {
        if (accessResult == null) {
            throw new RobotSystemException("AccessResult is null.");
        }
        this.accessResultBhv.insert((org.codelibs.robot.db.exentity.AccessResult)accessResult);
        AccessResultData accessResultData = accessResult.getAccessResultData();
        if (accessResultData == null) {
            accessResultData = new org.codelibs.robot.db.exentity.AccessResultData();
            accessResultData.setTransformerName("NONE");
        }
        accessResultData.setId(accessResult.getId());
        this.accessResultDataBhv.insert((org.codelibs.robot.db.exentity.AccessResultData)accessResultData);
    }

    public int getCount(String sessionId) {
        AccessResultCB cb = new AccessResultCB();
        cb.query().setSessionId_Equal(sessionId);
        return this.accessResultBhv.selectCount(cb);
    }

    public void delete(String sessionId) {
        int count = this.accessResultDataBhv.deleteBySessionId(sessionId);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted accessResultData: " + count);
        }
        count = this.accessResultBhv.deleteBySessionId(sessionId);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted accessResult: " + count);
        }
    }

    public void deleteAll() {
        int count = this.accessResultDataBhv.deleteAll();
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted accessResultData: " + count);
        }
        count = this.accessResultBhv.deleteAll();
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted accessResult: " + count);
        }
    }

    public AccessResult getAccessResult(String sessionId, String url) {
        AccessResultCB cb = new AccessResultCB();
        cb.setupSelect_AccessResultDataAsOne();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().setUrl_Equal(url);
        return this.accessResultBhv.selectEntity(cb);
    }

    public List<AccessResult> getAccessResultList(String url, boolean hasData) {
        AccessResultCB cb = new AccessResultCB();
        if (hasData) {
            cb.setupSelect_AccessResultDataAsOne();
        }
        cb.query().setUrl_Equal(url);
        cb.query().addOrderBy_CreateTime_Desc();
        ListResultBean list = this.accessResultBhv.selectList(cb);
        ArrayList<AccessResult> accessResultList = new ArrayList<AccessResult>();
        accessResultList.addAll((Collection<AccessResult>)list);
        return accessResultList;
    }

    public void iterate(String sessionId, final AccessResultCallback accessResultCallback) {
        AccessResultCB cb = new AccessResultCB();
        cb.setupSelect_AccessResultDataAsOne();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().addOrderBy_CreateTime_Asc();
        this.accessResultBhv.selectCursor(cb, (EntityRowHandler)new EntityRowHandler<org.codelibs.robot.db.exentity.AccessResult>(){

            public void handle(org.codelibs.robot.db.exentity.AccessResult entity) {
                accessResultCallback.iterate((AccessResult)entity);
            }
        });
    }

    public void iterateUrlDiff(String oldSessionId, String newSessionId, final AccessResultCallback accessResultCallback) {
        AccessResultPmb pmb = new AccessResultPmb();
        pmb.setOldSessionId(oldSessionId);
        pmb.setNewSessionId(newSessionId);
        AccessResultDiffCursorHandler handler = new AccessResultDiffCursorHandler(){

            public Object fetchCursor(AccessResultDiffCursor cursor) throws SQLException {
                while (cursor.next()) {
                    org.codelibs.robot.db.exentity.AccessResult accessResult = new org.codelibs.robot.db.exentity.AccessResult();
                    Beans.copy((Object)cursor, (Object)accessResult).execute();
                    accessResultCallback.iterate((AccessResult)accessResult);
                }
                return null;
            }
        };
        this.accessResultBhv.outsideSql().cursorHandling().selectCursor("selectListByUrlDiff", (Object)pmb, (CursorHandler)handler);
    }

    public void update(AccessResult accessResult) {
        this.accessResultBhv.update((org.codelibs.robot.db.exentity.AccessResult)accessResult);
        if (accessResult.getAccessResultData() != null) {
            this.accessResultDataBhv.update((org.codelibs.robot.db.exentity.AccessResultData)accessResult.getAccessResultData());
        }
    }

    public void update(List<AccessResult> accessResultList) {
        ArrayList<org.codelibs.robot.db.exentity.AccessResult> arList = new ArrayList<org.codelibs.robot.db.exentity.AccessResult>();
        ArrayList<org.codelibs.robot.db.exentity.AccessResultData> ardList = new ArrayList<org.codelibs.robot.db.exentity.AccessResultData>();
        for (AccessResult accessResult : accessResultList) {
            arList.add((org.codelibs.robot.db.exentity.AccessResult)accessResult);
            if (accessResult.getAccessResultData() == null) continue;
            ardList.add((org.codelibs.robot.db.exentity.AccessResultData)accessResult.getAccessResultData());
        }
        this.accessResultBhv.batchUpdate(arList);
        if (!ardList.isEmpty()) {
            this.accessResultDataBhv.batchUpdate(ardList);
        }
        for (AccessResult accessResult : accessResultList) {
            this.update(accessResult);
        }
    }
}

