/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.bhv.core.CommonColumnAutoSetupper;
import org.seasar.dbflute.bhv.core.command.AbstractListEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteNonstrictCommand;
import org.seasar.dbflute.bhv.core.command.BatchInsertCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateNonstrictCommand;
import org.seasar.dbflute.bhv.core.command.DeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.QueryDeleteCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryInsertCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryUpdateCBCommand;
import org.seasar.dbflute.bhv.core.command.UpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.UpdateNonstrictEntityCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.IllegalBehaviorStateException;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.OptimisticLockColumnValueNullException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.ResourceContext;

public abstract class AbstractBehaviorWritable<ENTITY extends Entity, CB extends ConditionBean>
extends AbstractBehaviorReadable<ENTITY, CB>
implements BehaviorWritable {
    protected CommonColumnAutoSetupper _commonColumnAutoSetupper;

    protected void doInsert(ENTITY entity, InsertOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareInsertOption(option);
        this.delegateInsert((Entity)entity, (InsertOption<? extends ConditionBean>)option);
    }

    protected void prepareInsertOption(InsertOption<CB> option) {
        if (option == null) {
            return;
        }
        this.assertInsertOptionStatus(option);
        if (option.hasSpecifiedInsertColumn()) {
            CB cb = this.createCBForSpecifiedUpdate();
            option.resolveInsertColumnSpecification(cb);
        }
    }

    protected void assertInsertOptionStatus(InsertOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.getDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
        if (option.isPrimaryKeyIdentityDisabled() && !this.getDBMeta().hasIdentity()) {
            String msg = "The identity disabling was set to the table not defined identity:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected CB createCBForSpecifiedUpdate() {
        Object cb = this.newConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    protected void assertInsertOptionNotNull(InsertOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for insert)", option);
    }

    @Override
    public void create(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.doCreate(entity, option);
    }

    protected void doCreate(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.doInsert(this.downcast(entity), this.downcast(option));
    }

    protected void doUpdate(ENTITY entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareUpdateOption(option);
        this.helpUpdateInternally(entity, option);
    }

    protected void doUpdateNonstrict(ENTITY entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareUpdateOption(option);
        this.helpUpdateNonstrictInternally(entity, option);
    }

    protected void prepareUpdateOption(UpdateOption<CB> option) {
        CB cb;
        if (option == null) {
            return;
        }
        this.assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            cb = this.createCBForVaryingUpdate();
            option.resolveSelfSpecification(cb);
        }
        if (option.hasSpecifiedUpdateColumn()) {
            cb = this.createCBForSpecifiedUpdate();
            option.resolveUpdateColumnSpecification(cb);
        }
    }

    protected CB createCBForVaryingUpdate() {
        Object cb = this.newConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected <RESULT extends ENTITY> void helpUpdateInternally(RESULT entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.assertEntityHasOptimisticLockValue((Entity)entity);
        int updatedCount = this.delegateUpdate((Entity)entity, (UpdateOption<? extends ConditionBean>)option);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpUpdateNonstrictInternally(RESULT entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        int updatedCount = this.delegateUpdateNonstrict((Entity)entity, (UpdateOption<? extends ConditionBean>)option);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected void throwUpdateEntityAlreadyDeletedException(ENTITY entity) {
        this.createBhvExThrower().throwUpdateEntityAlreadyDeletedException(entity);
    }

    protected void throwUpdateEntityDuplicatedException(ENTITY entity, int count) {
        this.createBhvExThrower().throwUpdateEntityDuplicatedException(entity, count);
    }

    protected void assertUpdateOptionStatus(UpdateOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.getDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertUpdateOptionNotNull(UpdateOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for update)", option);
    }

    @Override
    public void modify(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModify(entity, option);
    }

    protected void doModify(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doUpdate(this.downcast(entity), this.downcast(option));
    }

    @Override
    public void modifyNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModifyNonstrict(entity, option);
    }

    protected void doModifyNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (this.getDBMeta().hasOptimisticLock()) {
            this.doUpdateNonstrict(this.downcast(entity), this.downcast(option));
        } else {
            this.doUpdate(this.downcast(entity), this.downcast(option));
        }
    }

    protected void doInsertOrUpdate(ENTITY entity, InsertOption<CB> insertOption, UpdateOption<CB> updateOption) {
        this.assertEntityNotNull((Entity)entity);
        this.helpInsertOrUpdateInternally(entity, insertOption, updateOption);
    }

    protected void doInsertOrUpdateNonstrict(ENTITY entity, InsertOption<CB> insertOption, UpdateOption<CB> updateOption) {
        this.assertEntityNotNull((Entity)entity);
        this.helpInsertOrUpdateNonstrictInternally(entity, insertOption, updateOption);
    }

    protected <RESULT extends ENTITY> void helpInsertOrUpdateInternally(RESULT entity, InsertOption<CB> insOption, UpdateOption<CB> updOption) {
        this.assertEntityNotNull((Entity)entity);
        if (this.helpDetermineInsertOrUpdateDirectInsert((Entity)entity)) {
            this.doCreate((Entity)entity, (InsertOption<? extends ConditionBean>)insOption);
            return;
        }
        RuntimeException updateException = null;
        try {
            this.doModify((Entity)entity, (UpdateOption<? extends ConditionBean>)updOption);
        }
        catch (EntityAlreadyUpdatedException e) {
            updateException = e;
        }
        catch (EntityAlreadyDeletedException e) {
            updateException = e;
        }
        catch (OptimisticLockColumnValueNullException e) {
            updateException = e;
        }
        if (updateException == null) {
            return;
        }
        Object cb = this.newConditionBean();
        Set<String> uniqueDrivenProperties = entity.myuniqueDrivenProperties();
        if (uniqueDrivenProperties != null && !uniqueDrivenProperties.isEmpty()) {
            for (String prop : uniqueDrivenProperties) {
                DBMeta dbmeta = entity.getDBMeta();
                ColumnInfo columnInfo = dbmeta.findColumnInfo(prop);
                Object value = columnInfo.read((Entity)entity);
                cb.localCQ().invokeQueryEqual(columnInfo.getColumnDbName(), value);
            }
        } else {
            cb.acceptPrimaryKeyMap(this.getDBMeta().extractPrimaryKeyMap((Entity)entity));
        }
        if (this.readCount((ConditionBean)cb) != 0) {
            throw updateException;
        }
        this.doCreate((Entity)entity, (InsertOption<? extends ConditionBean>)insOption);
    }

    protected <RESULT extends ENTITY> void helpInsertOrUpdateNonstrictInternally(RESULT entity, InsertOption<? extends ConditionBean> insOption, UpdateOption<? extends ConditionBean> updOption) {
        this.assertEntityNotNull((Entity)entity);
        if (this.helpDetermineInsertOrUpdateDirectInsert((Entity)entity)) {
            this.doCreate((Entity)entity, insOption);
        } else {
            try {
                this.doModifyNonstrict((Entity)entity, updOption);
            }
            catch (EntityAlreadyDeletedException ignored) {
                this.doCreate((Entity)entity, insOption);
            }
        }
    }

    protected boolean helpDetermineInsertOrUpdateDirectInsert(Entity entity) {
        Set<String> uniqueDrivenProperties = entity.myuniqueDrivenProperties();
        if (uniqueDrivenProperties != null && !uniqueDrivenProperties.isEmpty()) {
            return false;
        }
        return !entity.hasPrimaryKeyValue();
    }

    @Override
    public void createOrModify(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModify(entity, insertOption, updateOption);
    }

    protected void doCreateOrModify(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doInsertOrUpdate(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
    }

    @Override
    public void createOrModifyNonstrict(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModifyNonstrict(entity, insertOption, updateOption);
    }

    protected void doCreateOrModifyNonstrict(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        if (this.getDBMeta().hasOptimisticLock()) {
            this.doInsertOrUpdateNonstrict(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
        } else {
            this.doInsertOrUpdate(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
        }
    }

    protected void doDelete(ENTITY entity, DeleteOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareDeleteOption(option);
        this.helpDeleteInternally(entity, option);
    }

    protected void doDeleteNonstrict(ENTITY entity, DeleteOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareDeleteOption(option);
        this.helpDeleteNonstrictInternally(entity, option);
    }

    protected void prepareDeleteOption(DeleteOption<CB> option) {
        if (option != null) {
            this.assertDeleteOptionStatus(option);
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        this.assertEntityHasOptimisticLockValue((Entity)entity);
        int deletedCount = this.delegateDelete((Entity)entity, option);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteNonstrictInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        int deletedCount = this.delegateDeleteNonstrict((Entity)entity, option);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteNonstrictIgnoreDeletedInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        int deletedCount = this.delegateDeleteNonstrict((Entity)entity, option);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected void assertDeleteOptionStatus(DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertDeleteOptionNotNull(DeleteOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for delete)", option);
    }

    @Override
    public void remove(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemove(entity, option);
    }

    protected void doRemove(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doDelete(this.downcast(entity), this.downcast(option));
    }

    @Override
    public void removeNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemoveNonstrict(entity, option);
    }

    protected void doRemoveNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        if (this.getDBMeta().hasOptimisticLock()) {
            this.doDeleteNonstrict(this.downcast(entity), this.downcast(option));
        } else {
            this.doDelete(this.downcast(entity), this.downcast(option));
        }
    }

    protected int[] doBatchInsert(List<ENTITY> entityList, InsertOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        InsertOption<CB> rlop = option != null ? option : this.createPlainInsertOption();
        this.prepareBatchInsertOption(entityList, rlop);
        return this.delegateBatchInsert(entityList, rlop);
    }

    protected InsertOption<CB> createPlainInsertOption() {
        return new InsertOption();
    }

    protected <ELEMENT extends ENTITY> void prepareBatchInsertOption(List<ELEMENT> entityList, InsertOption<CB> option) {
        if (this.isBatchInsertColumnModifiedPropertiesFragmentedDisallowed()) {
            option.xdisallowInsertColumnModifiedPropertiesFragmented();
        }
        if (this.isCompatibleBatchInsertDefaultEveryColumn()) {
            option.xtoBeCompatibleBatchInsertDefaultEveryColumn();
        }
        option.xacceptInsertColumnModifiedPropertiesIfNeeds(entityList);
        this.prepareInsertOption(option);
    }

    protected boolean isBatchInsertColumnModifiedPropertiesFragmentedDisallowed() {
        return false;
    }

    protected boolean isCompatibleBatchInsertDefaultEveryColumn() {
        return false;
    }

    @Override
    public int[] lumpCreate(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpCreate(castList, option);
    }

    protected int[] doLumpCreate(List<Entity> entityList, InsertOption<? extends ConditionBean> option) {
        return this.doBatchInsert(this.downcast(entityList), this.downcast(option));
    }

    protected int[] doBatchUpdate(List<ENTITY> entityList, UpdateOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        UpdateOption<CB> rlop = option != null ? option : this.createPlainUpdateOption();
        this.prepareBatchUpdateOption(entityList, rlop);
        return this.delegateBatchUpdate(entityList, rlop);
    }

    protected int[] doBatchUpdateNonstrict(List<ENTITY> entityList, UpdateOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        UpdateOption<CB> rlop = option != null ? option : this.createPlainUpdateOption();
        this.prepareBatchUpdateOption(entityList, rlop);
        return this.delegateBatchUpdateNonstrict(entityList, rlop);
    }

    protected UpdateOption<CB> createPlainUpdateOption() {
        return new UpdateOption();
    }

    protected UpdateOption<CB> createSpecifiedUpdateOption(SpecifyQuery<CB> updateColumnSpec) {
        this.assertUpdateColumnSpecificationNotNull(updateColumnSpec);
        UpdateOption<CB> option = this.createPlainUpdateOption();
        option.specify(updateColumnSpec);
        return option;
    }

    protected void assertUpdateColumnSpecificationNotNull(SpecifyQuery<? extends ConditionBean> updateColumnSpec) {
        this.assertObjectNotNull("updateColumnSpec", updateColumnSpec);
    }

    protected <RESULT extends ENTITY> void prepareBatchUpdateOption(List<RESULT> entityList, UpdateOption<CB> option) {
        if (this.isBatchUpdateColumnModifiedPropertiesFragmentedAllowed()) {
            option.xallowUpdateColumnModifiedPropertiesFragmented();
        }
        if (this.isCompatibleBatchUpdateDefaultEveryColumn()) {
            option.xtoBeCompatibleBatchUpdateDefaultEveryColumn();
        }
        option.xacceptUpdateColumnModifiedPropertiesIfNeeds(entityList);
        this.prepareUpdateOption(option);
    }

    protected boolean isBatchUpdateColumnModifiedPropertiesFragmentedAllowed() {
        return false;
    }

    protected boolean isCompatibleBatchUpdateDefaultEveryColumn() {
        return false;
    }

    @Override
    public int[] lumpModify(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModify(castList, option);
    }

    protected int[] doLumpModify(List<Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        return this.doBatchUpdate(this.downcast(entityList), this.downcast(option));
    }

    @Override
    public int[] lumpModifyNonstrict(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModifyNonstrict(castList, option);
    }

    protected int[] doLumpModifyNonstrict(List<Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.doBatchUpdateNonstrict(this.downcast(entityList), this.downcast(option));
        }
        return this.doBatchUpdate(this.downcast(entityList), this.downcast(option));
    }

    protected int[] doBatchDelete(List<ENTITY> entityList, DeleteOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        this.prepareDeleteOption(option);
        return this.delegateBatchDelete(entityList, option);
    }

    protected int[] doBatchDeleteNonstrict(List<ENTITY> entityList, DeleteOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        this.prepareDeleteOption(option);
        return this.delegateBatchDeleteNonstrict(entityList, option);
    }

    @Override
    public int[] lumpRemove(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemove(castList, option);
    }

    protected int[] doLumpRemove(List<Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        return this.doBatchDelete(this.downcast(entityList), this.downcast(option));
    }

    @Override
    public int[] lumpRemoveNonstrict(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemoveNonstrict(castList, option);
    }

    protected int[] doLumpRemoveNonstrict(List<Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.doBatchDeleteNonstrict(this.downcast(entityList), this.downcast(option));
        }
        return this.doBatchDelete(this.downcast(entityList), this.downcast(option));
    }

    protected int doQueryInsert(QueryInsertSetupper<ENTITY, CB> setupper, InsertOption<CB> option) {
        this.assertObjectNotNull("setupper", setupper);
        this.prepareInsertOption(option);
        Object et = this.newEntity();
        CB cb = this.createCBForQueryInsert();
        return this.delegateQueryInsert((Entity)et, (ConditionBean)cb, setupper.setup(et, cb), (InsertOption<? extends ConditionBean>)option);
    }

    protected CB createCBForQueryInsert() {
        Object cb = this.newConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    public int rangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper, InsertOption<? extends ConditionBean> option) {
        return this.doRangeCreate(setupper, option);
    }

    protected int doRangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper, InsertOption<? extends ConditionBean> option) {
        return this.doQueryInsert(this.downcast(setupper), this.downcast(option));
    }

    protected int doQueryUpdate(ENTITY entity, CB cb, UpdateOption<CB> option) {
        this.assertObjectNotNull("${myEntityVariableName}", entity);
        this.assertCBStateValid((ConditionBean)cb);
        this.prepareUpdateOption(option);
        return this.checkCountBeforeQueryUpdateIfNeeds((ConditionBean)cb) ? this.delegateQueryUpdate((Entity)entity, (ConditionBean)cb, (UpdateOption<? extends ConditionBean>)option) : 0;
    }

    protected boolean checkCountBeforeQueryUpdateIfNeeds(ConditionBean cb) {
        boolean countExists = cb.isQueryUpdateCountPreCheck() ? this.readCount(cb) > 0 : true;
        return countExists;
    }

    @Override
    public int rangeModify(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        return this.doRangeModify(entity, cb, option);
    }

    protected int doRangeModify(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        return this.doQueryUpdate(this.downcast(entity), this.downcast(cb), this.downcast(option));
    }

    protected int doQueryDelete(CB cb, DeleteOption<CB> option) {
        this.assertCBStateValid((ConditionBean)cb);
        this.prepareDeleteOption(option);
        return this.checkCountBeforeQueryUpdateIfNeeds((ConditionBean)cb) ? this.delegateQueryDelete((ConditionBean)cb, (DeleteOption<? extends ConditionBean>)option) : 0;
    }

    @Override
    public int rangeRemove(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        return this.doRangeRemove(cb, option);
    }

    protected int doRangeRemove(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        return this.doQueryDelete(this.downcast(cb), this.downcast(option));
    }

    protected int delegateInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        if (!this.processBeforeInsert(entity, option)) {
            return 0;
        }
        return this.invoke(this.createInsertEntityCommand(entity, option));
    }

    protected int delegateUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (!this.processBeforeUpdate(entity, option)) {
            return 0;
        }
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.invoke(this.createUpdateEntityCommand(entity, option));
        }
        return this.delegateUpdateNonstrict(entity, option);
    }

    protected int delegateUpdateNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (!this.processBeforeUpdate(entity, option)) {
            return 0;
        }
        return this.invoke(this.createUpdateNonstrictEntityCommand(entity, option));
    }

    protected int delegateDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
        if (!this.processBeforeDelete(entity, option)) {
            return 0;
        }
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.invoke(this.createDeleteEntityCommand(entity, option));
        }
        return this.delegateDeleteNonstrict(entity, option);
    }

    protected int delegateDeleteNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        if (!this.processBeforeDelete(entity, option)) {
            return 0;
        }
        return this.invoke(this.createDeleteNonstrictEntityCommand(entity, option));
    }

    protected int[] delegateBatchInsert(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return new int[0];
        }
        return this.invoke(this.createBatchInsertCommand(this.processBatchInternally(entityList, option), option));
    }

    protected int[] delegateBatchUpdate(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return new int[0];
        }
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.invoke(this.createBatchUpdateCommand(this.processBatchInternally(entityList, option, false), option));
        }
        return this.delegateBatchUpdateNonstrict(entityList, option);
    }

    protected int[] delegateBatchUpdateNonstrict(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return new int[0];
        }
        return this.invoke(this.createBatchUpdateNonstrictCommand(this.processBatchInternally(entityList, option, true), option));
    }

    protected int[] delegateBatchDelete(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return new int[0];
        }
        if (this.getDBMeta().hasOptimisticLock()) {
            return this.invoke(this.createBatchDeleteCommand(this.processBatchInternally(entityList, option, false), option));
        }
        return this.delegateBatchDeleteNonstrict(entityList, option);
    }

    protected int[] delegateBatchDeleteNonstrict(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return new int[0];
        }
        return this.invoke(this.createBatchDeleteNonstrictCommand(this.processBatchInternally(entityList, option, true), option));
    }

    protected int delegateQueryInsert(Entity entity, ConditionBean inCB, ConditionBean resCB, InsertOption<? extends ConditionBean> option) {
        if (!this.processBeforeQueryInsert(entity, inCB, resCB, option)) {
            return 0;
        }
        return this.invoke(this.createQueryInsertCBCommand(entity, inCB, resCB, option));
    }

    protected int delegateQueryUpdate(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        if (!this.processBeforeQueryUpdate(entity, cb, option)) {
            return 0;
        }
        return this.invoke(this.createQueryUpdateCBCommand(entity, cb, option));
    }

    protected int delegateQueryDelete(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        if (!this.processBeforeQueryDelete(cb, option)) {
            return 0;
        }
        return this.invoke(this.createQueryDeleteCBCommand(cb, option));
    }

    protected boolean processBeforeInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity, option);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        if (!entity.getDBMeta().hasIdentity()) {
            this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        }
        return true;
    }

    protected boolean processBeforeQueryInsert(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.assertObjectNotNull("intoCB", intoCB);
        if (resourceCB == null) {
            String msg = "The set-upper of query-insert should return a condition-bean for resource table:";
            msg = msg + " inserted=" + entity.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.frameworkFilterEntityOfInsert(entity, option);
        this.setupExclusiveControlColumnOfQueryInsert(entity);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        return true;
    }

    protected void setupExclusiveControlColumnOfQueryInsert(Entity entity) {
        ColumnInfo columnInfo;
        DBMeta dbmeta = this.getDBMeta();
        if (dbmeta.hasVersionNo()) {
            columnInfo = dbmeta.getVersionNoColumnInfo();
            columnInfo.write(entity, InsertOption.VERSION_NO_FIRST_VALUE);
        }
        if (dbmeta.hasUpdateDate()) {
            columnInfo = dbmeta.getUpdateDateColumnInfo();
            columnInfo.write(entity, ResourceContext.getAccessTimestamp());
        }
    }

    protected void frameworkFilterEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.injectSequenceToPrimaryKeyIfNeeds(entity);
        this.setupCommonColumnOfInsertIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity entity, InsertOption<? extends ConditionBean> option) {
        if (option != null && option.isCommonColumnAutoSetupDisabled()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfInsertIfNeeds(entity);
    }

    private void assertCommonColumnAutoSetupperNotNull() {
        if (this._commonColumnAutoSetupper != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the auto set-upper of common column in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        br.addElement("commonColumnAutoSetupper : " + this._commonColumnAutoSetupper);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    @Override
    protected void filterEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
    }

    protected boolean processBeforeUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        return true;
    }

    protected boolean processBeforeQueryUpdate(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.assertCBStateValid(cb);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        this.assertQueryUpdateStatus(entity, cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.setupCommonColumnOfUpdateIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (option != null && option.isCommonColumnAutoSetupDisabled()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfUpdateIfNeeds(entity);
    }

    protected void filterEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
    }

    protected void assertQueryUpdateStatus(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        if (option != null && option.isNonQueryUpdateAllowed()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryUpdateNotAllowedException(entity, cb, option);
        }
    }

    protected boolean processBeforeDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity, option);
        this.filterEntityOfDelete(entity, option);
        this.assertEntityOfDelete(entity, option);
        return true;
    }

    protected boolean processBeforeQueryDelete(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        this.assertCBStateValid(cb);
        this.assertQueryDeleteStatus(cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void filterEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertQueryDeleteStatus(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        if (option != null && option.isNonQueryDeleteAllowed()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryDeleteNotAllowedException(cb, option);
        }
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.getDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasCompoundPrimaryKey() || entity.hasPrimaryKeyValue()) {
            return;
        }
        dbmeta.getPrimaryUniqueInfo().getFirstColumn().write(entity, this.readNextVal());
    }

    protected void assertEntityHasOptimisticLockValue(Entity entity) {
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
    }

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.getDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        this.throwVersionNoValueNullException(entity);
    }

    protected void throwVersionNoValueNullException(Entity entity) {
        this.createBhvExThrower().throwVersionNoValueNullException(entity);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.getDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        this.throwUpdateDateValueNullException(entity);
    }

    protected void throwUpdateDateValueNullException(Entity entity) {
        this.createBhvExThrower().throwUpdateDateValueNullException(entity);
    }

    protected <ELEMENT extends Entity> List<ELEMENT> processBatchInternally(List<ELEMENT> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeInsert(entity, option)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ELEMENT extends Entity> List<ELEMENT> processBatchInternally(List<ELEMENT> entityList, UpdateOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeUpdate(entity, option)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ELEMENT extends Entity> List<ELEMENT> processBatchInternally(List<ELEMENT> entityList, DeleteOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeDelete(entity, option)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected UpdateEntityCommand createUpdateEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateEntityCommand");
        UpdateEntityCommand cmd = this.newUpdateEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateEntityCommand newUpdateEntityCommand() {
        return new UpdateEntityCommand();
    }

    protected UpdateNonstrictEntityCommand createUpdateNonstrictEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateNonstrictEntityCommand");
        UpdateNonstrictEntityCommand cmd = this.newUpdateNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateNonstrictEntityCommand newUpdateNonstrictEntityCommand() {
        return new UpdateNonstrictEntityCommand();
    }

    protected DeleteEntityCommand createDeleteEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteEntityCommand");
        DeleteEntityCommand cmd = this.newDeleteEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteEntityCommand newDeleteEntityCommand() {
        return new DeleteEntityCommand();
    }

    protected DeleteNonstrictEntityCommand createDeleteNonstrictEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteNonstrictEntityCommand");
        DeleteNonstrictEntityCommand cmd = this.newDeleteNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteNonstrictEntityCommand newDeleteNonstrictEntityCommand() {
        return new DeleteNonstrictEntityCommand();
    }

    protected BatchInsertCommand createBatchInsertCommand(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchInsertCommand");
        BatchInsertCommand cmd = this.newBatchInsertCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected BatchInsertCommand newBatchInsertCommand() {
        return new BatchInsertCommand();
    }

    protected BatchUpdateCommand createBatchUpdateCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateCommand");
        BatchUpdateCommand cmd = this.newBatchUpdateCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateCommand newBatchUpdateCommand() {
        return new BatchUpdateCommand();
    }

    protected BatchUpdateNonstrictCommand createBatchUpdateNonstrictCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateNonstrictCommand");
        BatchUpdateNonstrictCommand cmd = this.newBatchUpdateNonstrictCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateNonstrictCommand newBatchUpdateNonstrictCommand() {
        return new BatchUpdateNonstrictCommand();
    }

    protected BatchDeleteCommand createBatchDeleteCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteCommand");
        BatchDeleteCommand cmd = this.newBatchDeleteCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteCommand newBatchDeleteCommand() {
        return new BatchDeleteCommand();
    }

    protected BatchDeleteNonstrictCommand createBatchDeleteNonstrictCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteNonstrictCommand");
        BatchDeleteNonstrictCommand cmd = this.newBatchDeleteNonstrictCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteNonstrictCommand newBatchDeleteNonstrictCommand() {
        return new BatchDeleteNonstrictCommand();
    }

    protected void xsetupListEntityCommand(AbstractListEntityCommand command, List<? extends Entity> entityList) {
        if (entityList.isEmpty()) {
            String msg = "The argument 'entityList' should not be empty: " + entityList;
            throw new IllegalStateException(msg);
        }
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entityList.get(0).getClass());
        command.setEntityList(entityList);
    }

    protected QueryInsertCBCommand createQueryInsertCBCommand(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryInsertCBCommand");
        QueryInsertCBCommand cmd = new QueryInsertCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setIntoConditionBean(intoCB);
        cmd.setConditionBean(resourceCB);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected QueryUpdateCBCommand createQueryUpdateCBCommand(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryUpdateCBCommand");
        QueryUpdateCBCommand cmd = new QueryUpdateCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setConditionBean(cb);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected QueryDeleteCBCommand createQueryDeleteCBCommand(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryDeleteCBCommand");
        QueryDeleteCBCommand cmd = new QueryDeleteCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBean(cb);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected InsertOption<CB> downcast(InsertOption<? extends ConditionBean> option) {
        return option;
    }

    protected UpdateOption<CB> downcast(UpdateOption<? extends ConditionBean> option) {
        return option;
    }

    protected DeleteOption<CB> downcast(DeleteOption<? extends ConditionBean> option) {
        return option;
    }

    protected QueryInsertSetupper<ENTITY, CB> downcast(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper) {
        return setupper;
    }

    protected CommonColumnAutoSetupper getCommonColumnAutoSetupper() {
        return this._commonColumnAutoSetupper;
    }

    public void setCommonColumnAutoSetupper(CommonColumnAutoSetupper commonColumnAutoSetupper) {
        this._commonColumnAutoSetupper = commonColumnAutoSetupper;
    }
}

