/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.logging.invoke;

import java.util.Arrays;
import java.util.List;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.logging.invoke.BehaviorInvokeNameResult;
import org.seasar.dbflute.bhv.logging.invoke.InvokeNameExtractingCoinLogic;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.dbflute.helper.stacktrace.InvokeNameResult;
import org.seasar.dbflute.util.DfTypeUtil;

public class BehaviorInvokeNameExtractor {
    protected static final String _readableName = DfTypeUtil.toClassTitle(BehaviorReadable.class);
    protected static final String _writableName = DfTypeUtil.toClassTitle(BehaviorWritable.class);
    protected static final String _pagingInvokerName = DfTypeUtil.toClassTitle(PagingInvoker.class);
    protected static final List<String> _suffixList = Arrays.asList("Bhv", "BhvAp", _readableName, _writableName, _pagingInvokerName);
    protected static final List<String> _keywordList = Arrays.asList("Bhv$", _readableName + "$", _writableName + "$");
    protected static final List<String> _ousideSqlMarkList = Arrays.asList("OutsideSql");
    protected static final List<String> _ousideSqlExecutorSuffixList = Arrays.asList("Executor");
    protected static final List<String> _ousideSqlExecutorInnerList = Arrays.asList("Executor$");
    protected final DBMeta _dbmeta;
    protected final Class<?> _outsideSqlResultType;
    protected final boolean _outsideSqlAutoPaging;
    protected final InvokeNameExtractingCoinLogic _coinLogic = this.createInvokeNameExtractingCoinLogic();

    protected InvokeNameExtractingCoinLogic createInvokeNameExtractingCoinLogic() {
        return new InvokeNameExtractingCoinLogic();
    }

    public BehaviorInvokeNameExtractor(DBMeta dbmeta, Class<?> outsideSqlResultType, boolean outsideSqlAutoPaging) {
        this._dbmeta = dbmeta;
        this._outsideSqlResultType = outsideSqlResultType;
        this._outsideSqlAutoPaging = outsideSqlAutoPaging;
    }

    public BehaviorInvokeNameResult extractBehaviorInvoke(StackTraceElement[] stackTrace) {
        String invokeMethodName;
        String invokeClassName;
        InvokeNameResult headResult;
        InvokeNameExtractingResource resource = this.createResource();
        List<InvokeNameResult> resultList = this.extractInvokeName(resource, stackTrace);
        this.filterBehaviorResult(resultList);
        if (!resultList.isEmpty()) {
            headResult = this.findHeadInvokeResult(resultList);
            invokeClassName = headResult.getSimpleClassName();
            invokeMethodName = headResult.getMethodName();
        } else {
            headResult = null;
            invokeClassName = this._dbmeta.getTableDbName();
            invokeMethodName = "unknown";
        }
        String expNoMethodSuffix = this.buildInvocationExpNoMethodSuffix(invokeClassName, invokeMethodName);
        String invocationExp = expNoMethodSuffix + "()";
        return new BehaviorInvokeNameResult(invocationExp, expNoMethodSuffix, headResult, resultList);
    }

    protected InvokeNameExtractingResource createResource() {
        final String readableName = this.getReadableName();
        final String writableName = this.getWritableName();
        final List<String> suffixList = this.getSuffixList();
        final List<String> keywordList = this.getKeywordList();
        final List<String> ousideSqlMarkList = this.getOusideSqlMarkList();
        final List<String> ousideSqlExecutorSuffixList = this.getOusideSqlExecutorSuffixList();
        final List<String> ousideSqlExecutorInnerList = this.getOusideSqlExecutorInnerList();
        return new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                if (BehaviorInvokeNameExtractor.this.isClassNameEndsWith(className, suffixList)) {
                    return true;
                }
                if (BehaviorInvokeNameExtractor.this.isClassNameContains(className, keywordList)) {
                    return true;
                }
                return this.isOutsideSqlElement(className);
            }

            protected boolean isOutsideSqlElement(String className) {
                if (!BehaviorInvokeNameExtractor.this.isClassNameContains(className, ousideSqlMarkList)) {
                    return false;
                }
                return BehaviorInvokeNameExtractor.this.isClassNameEndsWith(className, ousideSqlExecutorSuffixList) || BehaviorInvokeNameExtractor.this.isClassNameContains(className, ousideSqlExecutorInnerList);
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                if (simpleClassName.endsWith(readableName)) {
                    return readableName;
                }
                if (simpleClassName.endsWith(writableName)) {
                    return writableName;
                }
                return BehaviorInvokeNameExtractor.this.removeBasePrefix(simpleClassName);
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return false;
            }

            @Override
            public int getStartIndex() {
                return 0;
            }

            @Override
            public int getLoopSize() {
                return BehaviorInvokeNameExtractor.this.getInvocationExtractingMaxLoopSize();
            }
        };
    }

    protected String getReadableName() {
        return _readableName;
    }

    protected String getWritableName() {
        return _writableName;
    }

    protected List<String> getSuffixList() {
        return _suffixList;
    }

    protected List<String> getKeywordList() {
        return _keywordList;
    }

    protected List<String> getOusideSqlMarkList() {
        return _ousideSqlMarkList;
    }

    protected List<String> getOusideSqlExecutorSuffixList() {
        return _ousideSqlExecutorSuffixList;
    }

    protected List<String> getOusideSqlExecutorInnerList() {
        return _ousideSqlExecutorInnerList;
    }

    protected int getInvocationExtractingMaxLoopSize() {
        return 25;
    }

    protected List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        return this._coinLogic.extractInvokeName(resource, stackTrace);
    }

    protected <RESULT> void filterBehaviorResult(List<InvokeNameResult> behaviorResultList) {
        for (InvokeNameResult behaviorResult : behaviorResultList) {
            String simpleClassName = behaviorResult.getSimpleClassName();
            if (simpleClassName == null) {
                return;
            }
            if (!simpleClassName.contains("Behavior") || !simpleClassName.endsWith("$SLFunction")) continue;
            String behaviorClassName = this.findBehaviorClassNameFromDBMeta();
            behaviorResult.setSimpleClassName(behaviorClassName);
            behaviorResult.setMethodName("scalarSelect()." + behaviorResult.getMethodName());
        }
    }

    protected InvokeNameResult findHeadInvokeResult(List<InvokeNameResult> resultList) {
        if (!resultList.isEmpty()) {
            return resultList.get(resultList.size() - 1);
        }
        return null;
    }

    protected <RESULT> String buildInvocationExpNoMethodSuffix(String invokeClassName, String invokeMethodName) {
        String resolvedClassName = this.resolveOutsideSqlExecutor(invokeClassName);
        String callerExpNoMethodSuffix = resolvedClassName + "." + invokeMethodName;
        return this.resolveOutsideSqlPaging(invokeMethodName, callerExpNoMethodSuffix);
    }

    protected String resolveOutsideSqlExecutor(String invokeClassName) {
        String resolved;
        if (!this.isOutsideSqlExecutor(invokeClassName)) {
            return invokeClassName;
        }
        if (this._outsideSqlResultType != null) {
            String behaviorClassName = this.findBehaviorClassNameFromDBMeta();
            String outsideSqlCall = behaviorClassName + ".outsideSql()";
            resolved = invokeClassName.contains("Entity") ? outsideSqlCall + ".entityHandling()" : (invokeClassName.contains("Paging") ? (this._outsideSqlAutoPaging ? outsideSqlCall + ".autoPaging()" : outsideSqlCall + ".manualPaging()") : (invokeClassName.contains("Cursor") ? outsideSqlCall + ".cursorHandling()" : outsideSqlCall));
        } else {
            resolved = "OutsideSql";
        }
        return resolved;
    }

    protected boolean isOutsideSqlExecutor(String invokeClassName) {
        return invokeClassName.contains("OutsideSql") && invokeClassName.endsWith("Executor");
    }

    protected String resolveOutsideSqlPaging(String invokeMethodName, String callerExpNoMethodSuffix) {
        String resolved = this._outsideSqlResultType != null && "selectPage".equals(invokeMethodName) ? (Integer.class.isAssignableFrom(this._outsideSqlResultType) ? callerExpNoMethodSuffix + "():count" : callerExpNoMethodSuffix + "():paging") : callerExpNoMethodSuffix;
        return resolved;
    }

    protected String findBehaviorClassNameFromDBMeta() {
        String behaviorClassName;
        String behaviorTypeName = this._dbmeta.getBehaviorTypeName();
        int dotIndex = behaviorTypeName.lastIndexOf(".");
        if (dotIndex < 0) {
            behaviorClassName = behaviorTypeName;
        } else {
            int simpleNameIndex = dotIndex + ".".length();
            behaviorClassName = behaviorTypeName.substring(simpleNameIndex);
        }
        return this.removeBasePrefix(behaviorClassName);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        return this._coinLogic.isClassNameEndsWith(className, suffixList);
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        return this._coinLogic.isClassNameContains(className, keywordList);
    }

    protected String removeBasePrefix(String simpleClassName) {
        return this._coinLogic.removeBasePrefix(simpleClassName);
    }
}

