/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.extracting.EntityColumnExtractor;
import org.seasar.dbflute.cbean.grouping.GroupingListDeterminer;
import org.seasar.dbflute.cbean.grouping.GroupingListRowResource;
import org.seasar.dbflute.cbean.grouping.GroupingMapDeterminer;
import org.seasar.dbflute.cbean.grouping.GroupingOption;
import org.seasar.dbflute.cbean.grouping.GroupingRowEndDeterminer;
import org.seasar.dbflute.cbean.grouping.GroupingRowResource;
import org.seasar.dbflute.cbean.grouping.GroupingRowSetupper;
import org.seasar.dbflute.cbean.mapping.EntityDtoMapper;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;

public class ListResultBean<ENTITY>
implements List<ENTITY>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _tableDbName;
    protected int _allRecordCount;
    protected List<ENTITY> _selectedList = new ArrayList<ENTITY>();
    protected OrderByClause _orderByClause = new OrderByClause();

    public List<ListResultBean<ENTITY>> groupingList(GroupingListDeterminer<ENTITY> determiner) {
        ArrayList<ListResultBean<ENTITY>> groupingRowList = new ArrayList<ListResultBean<ENTITY>>();
        GroupingListRowResource<ENTITY> rowResource = new GroupingListRowResource<ENTITY>();
        int rowElementIndex = 0;
        int wholeElementIndex = 0;
        for (ENTITY entity : this._selectedList) {
            rowResource.addGroupingEntity(entity);
            rowResource.setCurrentIndex(rowElementIndex);
            if (this._selectedList.size() == wholeElementIndex + 1) {
                groupingRowList.add(this.createInheritedResultBean(rowResource.getGroupingEntityList()));
                break;
            }
            ENTITY nextElement = this._selectedList.get(wholeElementIndex + 1);
            if (determiner.isBreakRow(rowResource, nextElement)) {
                groupingRowList.add(this.createInheritedResultBean(rowResource.getGroupingEntityList()));
                rowResource = new GroupingListRowResource();
                rowElementIndex = 0;
                ++wholeElementIndex;
                continue;
            }
            ++rowElementIndex;
            ++wholeElementIndex;
        }
        return groupingRowList;
    }

    public Map<String, ListResultBean<ENTITY>> groupingMap(GroupingMapDeterminer<ENTITY> determiner) {
        LinkedHashMap<String, ListResultBean<ENTITY>> groupingListMap = new LinkedHashMap<String, ListResultBean<ENTITY>>();
        for (ENTITY entity : this._selectedList) {
            String groupingKey = determiner.provideKey(entity);
            ListResultBean<ENTITY> rowList = (ListResultBean<ENTITY>)groupingListMap.get(groupingKey);
            if (rowList == null) {
                rowList = this.createInheritedResultBean(null);
                groupingListMap.put(groupingKey, rowList);
            }
            rowList.add(entity);
        }
        return groupingListMap;
    }

    public <ROW> List<ROW> groupingList(GroupingRowSetupper<ROW, ENTITY> groupingRowSetupper, GroupingOption<ENTITY> groupingOption) {
        ArrayList<ROW> groupingList = new ArrayList<ROW>();
        int breakCount = groupingOption.getElementCount();
        GroupingRowEndDeterminer endDeterminer = groupingOption.getGroupingRowEndDeterminer();
        if (endDeterminer == null) {
            endDeterminer = new GroupingRowEndDeterminer<ENTITY>(){

                @Override
                public boolean determine(GroupingRowResource<ENTITY> rowResource, ENTITY nextEntity) {
                    return rowResource.isSizeUpBreakCount();
                }
            };
        }
        GroupingRowResource<ENTITY> rowResource = new GroupingRowResource<ENTITY>();
        int rowElementIndex = 0;
        int allElementIndex = 0;
        for (ENTITY entity : this._selectedList) {
            rowResource.addGroupingRowList(entity);
            rowResource.setElementCurrentIndex(rowElementIndex);
            rowResource.setBreakCount(breakCount);
            if (this._selectedList.size() == allElementIndex + 1) {
                ROW groupingRowObject = groupingRowSetupper.setup(rowResource);
                groupingList.add(groupingRowObject);
                break;
            }
            ENTITY nextElement = this._selectedList.get(allElementIndex + 1);
            if (endDeterminer.determine(rowResource, nextElement)) {
                ROW groupingRowObject = groupingRowSetupper.setup(rowResource);
                groupingList.add(groupingRowObject);
                rowResource = new GroupingRowResource();
                rowElementIndex = 0;
                ++allElementIndex;
                continue;
            }
            ++rowElementIndex;
            ++allElementIndex;
        }
        return groupingList;
    }

    public <DTO> ListResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityDtoMapper) {
        ListResultBean<DTO> mappingList = new ListResultBean<DTO>();
        for (ENTITY entity : this._selectedList) {
            mappingList.add(entityDtoMapper.map(entity));
        }
        mappingList.setTableDbName(this.getTableDbName());
        mappingList.setAllRecordCount(this.getAllRecordCount());
        mappingList.setOrderByClause(this.getOrderByClause());
        return mappingList;
    }

    public <COLUMN> List<COLUMN> extractColumnList(EntityColumnExtractor<ENTITY, COLUMN> entityColumnExtractor) {
        ArrayList<COLUMN> columnList = new ArrayList<COLUMN>();
        for (ENTITY entity : this._selectedList) {
            COLUMN column = entityColumnExtractor.extract(entity);
            if (column == null) continue;
            columnList.add(column);
        }
        return columnList;
    }

    public <COLUMN> Set<COLUMN> extractColumnSet(EntityColumnExtractor<ENTITY, COLUMN> entityColumnExtractor) {
        LinkedHashSet<COLUMN> columnSet = new LinkedHashSet<COLUMN>();
        for (ENTITY entity : this._selectedList) {
            COLUMN column = entityColumnExtractor.extract(entity);
            if (column == null) continue;
            columnSet.add(column);
        }
        return columnSet;
    }

    public boolean isSelectedResult() {
        return this._tableDbName != null;
    }

    protected ListResultBean<ENTITY> createInheritedResultBean(List<ENTITY> selectedList) {
        ListResultBean<ENTITY> rb = this.newInheritedResultBean();
        rb.setTableDbName(this.getTableDbName());
        rb.setAllRecordCount(this.getAllRecordCount());
        rb.setOrderByClause(this.getOrderByClause());
        rb.setSelectedList(selectedList);
        return rb;
    }

    protected ListResultBean<ENTITY> newInheritedResultBean() {
        return new ListResultBean<ENTITY>();
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this._selectedList != null) {
            result = 31 * result + ((Object)this._selectedList).hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof List)) {
            return false;
        }
        if (this._selectedList == null) {
            return false;
        }
        if (other instanceof ListResultBean) {
            return ((Object)this._selectedList).equals(((ListResultBean)other).getSelectedList());
        }
        return ((Object)this._selectedList).equals(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._tableDbName);
        sb.append(",").append(this._allRecordCount);
        sb.append(",").append(this._orderByClause != null ? this._orderByClause.getOrderByClause() : null);
        sb.append(",").append(this._selectedList);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean add(ENTITY o) {
        return this._selectedList.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends ENTITY> c) {
        return this._selectedList.addAll(c);
    }

    @Override
    public void clear() {
        this._selectedList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this._selectedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._selectedList.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this._selectedList.isEmpty();
    }

    @Override
    public Iterator<ENTITY> iterator() {
        return this._selectedList.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this._selectedList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._selectedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._selectedList.retainAll(c);
    }

    @Override
    public int size() {
        return this._selectedList.size();
    }

    @Override
    public Object[] toArray() {
        return this._selectedList.toArray();
    }

    @Override
    public <TYPE> TYPE[] toArray(TYPE[] a) {
        return this._selectedList.toArray(a);
    }

    @Override
    public void add(int index, ENTITY element) {
        this._selectedList.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ENTITY> c) {
        return this._selectedList.addAll(index, c);
    }

    @Override
    public ENTITY get(int index) {
        return this._selectedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this._selectedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._selectedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<ENTITY> listIterator() {
        return this._selectedList.listIterator();
    }

    @Override
    public ListIterator<ENTITY> listIterator(int index) {
        return this._selectedList.listIterator(index);
    }

    @Override
    public ENTITY remove(int index) {
        return this._selectedList.remove(index);
    }

    @Override
    public ENTITY set(int index, ENTITY element) {
        return this._selectedList.set(index, element);
    }

    @Override
    public List<ENTITY> subList(int fromIndex, int toIndex) {
        return this._selectedList.subList(fromIndex, toIndex);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public int getAllRecordCount() {
        return this._allRecordCount;
    }

    public void setAllRecordCount(int allRecordCount) {
        this._allRecordCount = allRecordCount;
    }

    public List<ENTITY> getSelectedList() {
        return this._selectedList;
    }

    public void setSelectedList(List<ENTITY> selectedList) {
        if (selectedList == null) {
            return;
        }
        this._selectedList = selectedList;
    }

    public OrderByClause getOrderByClause() {
        return this._orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        if (orderByClause == null) {
            return;
        }
        this._orderByClause = orderByClause;
    }
}

