/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.dbflute.cbean.chelper.HpColumnSpHandler;
import org.seasar.dbflute.cbean.chelper.HpSpQyCall;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.join.InnerJoinNoWaySpeaker;
import org.seasar.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.resource.DBFluteSystem;

public abstract class HpAbstractSpecification<CQ extends ConditionQuery>
implements HpColumnSpHandler {
    protected final ConditionBean _baseCB;
    protected final HpSpQyCall<CQ> _qyCall;
    protected HpSpQyCall<CQ> _syncQyCall;
    protected final HpCBPurpose _purpose;
    protected final DBMetaProvider _dbmetaProvider;
    protected CQ _query;
    protected boolean _alreadySpecifiedRequiredColumn;
    protected Map<String, HpSpecifiedColumn> _specifiedColumnMap;
    protected boolean _alreadySpecifiedEveryColumn;
    protected boolean _alreadySpecifiedExceptColumn;

    protected HpAbstractSpecification(ConditionBean baseCB, HpSpQyCall<CQ> qyCall, HpCBPurpose purpose, DBMetaProvider dbmetaProvider) {
        this._baseCB = baseCB;
        this._qyCall = qyCall;
        this._purpose = purpose;
        this._dbmetaProvider = dbmetaProvider;
    }

    @Override
    public HpSpecifiedColumn xspecifyColumn(String columnName) {
        return this.doColumn(columnName);
    }

    protected HpSpecifiedColumn doColumn(String columnName) {
        String tableAliasName;
        this.checkSpecifiedThemeColumnStatus(columnName);
        if (this.isSpecifiedColumn(columnName)) {
            return this.getSpecifiedColumn(columnName);
        }
        this.assertColumn(columnName);
        this.callQuery();
        if (this.isRequiredColumnSpecificationEnabled()) {
            this._alreadySpecifiedRequiredColumn = true;
            this.doSpecifyRequiredColumn();
        }
        SqlClause sqlClause = this._baseCB.getSqlClause();
        if (this._query.isBaseQuery()) {
            tableAliasName = sqlClause.getBasePointAliasName();
        } else {
            String relationPath = this._query.xgetRelationPath();
            int nestLevel = this._query.xgetNestLevel();
            tableAliasName = sqlClause.resolveJoinAliasName(relationPath, nestLevel);
            this.keepDreamCruiseJourneyLogBookIfNeeds(relationPath, tableAliasName);
            this.reflectDreamCruiseWhereUsedToJoin(relationPath, tableAliasName);
        }
        HpSpecifiedColumn specifiedColumn = this.createSpecifiedColumn(columnName, tableAliasName);
        sqlClause.specifySelectColumn(specifiedColumn);
        this.saveSpecifiedColumn(columnName, specifiedColumn);
        return specifiedColumn;
    }

    protected void checkSpecifiedThemeColumnStatus(String columnName) {
        if (this._alreadySpecifiedEveryColumn) {
            this.throwSpecifyColumnAlreadySpecifiedEveryColumnException(columnName);
        }
        if (this._alreadySpecifiedExceptColumn) {
            this.throwSpecifyColumnAlreadySpecifiedExceptColumnException(columnName);
        }
    }

    protected void callQuery() {
        if (this._query == null) {
            this._query = this.qyCall().qy();
        }
    }

    protected HpSpQyCall<CQ> qyCall() {
        return this._syncQyCall != null ? this._syncQyCall : this._qyCall;
    }

    protected boolean isRequiredColumnSpecificationEnabled() {
        if (this._alreadySpecifiedRequiredColumn) {
            return false;
        }
        return this.isNormalUse();
    }

    protected abstract void doSpecifyRequiredColumn();

    protected abstract String getTableDbName();

    protected HpSpecifiedColumn createSpecifiedColumn(String columnName, String tableAliasName) {
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(this._query.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnName);
        return new HpSpecifiedColumn(tableAliasName, columnInfo, this._baseCB);
    }

    public HpSpecifiedColumn getSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null ? this._specifiedColumnMap.get(columnName) : null;
    }

    @Override
    public boolean hasSpecifiedColumn() {
        return this._specifiedColumnMap != null && !this._specifiedColumnMap.isEmpty();
    }

    @Override
    public boolean isSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null && this._specifiedColumnMap.containsKey(columnName);
    }

    protected void saveSpecifiedColumn(String columnName, HpSpecifiedColumn specifiedColumn) {
        if (this._specifiedColumnMap == null) {
            this._specifiedColumnMap = new LinkedHashMap<String, HpSpecifiedColumn>();
        }
        this._specifiedColumnMap.put(columnName, specifiedColumn);
    }

    protected void keepDreamCruiseJourneyLogBookIfNeeds(String relationPath, String tableAliasName) {
        if (!this._baseCB.xisDreamCruiseShip()) {
            return;
        }
        this._baseCB.xkeepDreamCruiseJourneyLogBook(relationPath);
    }

    protected void reflectDreamCruiseWhereUsedToJoin(String relationPath, String tableAliasName) {
        if (!this._baseCB.xisDreamCruiseShip()) {
            return;
        }
        ConditionBean portCB = this._baseCB.xgetDreamCruiseDeparturePort();
        QueryUsedAliasInfo usedAliasInfo = new QueryUsedAliasInfo(tableAliasName, new InnerJoinNoWaySpeaker(){

            @Override
            public boolean isNoWayInner() {
                return true;
            }
        });
        portCB.getSqlClause().reflectWhereUsedToJoin(usedAliasInfo);
    }

    protected void doEveryColumn() {
        if (this.hasSpecifiedColumn()) {
            this.throwSpecifyEveryColumnAlreadySpecifiedColumnException();
        }
        this.callQuery();
        boolean specifiedUpdateUse = this.isSpecifiedUpdateUse();
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            if (specifiedUpdateUse && columnInfo.isPrimary()) continue;
            this.doColumn(columnInfo.getColumnDbName());
        }
        this._alreadySpecifiedEveryColumn = true;
    }

    @Override
    public boolean isSpecifiedEveryColumn() {
        return this._alreadySpecifiedEveryColumn;
    }

    protected void doExceptRecordMetaColumn() {
        if (this.hasSpecifiedColumn()) {
            this.throwSpecifyExceptColumnAlreadySpecifiedColumnException();
        }
        this.callQuery();
        boolean specifiedUpdateUse = this.isSpecifiedUpdateUse();
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            if (this.isRecordMetaColumn(columnInfo) || specifiedUpdateUse && columnInfo.isPrimary()) continue;
            this.doColumn(columnInfo.getColumnDbName());
        }
        this._alreadySpecifiedExceptColumn = true;
    }

    @Override
    public boolean isSpecifiedExceptColumn() {
        return this._alreadySpecifiedExceptColumn;
    }

    protected boolean isRecordMetaColumn(ColumnInfo columnInfo) {
        return columnInfo.isCommonColumn() || columnInfo.isOptimisticLock();
    }

    protected List<ColumnInfo> getColumnInfoList() {
        String tableDbName = this._query.getTableDbName();
        DBMeta dbmeta = this._dbmetaProvider.provideDBMeta(tableDbName);
        return dbmeta.getColumnInfoList();
    }

    protected boolean isSpecifiedUpdateUse() {
        return HpCBPurpose.SPECIFIED_UPDATE.equals((Object)this._purpose);
    }

    protected void assertColumn(String columnName) {
        if (this._purpose.isNoSpecifyColumnTwoOrMore() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnTwoOrMoreColumnException(columnName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this.hasDerivedReferrer()) {
            this.throwSpecifyColumnWithDerivedReferrerException(columnName, null);
        }
        if (this.isNormalUse() && this._query == null && !this.qyCall().has()) {
            this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
        }
    }

    protected void assertRelation(String relationName) {
        if (this._purpose.isNoSpecifyRelation()) {
            this.throwSpecifyRelationIllegalPurposeException(relationName);
        }
    }

    protected void assertDerived(String referrerName) {
        if (this._purpose.isNoSpecifyDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerIllegalPurposeException(referrerName);
        }
        if (this._purpose.isNoSpecifyDerivedReferrerTwoOrMore() && this.hasDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerTwoOrMoreException(referrerName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnWithDerivedReferrerException(null, referrerName);
        }
    }

    protected boolean isNormalUse() {
        return HpCBPurpose.NORMAL_USE.equals((Object)this._purpose);
    }

    public boolean isAlreadySpecifiedRequiredColumn() {
        return this._alreadySpecifiedRequiredColumn;
    }

    protected boolean hasDerivedReferrer() {
        return !this._baseCB.getSqlClause().getSpecifiedDerivingAliasList().isEmpty();
    }

    public HpSpQyCall<CQ> xsyncQyCall() {
        return this._syncQyCall;
    }

    public void xsetSyncQyCall(HpSpQyCall<CQ> qyCall) {
        this._syncQyCall = qyCall;
    }

    @Override
    public boolean xhasSyncQyCall() {
        return this._syncQyCall != null;
    }

    protected void throwSpecifyColumnTwoOrMoreColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnTwoOrMoreColumnException(this._purpose, this._baseCB, columnName);
    }

    protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnNotSetupSelectColumnException(this._baseCB, columnName);
    }

    protected void throwSpecifyColumnWithDerivedReferrerException(String columnName, String referrerName) {
        this.createCBExThrower().throwSpecifyColumnWithDerivedReferrerException(this._purpose, this._baseCB, columnName, referrerName);
    }

    protected void throwSpecifyColumnAlreadySpecifiedEveryColumnException(String columnName) {
        String tableDbName = this._baseCB.getTableDbName();
        this.createCBExThrower().throwSpecifyColumnAlreadySpecifiedEveryColumnException(tableDbName, columnName);
    }

    protected void throwSpecifyColumnAlreadySpecifiedExceptColumnException(String columnName) {
        String tableDbName = this._baseCB.getTableDbName();
        this.createCBExThrower().throwSpecifyColumnAlreadySpecifiedExceptColumnException(tableDbName, columnName);
    }

    protected void throwSpecifyEveryColumnAlreadySpecifiedColumnException() {
        String tableDbName = this._baseCB.getTableDbName();
        this.createCBExThrower().throwSpecifyEveryColumnAlreadySpecifiedColumnException(tableDbName, this._specifiedColumnMap);
    }

    protected void throwSpecifyExceptColumnAlreadySpecifiedColumnException() {
        String tableDbName = this._baseCB.getTableDbName();
        this.createCBExThrower().throwSpecifyExceptColumnAlreadySpecifiedColumnException(tableDbName, this._specifiedColumnMap);
    }

    protected void throwSpecifyRelationIllegalPurposeException(String relationName) {
        this.createCBExThrower().throwSpecifyRelationIllegalPurposeException(this._purpose, this._baseCB, relationName);
    }

    protected void throwSpecifyDerivedReferrerIllegalPurposeException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerIllegalPurposeException(this._purpose, this._baseCB, referrerName);
    }

    protected void throwSpecifyDerivedReferrerTwoOrMoreException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerTwoOrMoreException(this._purpose, this._baseCB, referrerName);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

