/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.coption.ParameterOption;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDb2;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDerby;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseH2;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.dbflute.cbean.sqlclause.SqlClausePostgreSql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseSqlServer;
import org.seasar.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public class FunctionFilterOption
implements ParameterOption {
    protected static final String DATE_TRUNC_MONTH = "df:month";
    protected static final String DATE_TRUNC_DAY = "df:day";
    protected static final String DATE_TRUNC_TIME = "df:time";
    protected Map<String, Object> _bindMap;
    protected List<ProcessCallback> _callbackList;
    protected String _parameterKey;
    protected String _parameterMapPath;
    protected ColumnInfo _targetColumnInfo;
    protected Object _mysticBindingSnapshot;
    protected boolean _databaseMySQL;
    protected boolean _databasePostgreSQL;
    protected boolean _databaseOracle;
    protected boolean _databaseDB2;
    protected boolean _databaseSQLServer;
    protected boolean _databaseH2;
    protected boolean _databaseDerby;
    protected Object _tmpTrunc;
    protected boolean _mayNullRevived;

    protected void doCoalesce(final Object coalesce) {
        this.addProcessCallback("coalesce", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processCoalesce(functionExp, index, coalesce);
            }
        });
        this._mayNullRevived = true;
    }

    protected void doRound(final Object round) {
        this.addProcessCallback("round", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processRound(functionExp, index, round);
            }
        });
    }

    protected void doTrunc(final Object trunc) {
        this._tmpTrunc = trunc;
        this.addProcessCallback("trunc", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processTrunc(functionExp, index, trunc);
            }
        });
    }

    protected void doTruncMonth() {
        this.doTrunc(DATE_TRUNC_MONTH);
    }

    protected void doTruncDay() {
        this.doTrunc(DATE_TRUNC_DAY);
    }

    protected void doTruncTime() {
        this.doTrunc(DATE_TRUNC_TIME);
    }

    protected void doAddYear(Object addedYear) {
        this.doAddYear(addedYear, false);
    }

    protected void doAddYear(final Object addedYear, final boolean minus) {
        this.assertAddedValueNotNull("year", addedYear);
        this.addProcessCallback("addYear", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddYear(functionExp, index, addedYear, minus);
            }
        });
    }

    protected void doAddMonth(Object addedMonth) {
        this.doAddMonth(addedMonth, false);
    }

    protected void doAddMonth(final Object addedMonth, final boolean minus) {
        this.assertAddedValueNotNull("month", addedMonth);
        this.addProcessCallback("addMonth", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddMonth(functionExp, index, addedMonth, minus);
            }
        });
    }

    protected void doAddDay(Object addedDay) {
        this.doAddDay(addedDay, false);
    }

    protected void doAddDay(final Object addedDay, final boolean minus) {
        this.assertAddedValueNotNull("day", addedDay);
        this.addProcessCallback("addDay", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddDay(functionExp, index, addedDay, minus);
            }
        });
    }

    protected void doAddHour(Object addedHour) {
        this.doAddHour(addedHour, false);
    }

    protected void doAddHour(final Object addedHour, final boolean minus) {
        this.assertAddedValueNotNull("hour", addedHour);
        this.addProcessCallback("addHour", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddHour(functionExp, index, addedHour, minus);
            }
        });
    }

    protected void doAddMinute(Object addedMinute) {
        this.doAddMinute(addedMinute, false);
    }

    protected void doAddMinute(final Object addedMinute, final boolean minus) {
        this.assertAddedValueNotNull("minute", addedMinute);
        this.addProcessCallback("addMinute", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddMinute(functionExp, index, addedMinute, minus);
            }
        });
    }

    protected void doAddSecond(Object addedSecond) {
        this.doAddSecond(addedSecond, false);
    }

    protected void doAddSecond(final Object addedSecond, final boolean minus) {
        this.assertAddedValueNotNull("second", addedSecond);
        this.addProcessCallback("addSecond", new ProcessCallback(){

            @Override
            public String callback(String functionExp, int index) {
                return FunctionFilterOption.this.processAddSecond(functionExp, index, addedSecond, minus);
            }
        });
    }

    public String filterFunction(String functionExp) {
        String filtered = functionExp;
        List<ProcessCallback> callbackList = this._callbackList;
        if (callbackList != null) {
            int index = 0;
            for (ProcessCallback callback : callbackList) {
                filtered = callback.callback(filtered, index);
                ++index;
            }
        }
        return this.processVarious(this.processCalculation(filtered));
    }

    protected void addProcessCallback(String functionKey, ProcessCallback callback) {
        if (this._callbackList == null) {
            this._callbackList = new ArrayList<ProcessCallback>(4);
        }
        this._callbackList.add(callback);
    }

    protected String processCoalesce(String functionExp, int index, Object coalesce) {
        if (coalesce == null) {
            return functionExp;
        }
        Object realParam = coalesce instanceof String && this.isDateTypeColumn() ? DfTypeUtil.toDate(coalesce) : coalesce;
        Object bindKey = this.registerBindParameter(index, realParam);
        String functionName = "coalesce";
        return this.processSimpleFunction(functionExp, "coalesce", null, false, bindKey);
    }

    protected String processRound(String functionExp, int index, Object round) {
        if (round == null) {
            return functionExp;
        }
        Object bindKey = this.registerBindParameter(index, round);
        String functionName = "round";
        return this.processSimpleFunction(functionExp, "round", null, false, bindKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processTrunc(String functionExp, int index, Object trunc) {
        if (trunc == null) {
            return functionExp;
        }
        this._tmpTrunc = trunc;
        try {
            String processed;
            if (this.isDateTypeColumn() && (processed = this.doProcessTruncPurposeDateType(functionExp)) != null) {
                String string = processed;
                return string;
            }
            String string = this.doProcessTruncSimpleCase(functionExp, index, this._tmpTrunc);
            return string;
        }
        finally {
            this._tmpTrunc = null;
        }
    }

    protected String doProcessTruncPurposeDateType(String functionExp) {
        String processed = this.isDatabaseMySQL() ? this.doProcessTruncPurposeDateTypeMySQL(functionExp) : (this.isDatabasePostgreSQL() ? this.doProcessTruncPurposeDateTypePostgreSQL(functionExp) : (this.isDatabaseOracle() ? this.doProcessTruncPurposeDateTypeOracle(functionExp) : (this.isDatabaseDB2() ? this.doProcessTruncPurposeDateTypeDB2(functionExp) : (this.isDatabaseSQLServer() ? this.doProcessTruncPurposeDateTypeSQLServer(functionExp) : this.doProcessTruncPurposeDateTypeDefault(functionExp)))));
        return processed;
    }

    protected String doProcessTruncPurposeDateTypeMySQL(String functionExp) {
        if (this.isDateTruncMonth()) {
            return "cast(concat(substring(" + functionExp + ", 1, 4), '-01-01') as date)";
        }
        if (this.isDateTruncDay()) {
            return "cast(concat(substring(" + functionExp + ", 1, 7), '-01') as date)";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(" + functionExp + ", 1, 10) as date)";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypePostgreSQL(String functionExp) {
        if (this.isDateTruncMonth()) {
            this._tmpTrunc = "year";
        } else if (this.isDateTruncDay()) {
            this._tmpTrunc = "month";
        } else if (this.isDateTruncTime()) {
            this._tmpTrunc = "day";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeOracle(String functionExp) {
        if (this.isDateTruncMonth()) {
            this._tmpTrunc = "YYYY";
        } else if (this.isDateTruncDay()) {
            this._tmpTrunc = "MM";
        } else if (this.isDateTruncTime()) {
            this._tmpTrunc = "DD";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeDB2(String functionExp) {
        String finalType;
        String baseExp = "cast(to_char(" + functionExp + ", 'yyyy";
        String timePartBasicSuffix = this.isJustDateTypeColumn() ? "" : " 00:00:00";
        String string = finalType = this.isJustDateTypeColumn() ? "date" : "timestamp";
        if (this.isDateTruncMonth()) {
            return baseExp + "') || '-01-01" + timePartBasicSuffix + "' as " + finalType + ")";
        }
        if (this.isDateTruncDay()) {
            return baseExp + "-MM') || '-01" + timePartBasicSuffix + "' as " + finalType + ")";
        }
        if (this.isDateTruncTime()) {
            String timePartConnectSuffix = this.isJustDateTypeColumn() ? "" : " || ' 00:00:00'";
            return baseExp + "-MM-dd')" + timePartConnectSuffix + " as " + finalType + ")";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeSQLServer(String functionExp) {
        String baseExp = "cast(substring(convert(nvarchar, ";
        String finalType = "datetime";
        if (this.isDateTruncMonth()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 4) + '-01-01' as " + "datetime" + ")";
        }
        if (this.isDateTruncDay()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 7) + '-01' as " + "datetime" + ")";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 10) as " + "datetime" + ")";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeDefault(String functionExp) {
        String baseExp = "cast(substring(";
        String finalType = "date";
        if (this.isDateTruncMonth()) {
            return "cast(substring(" + functionExp + ", 1, 4) || '-01-01' as " + "date" + ")";
        }
        if (this.isDateTruncDay()) {
            return "cast(substring(" + functionExp + ", 1, 7) || '-01' as " + "date" + ")";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(" + functionExp + ", 1, 10) as " + "date" + ")";
        }
        return null;
    }

    protected boolean isDateTruncMonth() {
        return this._tmpTrunc.equals(DATE_TRUNC_MONTH);
    }

    protected boolean isDateTruncDay() {
        return this._tmpTrunc.equals(DATE_TRUNC_DAY);
    }

    protected boolean isDateTruncTime() {
        return this._tmpTrunc.equals(DATE_TRUNC_TIME);
    }

    protected String doProcessTruncSimpleCase(String functionExp, int index, Object trunc) {
        String functionName;
        String thirdArg = null;
        boolean leftArg = false;
        if (this.isTruncNamedTruncate()) {
            functionName = "truncate";
        } else if (this.isDatabaseSQLServer()) {
            functionName = "round";
            thirdArg = "1";
        } else if (this.isDatabasePostgreSQL() && this.isDateTypeColumn()) {
            functionName = "date_trunc";
            leftArg = true;
        } else {
            functionName = "trunc";
        }
        Object bindKey = this.registerBindParameter(index, trunc);
        return this.processSimpleFunction(functionExp, functionName, thirdArg, leftArg, bindKey);
    }

    protected boolean isTruncNamedTruncate() {
        return this.isDatabaseMySQL() || this.isDatabaseH2();
    }

    protected String processAddYear(String functionExp, int index, Object addedYear, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedYear, "addYear", minus);
    }

    protected String processAddMonth(String functionExp, int index, Object addedMonth, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedMonth, "addMonth", minus);
    }

    protected String processAddDay(String functionExp, int index, Object addedDay, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedDay, "addDay", minus);
    }

    protected String processAddHour(String functionExp, int index, Object addedHour, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedHour, "addHour", minus);
    }

    protected String processAddMinute(String functionExp, int index, Object addedMinute, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedMinute, "addMinute", minus);
    }

    protected String processAddSecond(String functionExp, int index, Object addedSecond, boolean minus) {
        return this.doProcessDateAdd(functionExp, index, addedSecond, "addSecond", minus);
    }

    protected String doProcessDateAdd(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        if (addedValue == null) {
            return functionExp;
        }
        if (!this.isDateTypeColumn()) {
            String msg = "The column should be Date type for the function e.g. addDay():";
            msg = msg + " column=" + this._targetColumnInfo;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (this.isDatabaseMySQL()) {
            return this.doProcessDateAddMySQL(functionExp, index, addedValue, propertyName, minus);
        }
        if (this.isDatabasePostgreSQL()) {
            return this.doProcessDateAddPostgreSQL(functionExp, index, addedValue, propertyName, minus);
        }
        if (this.isDatabaseOracle()) {
            return this.doProcessDateAddOracle(functionExp, index, addedValue, propertyName, minus);
        }
        if (this.isDatabaseDB2()) {
            return this.doProcessDateAddDB2(functionExp, index, addedValue, propertyName, minus);
        }
        if (this.isDatabaseSQLServer()) {
            return this.doProcessDateAddSQLServer(functionExp, index, addedValue, propertyName, minus);
        }
        if (this.isDatabaseH2()) {
            return this.doProcessDateAddSQLServer(functionExp, index, addedValue, propertyName, minus);
        }
        String msg = "Unsupported database to the function addXxx(): " + propertyName;
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected String doProcessDateAddMySQL(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        String bindPath = this.buildAddedBindParameter(index, addedValue, propertyName);
        String type = this.buildDateAddExpType(propertyName, null, false);
        String prefixSign = minus ? "-" : "";
        return "date_add(" + functionExp + ", interval " + prefixSign + bindPath + " " + type + ")";
    }

    protected String doProcessDateAddPostgreSQL(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        String calcSign;
        String type = this.buildDateAddExpType(propertyName, null, true);
        String baseValueExp = this.buildAddedEmbeddedValueExp(addedValue);
        String valueExp = this.isDreamCruiseTicket(addedValue) ? "(" + baseValueExp + " || '" + type + "')::interval" : "'" + baseValueExp + " " + type + "'";
        String string = calcSign = minus ? "-" : "+";
        if (this.hasMysticBinding() || this.isJustDateTypeColumn()) {
            return "cast(" + functionExp + " as timestamp) " + calcSign + " " + valueExp;
        }
        return functionExp + " " + calcSign + " " + valueExp;
    }

    protected String doProcessDateAddOracle(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        String calcSign;
        String bindParameter = this.buildAddedBindParameter(index, addedValue, propertyName);
        String prefixSign = minus ? "-" : "";
        String string = calcSign = minus ? "-" : "+";
        if (this.isPropertyAddYear(propertyName)) {
            return "add_months(" + functionExp + ", 12 * " + prefixSign + bindParameter + ")";
        }
        if (this.isPropertyAddMonth(propertyName)) {
            return "add_months(" + functionExp + ", " + prefixSign + bindParameter + ")";
        }
        if (this.isPropertyAddDay(propertyName)) {
            return functionExp + " " + calcSign + " " + bindParameter;
        }
        if (this.isPropertyAddHour(propertyName)) {
            return functionExp + " " + calcSign + " " + bindParameter + " / 24";
        }
        if (this.isPropertyAddMinute(propertyName)) {
            return functionExp + " " + calcSign + " " + bindParameter + " / 1440";
        }
        if (this.isPropertyAddSecond(propertyName)) {
            return functionExp + " " + calcSign + " " + bindParameter + " / 86400";
        }
        String msg = "Unknown property for date-add: " + propertyName;
        throw new IllegalStateException(msg);
    }

    protected String doProcessDateAddDB2(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        String closingSuffix;
        String baseFuncExp;
        String calcSign;
        String bindParameter = this.buildAddedBindParameter(index, addedValue, propertyName);
        String type = this.buildDateAddExpType(propertyName, null, false);
        String string = calcSign = minus ? "-" : "+";
        if (this.hasTargetColumnInfo()) {
            baseFuncExp = functionExp;
            closingSuffix = "";
        } else if (this.isJustDateTypeColumn()) {
            String castType = "date";
            baseFuncExp = "cast(cast(" + functionExp + " as timestamp)";
            closingSuffix = " as " + castType + ")";
        } else {
            String castType = "timestamp";
            baseFuncExp = "cast(" + functionExp + " as timestamp)";
            closingSuffix = "";
        }
        return baseFuncExp + " " + calcSign + " " + bindParameter + " " + type + closingSuffix;
    }

    protected String doProcessDateAddSQLServer(String functionExp, int index, Object addedValue, String propertyName, boolean minus) {
        String valueExp = this.buildAddedEmbeddedValueExp(addedValue);
        String type = this.buildDateAddExpType(propertyName, null, false);
        String prefixSign = minus ? "-" : "";
        return "dateadd(" + type + ", " + prefixSign + valueExp + ", " + functionExp + ")";
    }

    protected String buildDateAddExpType(String propertyName, String prefix, boolean plural) {
        String type;
        String suffix;
        prefix = prefix != null ? prefix : "";
        String string = suffix = plural ? "s" : "";
        if (this.isPropertyAddYear(propertyName)) {
            type = prefix + "year" + suffix;
        } else if (this.isPropertyAddMonth(propertyName)) {
            type = prefix + "month" + suffix;
        } else if (this.isPropertyAddDay(propertyName)) {
            type = prefix + "day" + suffix;
        } else if (this.isPropertyAddHour(propertyName)) {
            type = prefix + "hour" + suffix;
        } else if (this.isPropertyAddMinute(propertyName)) {
            type = prefix + "minute" + suffix;
        } else if (this.isPropertyAddSecond(propertyName)) {
            type = prefix + "second" + suffix;
        } else {
            String msg = "Unknown property for date-add: " + propertyName;
            throw new IllegalStateException(msg);
        }
        return type;
    }

    protected boolean isPropertyAddYear(String propertyName) {
        return "addYear".equals(propertyName);
    }

    protected boolean isPropertyAddMonth(String propertyName) {
        return "addMonth".equals(propertyName);
    }

    protected boolean isPropertyAddDay(String propertyName) {
        return "addDay".equals(propertyName);
    }

    protected boolean isPropertyAddHour(String propertyName) {
        return "addHour".equals(propertyName);
    }

    protected boolean isPropertyAddMinute(String propertyName) {
        return "addMinute".equals(propertyName);
    }

    protected boolean isPropertyAddSecond(String propertyName) {
        return "addSecond".equals(propertyName);
    }

    protected String buildAddedBindParameter(int index, Object addedValue, String propertyName) {
        Object bindKey = this.registerBindParameter(index, addedValue);
        return this.buildBindParameter(bindKey);
    }

    protected String buildAddedEmbeddedValueExp(Object addedValue) {
        String valueExp = this.isDreamCruiseTicket(addedValue) ? this.buildDreamCruiseTicketStatement(addedValue) : addedValue.toString();
        return valueExp;
    }

    protected String processCalculation(String functionExp) {
        return functionExp;
    }

    protected String processVarious(String functionExp) {
        return functionExp;
    }

    @Override
    public void acceptParameterKey(String parameterKey, String parameterMapPath) {
        this._parameterKey = parameterKey;
        this._parameterMapPath = parameterMapPath;
    }

    public SpecifyDerivedReferrer createSpecifyDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String aliasName) {
        return new SpecifyDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, aliasName);
    }

    public QueryDerivedReferrer createQueryDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand, Object value, String parameterPath) {
        return new QueryDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, operand, value, parameterPath);
    }

    public boolean mayNullRevived() {
        return this._mayNullRevived;
    }

    protected String processSimpleFunction(String functionExp, String functionName, String thirdArg, boolean leftArg, Object bindKey) {
        String pureFunction;
        String bindExp = this.buildBindParameter(bindKey);
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append("(");
        String sqend = "--#df:sqend#";
        boolean handleSqEnd = this.hasSubQueryEndOnLastLine(functionExp);
        String string = pureFunction = handleSqEnd ? Srl.substringLastFront(functionExp, "--#df:sqend#") : functionExp;
        if (leftArg) {
            sb.append(bindExp);
            if (handleSqEnd) {
                sb.append(this.ln()).append("       ");
            }
            sb.append(", ").append(pureFunction);
        } else {
            sb.append(pureFunction).append(", ").append(bindExp);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty(thirdArg)) {
            sb.append(", ").append(thirdArg);
        }
        sb.append(")");
        if (handleSqEnd) {
            sb.append("--#df:sqend#").append(Srl.substringLastRear(functionExp, "--#df:sqend#"));
        }
        return sb.toString();
    }

    protected String buildBindParameter(Object bindKey) {
        String bindExp = this.isDreamCruiseTicket(bindKey) ? this.buildDreamCruiseTicketStatement(bindKey) : "/*pmb." + this._parameterMapPath + "." + this._parameterKey + ".bindMap." + bindKey + "*/null";
        return bindExp;
    }

    protected boolean hasSubQueryEndOnLastLine(String functionExp) {
        return SubQueryIndentProcessor.hasSubQueryEndOnLastLine(functionExp);
    }

    protected boolean hasTargetColumnInfo() {
        return this._targetColumnInfo != null;
    }

    protected boolean isDateTypeColumn() {
        if (this._targetColumnInfo != null && this._targetColumnInfo.isObjectNativeTypeDate()) {
            return true;
        }
        return this._mysticBindingSnapshot != null && this._mysticBindingSnapshot instanceof Date;
    }

    protected boolean hasMysticBinding() {
        return this._mysticBindingSnapshot != null;
    }

    protected boolean isJustDateTypeColumn() {
        if (this._targetColumnInfo != null && this._targetColumnInfo.isObjectNativeTypeJustDate()) {
            return true;
        }
        return this._mysticBindingSnapshot != null && this._mysticBindingSnapshot.getClass().equals(Date.class);
    }

    protected boolean isDreamCruiseTicket(Object value) {
        return value instanceof HpSpecifiedColumn;
    }

    protected String buildDreamCruiseTicketStatement(Object value) {
        String bindPath;
        HpSpecifiedColumn specifiedColumn = (HpSpecifiedColumn)value;
        String columnExp = specifiedColumn.toColumnRealName().toString();
        if (specifiedColumn.hasSpecifyCalculation()) {
            specifiedColumn.xinitSpecifyCalculation();
            HpCalcSpecification<ConditionBean> calcSpecification = specifiedColumn.getSpecifyCalculation();
            bindPath = calcSpecification.buildStatementToSpecifidName(columnExp);
        } else {
            bindPath = columnExp;
        }
        return bindPath;
    }

    protected Object registerBindParameter(int index, Object parameter) {
        if (this.isDreamCruiseTicket(parameter)) {
            return parameter;
        }
        if (this._bindMap == null) {
            this._bindMap = new HashMap<String, Object>(4);
        }
        String bindKey = "param" + index;
        this._bindMap.put(bindKey, parameter);
        return bindKey;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(HpSpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isObjectNativeTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(HpSpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertAddedValueNotNull(String keyword, Object addedValue) {
        if (this.isAddedValueNullIgnored()) {
            return;
        }
        if (addedValue == null) {
            String msg = "The added value for " + keyword + " should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected boolean isAddedValueNullIgnored() {
        return true;
    }

    protected final String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        String callbackExp = this._callbackList != null ? this._callbackList.toString() : null;
        return title + ":{callback=" + callbackExp + ", bind=" + this._bindMap + "}";
    }

    public Map<String, Object> getBindMap() {
        return this._bindMap;
    }

    public Object getTrunc() {
        return this._tmpTrunc;
    }

    public ColumnInfo xgetTargetColumnInfo() {
        return this._targetColumnInfo;
    }

    public void xsetTargetColumnInfo(ColumnInfo targetColumnInfo) {
        this._targetColumnInfo = targetColumnInfo;
    }

    public Object xgetMysticBindingSnapshot() {
        return this._mysticBindingSnapshot;
    }

    public void xsetMysticBindingSnapshot(Object mysticBindingSnapshot) {
        this._mysticBindingSnapshot = mysticBindingSnapshot;
    }

    public void xjudgeDatabase(SqlClause sqlClause) {
        this.setDatabaseMySQL(sqlClause instanceof SqlClauseMySql);
        this.setDatabasePostgreSQL(sqlClause instanceof SqlClausePostgreSql);
        this.setDatabaseOracle(sqlClause instanceof SqlClauseOracle);
        this.setDatabaseDB2(sqlClause instanceof SqlClauseDb2);
        this.setDatabaseSQLServer(sqlClause instanceof SqlClauseSqlServer);
        this.setDatabaseH2(sqlClause instanceof SqlClauseH2);
        this.setDatabaseDerby(sqlClause instanceof SqlClauseDerby);
    }

    protected boolean isDatabaseMySQL() {
        return this._databaseMySQL;
    }

    protected void setDatabaseMySQL(boolean databaseMySQL) {
        this._databaseMySQL = databaseMySQL;
    }

    protected boolean isDatabasePostgreSQL() {
        return this._databasePostgreSQL;
    }

    protected void setDatabasePostgreSQL(boolean databasePostgreSQL) {
        this._databasePostgreSQL = databasePostgreSQL;
    }

    protected boolean isDatabaseOracle() {
        return this._databaseOracle;
    }

    protected void setDatabaseOracle(boolean databaseOracle) {
        this._databaseOracle = databaseOracle;
    }

    protected boolean isDatabaseDB2() {
        return this._databaseDB2;
    }

    protected void setDatabaseDB2(boolean databaseDB2) {
        this._databaseDB2 = databaseDB2;
    }

    protected boolean isDatabaseSQLServer() {
        return this._databaseSQLServer;
    }

    protected void setDatabaseSQLServer(boolean databaseSQLServer) {
        this._databaseSQLServer = databaseSQLServer;
    }

    protected boolean isDatabaseH2() {
        return this._databaseH2;
    }

    protected void setDatabaseH2(boolean databaseH2) {
        this._databaseH2 = databaseH2;
    }

    protected boolean isDatabaseDerby() {
        return this._databaseDerby;
    }

    protected void setDatabaseDerby(boolean databaseDerby) {
        this._databaseDerby = databaseDerby;
    }

    protected static interface ProcessCallback {
        public String callback(String var1, int var2);
    }
}

