/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbway.DBWay;
import org.seasar.dbflute.dbway.WayOfMySQL;
import org.seasar.dbflute.util.Srl;

public class SqlClauseMySql
extends AbstractSqlClause {
    private static final long serialVersionUID = 1L;
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";
    protected Integer _pagingBindingLimit;
    protected Integer _pagingBindingOffset;
    protected boolean _suppressPagingBinding;

    public SqlClauseMySql(String tableDbName) {
        super(tableDbName);
    }

    @Override
    public String getClause() {
        if (this.canFoundRows()) {
            return "select found_rows()";
        }
        return super.getClause();
    }

    protected boolean canFoundRows() {
        return this.canPagingCountLater() && this.isSelectClauseTypeNonUnionCount();
    }

    @Override
    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return this.createOrderByNullsSetupperByCaseWhen();
    }

    @Override
    protected void doFetchFirst() {
        this.doFetchPage();
    }

    @Override
    protected void doFetchPage() {
        if (this._suppressPagingBinding) {
            this._fetchScopeSqlSuffix = " limit " + this.getPageStartIndex() + ", " + this.getFetchSize();
        } else {
            this._pagingBindingLimit = this.getFetchSize();
            this._pagingBindingOffset = this.getPageStartIndex();
            this._fetchScopeSqlSuffix = " limit /*pmb.sqlClause.pagingBindingOffset*/0, /*pmb.sqlClause.pagingBindingLimit*/0";
        }
    }

    @Override
    protected void doClearFetchPageClause() {
        this._fetchScopeSqlSuffix = "";
    }

    @Override
    public void lockForUpdate() {
        this._lockSqlSuffix = " for update";
    }

    @Override
    protected String createSelectHint() {
        StringBuilder sb = new StringBuilder();
        if (this.canSqlCalcFoundRows()) {
            sb.append(" sql_calc_found_rows");
        }
        return sb.toString();
    }

    protected boolean canSqlCalcFoundRows() {
        return this.isFetchNarrowingEffective() && this.canPagingCountLater() && this.isSelectClauseNonUnionSelect();
    }

    @Override
    protected String createFromBaseTableHint() {
        return "";
    }

    @Override
    protected String createFromHint() {
        return "";
    }

    @Override
    protected String createSqlSuffix() {
        return this._fetchScopeSqlSuffix + this._lockSqlSuffix;
    }

    @Override
    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return false;
    }

    @Override
    protected boolean isUpdateDirectJoinSupported() {
        return true;
    }

    @Override
    protected boolean isUpdateTableAliasNameSupported() {
        return true;
    }

    @Override
    protected boolean isDeleteTableAliasHintSupported() {
        return true;
    }

    public String buildMatchCondition(List<ColumnInfo> textColumnList, String conditionValue, WayOfMySQL.FullTextSearchModifier modifier, String tableDbName, String aliasName) {
        this.assertTextColumnList(textColumnList);
        this.assertVariousTextSearchResource(conditionValue, modifier, tableDbName, aliasName);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (ColumnInfo columnInfo : textColumnList) {
            if (columnInfo == null) continue;
            this.assertTextColumnTable(tableDbName, columnInfo);
            this.assertTextColumnType(tableDbName, columnInfo);
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (index > 0) {
                sb.append(",");
            }
            sb.append(aliasName).append(".").append(columnSqlName);
            ++index;
        }
        sb.insert(0, "match(").append(") against ('");
        sb.append(this.escapeMatchConditionValue(conditionValue)).append("'");
        if (modifier != null) {
            sb.append(" ").append(modifier.code());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String escapeMatchConditionValue(String conditionValue) {
        conditionValue = Srl.replace(conditionValue, "\\", "\\\\");
        conditionValue = Srl.replace(conditionValue, "'", "''");
        return conditionValue;
    }

    protected void assertTextColumnList(List<ColumnInfo> textColumnList) {
        if (textColumnList == null) {
            String msg = "The argument 'textColumnList' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (textColumnList.isEmpty()) {
            String msg = "The argument 'textColumnList' should not be empty list.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertVariousTextSearchResource(String conditionValue, WayOfMySQL.FullTextSearchModifier modifier, String tableDbName, String aliasName) {
        if (conditionValue == null || conditionValue.length() == 0) {
            String msg = "The argument 'conditionValue' should not be null or empty: " + conditionValue;
            throw new IllegalArgumentException(msg);
        }
        if (tableDbName == null || tableDbName.trim().length() == 0) {
            String msg = "The argument 'tableDbName' should not be null or trimmed-empty: " + tableDbName;
            throw new IllegalArgumentException(msg);
        }
        if (aliasName == null || aliasName.trim().length() == 0) {
            String msg = "The argument 'aliasName' should not be null or trimmed-empty: " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertTextColumnTable(String tableDbName, ColumnInfo columnInfo) {
        String tableOfColumn = columnInfo.getDBMeta().getTableDbName();
        if (!tableOfColumn.equalsIgnoreCase(tableDbName)) {
            String msg = "The table of the text column should be '" + tableDbName + "'";
            msg = msg + " but the table is '" + tableOfColumn + "': column=" + columnInfo;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertTextColumnType(String tableDbName, ColumnInfo columnInfo) {
        if (!columnInfo.isObjectNativeTypeString()) {
            String msg = "The text column should be String type: column=" + columnInfo;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public boolean isCursorSelectByPagingAllowed() {
        return true;
    }

    @Override
    public DBWay dbway() {
        return DBDef.MySQL.dbway();
    }

    public Integer getPagingBindingLimit() {
        return this._pagingBindingLimit;
    }

    public Integer getPagingBindingOffset() {
        return this._pagingBindingOffset;
    }

    public SqlClauseMySql suppressPagingBinding() {
        this._suppressPagingBinding = true;
        return this;
    }

    public static class CollateUTF8MB4UnicodeArranger
    implements QueryClauseArranger {
        @Override
        public String arrange(ColumnRealName columnRealName, String operand, String bindExpression, String rearOption) {
            return columnRealName + " collate utf8mb4_unicode_520_ci " + operand + " " + bindExpression + rearOption;
        }
    }

    public static class CollateUTF8GeneralArranger
    implements QueryClauseArranger {
        @Override
        public String arrange(ColumnRealName columnRealName, String operand, String bindExpression, String rearOption) {
            return columnRealName + " collate utf8_general_ci " + operand + " " + bindExpression + rearOption;
        }
    }

    public static class CollateUTF8UnicodeArranger
    implements QueryClauseArranger {
        @Override
        public String arrange(ColumnRealName columnRealName, String operand, String bindExpression, String rearOption) {
            return columnRealName + " collate utf8_unicode_ci " + operand + " " + bindExpression + rearOption;
        }
    }
}

