/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileURL {
    protected final String _address;

    public FileURL(String address) {
        if (address == null) {
            String msg = "The argument 'address' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._address = address;
    }

    public void download(String toFilePath) {
        URL url = this.createURL();
        this.doDownloadFileAndClose(url, toFilePath);
    }

    protected void doDownloadFileAndClose(URL url, String toFilePath) {
        InputStream in;
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            String msg = "Failed to open stream: url=" + url;
            throw new IllegalStateException(msg, e);
        }
        this.doDownloadFileAndClose(in, toFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDownloadFileAndClose(InputStream ins, String toFilePath) {
        FileOutputStream ous;
        byte[] bytes;
        try {
            bytes = this.toBytes(ins);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException e) {
                String msg = "Failed to close the input stream: ins=" + ins;
                throw new IllegalStateException(msg, e);
            }
        }
        File outputFile = new File(toFilePath);
        try {
            ous = new FileOutputStream(outputFile, false);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found the file: toFilePath=" + toFilePath;
            throw new IllegalStateException(msg, e);
        }
        try {
            ous.write(bytes);
        }
        catch (IOException e) {
            String msg = "Failed to write the byte data: toFilePath=" + toFilePath;
            throw new IllegalStateException(msg, e);
        }
    }

    protected URL createURL() {
        try {
            return new URL(this._address);
        }
        catch (MalformedURLException e) {
            String msg = "Failed to create the URL instance: address=" + this._address;
            throw new IllegalStateException(msg, e);
        }
    }

    protected byte[] toBytes(InputStream ins) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(ins, out);
        return out.toByteArray();
    }

    protected void copy(InputStream ins, OutputStream ous) {
        try {
            byte[] bytes = new byte[256];
            int length = ins.read(bytes);
            while (length != -1 && length != 0) {
                ous.write(bytes, 0, length);
                length = ins.read(bytes);
            }
        }
        catch (IOException e) {
            String msg = "Failed to copy : ins=" + ins + ", ous=" + ous;
            throw new IllegalStateException(msg, e);
        }
    }
}

