/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.thread.CountDownRaceExecution;
import org.seasar.dbflute.helper.thread.CountDownRaceLatch;
import org.seasar.dbflute.helper.thread.CountDownRaceRunner;
import org.seasar.dbflute.helper.thread.exception.ThreadFireFailureException;

public class CountDownRace {
    private static final Log _log = LogFactory.getLog(CountDownRace.class);
    protected final int _runnerCount;

    public CountDownRace(int runnerCount) {
        if (runnerCount < 1) {
            String msg = "The argument 'runnerCount' should not be minus or zero: " + runnerCount;
            throw new IllegalArgumentException(msg);
        }
        this._runnerCount = runnerCount;
    }

    public void readyGo(CountDownRaceExecution execution) {
        if (execution == null) {
            String msg = "The argument 'execution' should be not null.";
            throw new IllegalArgumentException(msg);
        }
        this.doReadyGo(execution);
    }

    protected void doReadyGo(CountDownRaceExecution execution) {
        ExecutorService service = Executors.newCachedThreadPool();
        CountDownLatch ready = new CountDownLatch(this._runnerCount);
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch goal = new CountDownLatch(this._runnerCount);
        CountDownRaceLatch ourLatch = new CountDownRaceLatch(this._runnerCount);
        Object lockObj = new Object();
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (int i = 0; i < this._runnerCount; ++i) {
            int entryNumber = i + 1;
            Callable<Void> callable = this.createCallable(execution, ready, start, goal, ourLatch, entryNumber, lockObj);
            Future<Void> future = service.submit(callable);
            futureList.add(future);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("...Ready Go! Count Down Race just begun! (runner=" + this._runnerCount + ")"));
        }
        start.countDown();
        try {
            goal.await();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("All runners finished line! (runner=" + this._runnerCount + ")"));
            }
        }
        catch (InterruptedException e) {
            String msg = "goal.await() was interrupted!";
            throw new IllegalStateException(msg, e);
        }
        this.handleFuture(futureList);
    }

    protected void handleFuture(List<Future<Void>> futureList) {
        for (Future<Void> future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                String msg = "future.get() was interrupted!";
                throw new IllegalStateException(msg, e);
            }
            catch (ExecutionException e) {
                String msg = "Failed to fire the thread: " + future;
                throw new ThreadFireFailureException(msg, e.getCause());
            }
        }
    }

    protected Callable<Void> createCallable(final CountDownRaceExecution execution, final CountDownLatch ready, final CountDownLatch start, final CountDownLatch goal, final CountDownRaceLatch ourLatch, final int entryNumber, final Object lockObj) {
        return new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                long threadId = Thread.currentThread().getId();
                try {
                    ready.countDown();
                    try {
                        start.await();
                    }
                    catch (InterruptedException e) {
                        String msg = "start.await() was interrupted: start=" + start;
                        throw new IllegalStateException(msg, e);
                    }
                    RuntimeException cause = null;
                    try {
                        execution.execute(CountDownRace.this.createRunner(threadId, ourLatch, entryNumber, lockObj));
                    }
                    catch (RuntimeException e) {
                        cause = e;
                    }
                    if (cause != null) {
                        throw cause;
                    }
                }
                finally {
                    goal.countDown();
                    ourLatch.reset();
                }
                return null;
            }
        };
    }

    protected CountDownRaceRunner createRunner(long threadId, CountDownRaceLatch ourLatch, int entryNumber, Object lockObj) {
        return new CountDownRaceRunner(threadId, ourLatch, entryNumber, lockObj, this._runnerCount);
    }
}

