/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.infra.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.helper.mapstring.MapListString;

public class DfDatabaseNameMapping {
    private static final DfDatabaseNameMapping _instance = new DfDatabaseNameMapping();
    protected final String _databaseNameMappingString;
    protected final Map<String, Map<String, String>> _databaseNameMappingMap;

    private DfDatabaseNameMapping() {
        StringBuilder sb = new StringBuilder();
        sb.append("map:{");
        sb.append("    ; mysql      = map:{generateName = MySql      ; defName = mysql}");
        sb.append("    ; postgresql = map:{generateName = PostgreSql ; defName = postgresql}");
        sb.append("    ; oracle     = map:{generateName = Oracle     ; defName = oracle}");
        sb.append("    ; db2        = map:{generateName = Db2        ; defName = db2}");
        sb.append("    ; sqlserver  = map:{generateName = SqlServer  ; defName = sqlserver}");
        sb.append("    ; mssql      = map:{generateName = SqlServer  ; defName = sqlserver}");
        sb.append("    ; h2         = map:{generateName = H2         ; defName = h2}");
        sb.append("    ; derby      = map:{generateName = Derby      ; defName = derby}");
        sb.append("    ; sqlite     = map:{generateName = Sqlite     ; defName = sqlite}");
        sb.append("    ; msaccess   = map:{generateName = MsAccess   ; defName = msaccess}");
        sb.append("    ; firebird   = map:{generateName = Firebird   ; defName = firebird}");
        sb.append("    ; sybase     = map:{generateName = Sybase     ; defName = sybase}");
        sb.append("    ; default    = map:{generateName = Default    ; defName = unknown}");
        sb.append("}");
        this._databaseNameMappingString = sb.toString();
        this._databaseNameMappingMap = this.analyze();
    }

    public static DfDatabaseNameMapping getInstance() {
        return _instance;
    }

    protected Map<String, Map<String, String>> analyze() {
        MapListString mapListString = new MapListString();
        Map<String, Object> map = mapListString.generateMap(this._databaseNameMappingString);
        LinkedHashMap<String, Map<String, String>> realMap = new LinkedHashMap<String, Map<String, String>>();
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Map elementMap = (Map)entry.getValue();
            LinkedHashMap<String, String> elementRealMap = new LinkedHashMap<String, String>();
            Set elementEntrySet = elementMap.entrySet();
            Iterator i$ = elementEntrySet.iterator();
            while (i$.hasNext()) {
                Map.Entry object;
                Map.Entry elementEntry = object = i$.next();
                Object elementKey = elementEntry.getKey();
                Object elementValue = elementEntry.getValue();
                elementRealMap.put((String)elementKey, (String)elementValue);
            }
            realMap.put(key, elementRealMap);
        }
        return realMap;
    }

    public Map<String, String> findMapping(String databaseType) {
        Map<String, String> map = this._databaseNameMappingMap.get(databaseType);
        if (map == null) {
            map = this._databaseNameMappingMap.get("default");
        }
        return map;
    }

    public String findGenerateName(String databaseType) {
        Map<String, String> mapping = this.findMapping(databaseType);
        String generateName = mapping.get("generateName");
        if (generateName == null || generateName.trim().length() == 0) {
            String msg = "The database should have its generateName: " + mapping;
            throw new IllegalStateException(msg);
        }
        return generateName;
    }

    public DBDef findDBDef(String databaseType) {
        Map<String, String> mapping = this.findMapping(databaseType);
        String defName = mapping.get("defName");
        if (defName == null || defName.trim().length() == 0) {
            String msg = "The database should have its defName: " + mapping;
            throw new IllegalStateException(msg);
        }
        DBDef dbdef = DBDef.codeOf(defName);
        return dbdef != null ? dbdef : DBDef.Unknown;
    }
}

