/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeImpl;
import org.seasar.dbflute.util.Srl;

public class TnRelationPropertyTypeFactoryImpl
implements TnRelationPropertyTypeFactory {
    protected static final int RELATION_SIZE_CAPACITY = 8;
    protected final Class<?> _localBeanClass;
    protected final TnBeanMetaData _localBeanMetaData;
    protected final TnBeanAnnotationReader _beanAnnotationReader;
    protected final TnBeanMetaDataFactory _beanMetaDataFactory;
    protected final DatabaseMetaData _dbMetaData;
    protected final int _relationNestLevel;
    protected final boolean _stopRelationCreation;
    protected final Class<?> _optionalEntityType;

    public TnRelationPropertyTypeFactoryImpl(Class<?> localBeanClass, TnBeanMetaData localBeanMetaData, TnBeanAnnotationReader beanAnnotationReader, TnBeanMetaDataFactory beanMetaDataFactory, DatabaseMetaData dbMetaData, int relationNestLevel, boolean stopRelationCreation, Class<?> optionalEntityType) {
        this._localBeanClass = localBeanClass;
        this._localBeanMetaData = localBeanMetaData;
        this._beanAnnotationReader = beanAnnotationReader;
        this._beanMetaDataFactory = beanMetaDataFactory;
        this._dbMetaData = dbMetaData;
        this._relationNestLevel = relationNestLevel;
        this._stopRelationCreation = stopRelationCreation;
        this._optionalEntityType = optionalEntityType;
    }

    @Override
    public TnRelationPropertyType[] createRelationPropertyTypes() {
        ArrayList<TnRelationPropertyType> relList = new ArrayList<TnRelationPropertyType>(8);
        DfBeanDesc localBeanDesc = this.getLocalBeanDesc();
        List<String> proppertyNameList = localBeanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            DfPropertyDesc propertyDesc = localBeanDesc.getPropertyDesc(proppertyName);
            if (this._stopRelationCreation || !this.isRelationProperty(propertyDesc)) continue;
            relList.add(this.createRelationPropertyType(propertyDesc));
        }
        return relList.toArray(new TnRelationPropertyType[relList.size()]);
    }

    protected DfBeanDesc getLocalBeanDesc() {
        return DfBeanDescFactory.getBeanDesc(this._localBeanClass);
    }

    protected boolean isRelationProperty(DfPropertyDesc propertyDesc) {
        return this._beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected TnRelationPropertyType createRelationPropertyType(DfPropertyDesc propertyDesc) {
        String[] yourKeys;
        String[] myKeys;
        int relno = this._beanAnnotationReader.getRelationNo(propertyDesc);
        String relkeys = this._beanAnnotationReader.getRelationKey(propertyDesc);
        if (relkeys != null) {
            List<String> tokenList = Srl.splitListTrimmed(relkeys, ",");
            ArrayList<String> myKeyList = new ArrayList<String>(tokenList.size());
            ArrayList<String> yourKeyList = new ArrayList<String>(tokenList.size());
            for (String token : tokenList) {
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        } else {
            myKeys = new String[]{};
            yourKeys = new String[]{};
        }
        Class<?> propertyType = this.chooseAnalyzedPropertyType(propertyDesc);
        TnBeanMetaData relationBeanMetaData = this.createRelationBeanMetaData(propertyType);
        return this.createRelationPropertyType(propertyDesc, myKeys, yourKeys, relno, relationBeanMetaData);
    }

    protected Class<?> chooseAnalyzedPropertyType(DfPropertyDesc propertyDesc) {
        Class<?> genericType;
        Class<?> propertyType = propertyDesc.getPropertyType();
        if (this._optionalEntityType.isAssignableFrom(propertyType) && (genericType = propertyDesc.getGenericType()) != null) {
            return genericType;
        }
        return propertyType;
    }

    protected TnRelationPropertyType createRelationPropertyType(DfPropertyDesc propertyDesc, String[] myKeys, String[] yourKeys, int relno, TnBeanMetaData relationBeanMetaData) {
        return new TnRelationPropertyTypeImpl(propertyDesc, relno, myKeys, yourKeys, this._localBeanMetaData, relationBeanMetaData);
    }

    protected TnBeanMetaData createRelationBeanMetaData(Class<?> relationBeanClass) {
        int nextRelationNestLevel = this._relationNestLevel + 1;
        return this._beanMetaDataFactory.createBeanMetaData(this._dbMetaData, relationBeanClass, nextRelationNestLevel);
    }
}

