/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.Collection;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentContainsBindSymbolException;
import org.seasar.dbflute.twowaysql.node.LoopInfo;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.twowaysql.node.VariableNode;
import org.seasar.dbflute.util.Srl;

public class EmbeddedVariableNode
extends VariableNode {
    public static final String PREFIX_NORMAL = "$";
    public static final String PREFIX_REPLACE_ONLY = "$$";
    public static final String PREFIX_TERMINAL_DOT = "$.";
    protected final boolean _replaceOnly;
    protected final boolean _terminalDot;

    public EmbeddedVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter, boolean replaceOnly, boolean terminalDot) {
        super(expression, testValue, specifiedSql, blockNullParameter);
        this._replaceOnly = replaceOnly;
        this._terminalDot = terminalDot;
    }

    @Override
    protected void doProcess(CommandContext ctx, ValueAndType valueAndType, LoopInfo loopInfo) {
        Object finalValue = valueAndType.getTargetValue();
        Class<?> finalType = valueAndType.getTargetType();
        if (this.isInScope()) {
            if (finalValue == null) {
                this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
            }
            if (Collection.class.isAssignableFrom(finalType)) {
                this.embedArray(ctx, ((Collection)finalValue).toArray());
            } else if (finalType.isArray()) {
                this.embedArray(ctx, finalValue);
            } else {
                this.throwBindOrEmbeddedCommentInScopeNotListException(valueAndType);
            }
        } else if (finalValue == null) {
            ctx.addSql("null");
        } else if (!(finalValue instanceof String)) {
            String embeddedValue = finalValue.toString();
            if (this.isQuotedScalar()) {
                ctx.addSql(this.quote(embeddedValue));
            } else {
                ctx.addSql(embeddedValue);
            }
        } else {
            String embeddedStr = (String)finalValue;
            this.assertNotContainBindSymbol(embeddedStr);
            if (this.isQuotedScalar()) {
                ctx.addSql(this.quote(embeddedStr));
                if (this.isAcceptableLikeSearch(loopInfo)) {
                    this.setupRearOption(ctx, valueAndType);
                }
            } else {
                Class<?> firstType;
                Object firstValue = valueAndType.getFirstValue();
                boolean bound = this.processDynamicBinding(ctx, firstValue, firstType = valueAndType.getFirstType(), embeddedStr);
                if (!bound) {
                    ctx.addSql(embeddedStr);
                }
            }
        }
        if (this._testValue != null) {
            if (this._replaceOnly) {
                ctx.addSql(this._testValue);
            } else if (this._terminalDot) {
                ctx.addSql("." + Srl.substringFirstRear(this._testValue, "."));
            }
        }
    }

    protected void embedArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        boolean quotedInScope = this.isQuotedInScope();
        ctx.addSql("(");
        int validCount = 0;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (validCount > 0) {
                ctx.addSql(", ");
            }
            String currentStr = currentElement.toString();
            this.assertNotContainBindSymbol(currentStr);
            if (quotedInScope) {
                ctx.addSql(this.quote(currentStr));
            } else {
                ctx.addSql(currentStr);
            }
            ++validCount;
        }
        if (validCount == 0) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        ctx.addSql(")");
    }

    protected void assertNotContainBindSymbol(String value) {
        if (this.containsBindSymbol(value)) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The value of embedded comment contained bind symbols.");
            br.addItem("Advice");
            br.addElement("The value of embedded comment should not contain bind symbols.");
            br.addElement("For example, a question mark '?'.");
            br.addItem("Comment Expression");
            br.addElement(this._expression);
            br.addItem("Embedded Value");
            br.addElement(value);
            String msg = br.buildExceptionMessage();
            throw new EmbeddedVariableCommentContainsBindSymbolException(msg);
        }
    }

    protected boolean containsBindSymbol(String value) {
        return value.indexOf("?") > -1;
    }

    protected String quote(String value) {
        return "'" + value + "'";
    }

    protected boolean isQuotedScalar() {
        if (this._testValue == null) {
            return false;
        }
        return Srl.count(this._testValue, "'") > 1 && this._testValue.startsWith("'") && this._testValue.endsWith("'");
    }

    protected boolean isQuotedInScope() {
        if (!this.isInScope()) {
            return false;
        }
        return Srl.count(this._testValue, "'") > 1;
    }

    protected boolean processDynamicBinding(CommandContext ctx, Object firstValue, Class<?> firstType, String embeddedString) {
        Srl.ScopeInfo first = Srl.extractScopeFirst(embeddedString, "/*", "*/");
        if (first == null) {
            return false;
        }
        SqlAnalyzer analyzer = new SqlAnalyzer(embeddedString, this._blockNullParameter);
        Node rootNode = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(new String[]{"pmb"}, new Class[]{firstType});
        CommandContext rootCtx = creator.createCommandContext(new Object[]{firstValue});
        rootNode.accept(rootCtx);
        String sql = rootCtx.getSql();
        ctx.addSql(sql, rootCtx.getBindVariables(), rootCtx.getBindVariableTypes());
        return true;
    }

    @Override
    protected ValueAndTypeSetupper.CommentType getCommentType() {
        return ValueAndTypeSetupper.CommentType.EMBEDDED;
    }
}

