/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

enum Transformer {
    NONE,
    ARRAY{

        @Override
        boolean apply(Object candidate) {
            return candidate != null && candidate.getClass().isArray();
        }

        @Override
        public Object doTransform(Object candidate) {
            List<Object> list = Arrays.asList((Object[])candidate);
            return list;
        }
    };

    private static final EnumSet<Transformer> transformers;

    boolean apply(Object candidate) {
        return false;
    }

    Object doTransform(Object candidate) {
        return candidate;
    }

    public static Object transform(Object canidate) {
        return Transformer.get(canidate).doTransform(canidate);
    }

    private static Transformer get(Object candidate) {
        for (Transformer transformer : transformers) {
            if (!transformer.apply(candidate)) continue;
            return transformer;
        }
        return NONE;
    }

    static {
        transformers = EnumSet.allOf(Transformer.class);
        transformers.remove((Object)NONE);
    }
}

