/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.PivotFacetField;
import org.apache.solr.handler.component.PivotFacetValue;
import org.apache.solr.handler.component.ResponseBuilder;

public class PivotFacet
extends FacetComponent.FacetBase {
    public static final String REFINE_PARAM = "fpt";
    public final BitSet knownShards = new BitSet();
    private final Map<Integer, List<PivotFacetValue>> queuedRefinements = new HashMap<Integer, List<PivotFacetValue>>();
    private PivotFacetField pivotFacetField;

    public PivotFacet(ResponseBuilder rb, String facetStr) {
        super(rb, "facet.pivot", facetStr);
    }

    public void addRefinement(int shardNumber, PivotFacetValue value) {
        if (!this.queuedRefinements.containsKey(shardNumber)) {
            this.queuedRefinements.put(shardNumber, new ArrayList());
        }
        this.queuedRefinements.get(shardNumber).add(value);
    }

    public List<PivotFacetValue> getQueuedRefinements(int shardNumber) {
        List<PivotFacetValue> raw = this.queuedRefinements.get(shardNumber);
        if (null == raw) {
            raw = Collections.emptyList();
        }
        return Collections.unmodifiableList(raw);
    }

    public void removeAllRefinementsForShard(int shardNumber) {
        this.queuedRefinements.remove(shardNumber);
    }

    public boolean isRefinementsRequired() {
        return !this.queuedRefinements.isEmpty();
    }

    public List<NamedList<Object>> getTrimmedPivotsAsListOfNamedLists(ResponseBuilder rb) {
        if (null == this.pivotFacetField) {
            return Collections.emptyList();
        }
        this.pivotFacetField.trim();
        return this.pivotFacetField.convertToListOfNamedLists();
    }

    public void queuePivotRefinementRequests() {
        if (null == this.pivotFacetField) {
            return;
        }
        this.pivotFacetField.sort();
        this.pivotFacetField.queuePivotRefinementRequests(this);
    }

    public void mergeResponseFromShard(int shardNumber, ResponseBuilder rb, List<NamedList<Object>> response) {
        this.knownShards.set(shardNumber);
        if (this.pivotFacetField == null) {
            this.pivotFacetField = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, null, response);
        } else {
            this.pivotFacetField.contributeFromShard(shardNumber, rb, response);
        }
    }

    public String toString() {
        return "[" + this.facetStr + "] | " + this.getKey();
    }
}

