/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.solr.store.blockcache.CustomBufferedIndexInput;
import org.apache.solr.store.hdfs.HdfsFileReader;
import org.apache.solr.store.hdfs.HdfsFileWriter;
import org.apache.solr.store.hdfs.NullIndexOutput;
import org.apache.solr.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsDirectory
extends BaseDirectory {
    public static Logger LOG = LoggerFactory.getLogger(HdfsDirectory.class);
    public static final int BUFFER_SIZE = 8192;
    private static final String LF_EXT = ".lf";
    protected static final String SEGMENTS_GEN = "segments.gen";
    protected Path hdfsDirPath;
    protected Configuration configuration;
    private final FileSystem fileSystem;

    public HdfsDirectory(Path hdfsDirPath, Configuration configuration) throws IOException {
        this.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
        this.hdfsDirPath = hdfsDirPath;
        this.configuration = configuration;
        this.fileSystem = FileSystem.newInstance((URI)hdfsDirPath.toUri(), (Configuration)configuration);
        while (true) {
            try {
                if (!this.fileSystem.exists(hdfsDirPath)) {
                    boolean success = this.fileSystem.mkdirs(hdfsDirPath);
                    if (success) break;
                    throw new RuntimeException("Could not create directory: " + hdfsDirPath);
                }
                this.fileSystem.mkdirs(hdfsDirPath);
            }
            catch (RemoteException e) {
                if (e.getClassName().equals("org.apache.hadoop.hdfs.server.namenode.SafeModeException")) {
                    LOG.warn("The NameNode is in SafeMode - Solr will wait 5 seconds and try again.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.interrupted();
                    }
                    continue;
                }
                IOUtils.closeQuietly((Closeable)this.fileSystem);
                throw new RuntimeException("Problem creating directory: " + hdfsDirPath, e);
            }
            catch (Exception e) {
                IOUtils.closeQuietly((Closeable)this.fileSystem);
                throw new RuntimeException("Problem creating directory: " + hdfsDirPath, e);
            }
            break;
        }
    }

    public void close() throws IOException {
        LOG.info("Closing hdfs directory {}", (Object)this.hdfsDirPath);
        this.fileSystem.close();
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        if (SEGMENTS_GEN.equals(name)) {
            return new NullIndexOutput();
        }
        return new HdfsFileWriter(this.getFileSystem(), new Path(this.hdfsDirPath, name));
    }

    private String[] getNormalNames(List<String> files) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            String str = files.get(i);
            files.set(i, this.toNormalName(str));
        }
        return files.toArray(new String[0]);
    }

    private String toNormalName(String name) {
        if (name.endsWith(LF_EXT)) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.openInput(name, 8192);
    }

    private IndexInput openInput(String name, int bufferSize) throws IOException {
        return new HdfsIndexInput(name, this.getFileSystem(), new Path(this.hdfsDirPath, name), 8192);
    }

    public void deleteFile(String name) throws IOException {
        Path path = new Path(this.hdfsDirPath, name);
        LOG.debug("Deleting {}", (Object)path);
        this.getFileSystem().delete(path, false);
    }

    public boolean fileExists(String name) throws IOException {
        return this.getFileSystem().exists(new Path(this.hdfsDirPath, name));
    }

    public long fileLength(String name) throws IOException {
        return HdfsFileReader.getLength(this.getFileSystem(), new Path(this.hdfsDirPath, name));
    }

    public long fileModified(String name) throws IOException {
        FileStatus fileStatus = this.getFileSystem().getFileStatus(new Path(this.hdfsDirPath, name));
        return fileStatus.getModificationTime();
    }

    public String[] listAll() throws IOException {
        FileStatus[] listStatus = this.getFileSystem().listStatus(this.hdfsDirPath);
        ArrayList<String> files = new ArrayList<String>();
        if (listStatus == null) {
            return new String[0];
        }
        for (FileStatus status : listStatus) {
            if (status.isDirectory()) continue;
            files.add(status.getPath().getName());
        }
        return this.getNormalNames(files);
    }

    public Path getHdfsDirPath() {
        return this.hdfsDirPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void sync(Collection<String> names) throws IOException {
        LOG.debug("Sync called on {}", (Object)Arrays.toString(names.toArray()));
    }

    static class HdfsIndexInput
    extends CustomBufferedIndexInput {
        public static Logger LOG = LoggerFactory.getLogger(HdfsIndexInput.class);
        private final Path path;
        private final FSDataInputStream inputStream;
        private final long length;
        private boolean clone = false;

        public HdfsIndexInput(String name, FileSystem fileSystem, Path path, int bufferSize) throws IOException {
            super(name);
            this.path = path;
            LOG.debug("Opening normal index input on {}", (Object)path);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            this.length = fileStatus.getLen();
            this.inputStream = fileSystem.open(path, bufferSize);
        }

        @Override
        protected void readInternal(byte[] b, int offset, int length) throws IOException {
            this.inputStream.readFully(this.getFilePointer(), b, offset, length);
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
        }

        @Override
        protected void closeInternal() throws IOException {
            LOG.debug("Closing normal index input on {}", (Object)this.path);
            if (!this.clone) {
                this.inputStream.close();
            }
        }

        public long length() {
            return this.length;
        }

        @Override
        public IndexInput clone() {
            HdfsIndexInput clone = (HdfsIndexInput)super.clone();
            clone.clone = true;
            return clone;
        }
    }
}

