/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBasedVersionConstraintsProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
UpdateRequestProcessorFactory.RunAlways {
    public static final Logger log = LoggerFactory.getLogger(DocBasedVersionConstraintsProcessorFactory.class);
    private boolean ignoreOldUpdates = false;
    private String versionField = null;
    private String deleteVersionParamName = null;
    private boolean useFieldCache;

    @Override
    public void init(NamedList args) {
        Object tmp = args.remove("versionField");
        if (null == tmp) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'versionField' must be configured");
        }
        if (!(tmp instanceof String)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'versionField' must be configured as a <str>");
        }
        this.versionField = tmp.toString();
        tmp = args.remove("deleteVersionParam");
        if (null != tmp) {
            if (!(tmp instanceof String)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'deleteVersionParam' must be configured as a <str>");
            }
            this.deleteVersionParamName = tmp.toString();
        }
        if (null != (tmp = args.remove("ignoreOldUpdates"))) {
            if (!(tmp instanceof Boolean)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'ignoreOldUpdates' must be configured as a <bool>");
            }
            this.ignoreOldUpdates = (Boolean)tmp;
        }
        super.init(args);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new DocBasedVersionConstraintsProcessor(this.versionField, this.ignoreOldUpdates, this.deleteVersionParamName, this.useFieldCache, req, rsp, next);
    }

    @Override
    public void inform(SolrCore core) {
        if (core.getUpdateHandler().getUpdateLog() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "updateLog must be enabled.");
        }
        if (core.getLatestSchema().getUniqueKeyField() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "schema must have uniqueKey defined.");
        }
        SchemaField userVersionField = core.getLatestSchema().getField(this.versionField);
        if (userVersionField == null || !userVersionField.stored() || userVersionField.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "field " + this.versionField + " must be defined in schema, be stored, and be single valued.");
        }
        try {
            ValueSource vs = userVersionField.getType().getValueSource(userVersionField, null);
            this.useFieldCache = true;
        }
        catch (Exception e) {
            log.warn("Can't use fieldcache/valuesource: " + e.getMessage());
        }
    }

    private static class DocBasedVersionConstraintsProcessor
    extends UpdateRequestProcessor {
        private final String versionFieldName;
        private final SchemaField userVersionField;
        private final SchemaField solrVersionField;
        private final boolean ignoreOldUpdates;
        private final String deleteVersionParamName;
        private final SolrCore core;
        private long oldSolrVersion;
        private DistributedUpdateProcessor distribProc;
        private DistributedUpdateProcessor.DistribPhase phase;
        private boolean useFieldCache;

        public DocBasedVersionConstraintsProcessor(String versionField, boolean ignoreOldUpdates, String deleteVersionParamName, boolean useFieldCache, SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
            super(next);
            this.ignoreOldUpdates = ignoreOldUpdates;
            this.deleteVersionParamName = deleteVersionParamName;
            this.core = req.getCore();
            this.versionFieldName = versionField;
            this.userVersionField = this.core.getLatestSchema().getField(versionField);
            this.solrVersionField = this.core.getLatestSchema().getField("_version_");
            this.useFieldCache = useFieldCache;
            UpdateRequestProcessor proc = next;
            while (proc != null) {
                if (proc instanceof DistributedUpdateProcessor) {
                    this.distribProc = (DistributedUpdateProcessor)proc;
                    break;
                }
                proc = proc.next;
            }
            if (this.distribProc == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "DistributedUpdateProcessor must follow DocBasedVersionConstraintsProcessor");
            }
            this.phase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        }

        private Object convertFieldValueUsingType(SchemaField sf, Object rawValue) {
            if (rawValue instanceof CharSequence) {
                FieldType fieldType = this.userVersionField.getType();
                BytesRef term = new BytesRef();
                fieldType.readableToIndexed((CharSequence)rawValue, term);
                return fieldType.toObject(this.userVersionField, term);
            }
            return rawValue;
        }

        private boolean isVersionNewEnough(BytesRef indexedDocId, Object newUserVersion) throws IOException {
            assert (null != indexedDocId);
            assert (null != newUserVersion);
            this.oldSolrVersion = -1L;
            newUserVersion = this.convertFieldValueUsingType(this.userVersionField, newUserVersion);
            Object oldUserVersion = null;
            SolrInputDocument oldDoc = null;
            if (this.useFieldCache) {
                oldDoc = RealTimeGetComponent.getInputDocumentFromTlog(this.core, indexedDocId);
                if (oldDoc == RealTimeGetComponent.DELETED) {
                    return true;
                }
                if (oldDoc == null) {
                    RefCounted<SolrIndexSearcher> newestSearcher = this.core.getRealtimeSearcher();
                    try {
                        SolrIndexSearcher searcher = newestSearcher.get();
                        long lookup = searcher.lookupId(indexedDocId);
                        if (lookup < 0L) {
                            boolean bl = true;
                            return bl;
                        }
                        ValueSource vs = this.solrVersionField.getType().getValueSource(this.solrVersionField, null);
                        Map context = ValueSource.newContext((IndexSearcher)searcher);
                        vs.createWeight(context, (IndexSearcher)searcher);
                        FunctionValues fv = vs.getValues(context, (AtomicReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
                        this.oldSolrVersion = fv.longVal((int)lookup);
                        vs = this.userVersionField.getType().getValueSource(this.userVersionField, null);
                        context = ValueSource.newContext((IndexSearcher)searcher);
                        vs.createWeight(context, (IndexSearcher)searcher);
                        fv = vs.getValues(context, (AtomicReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
                        oldUserVersion = fv.objectVal((int)lookup);
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
                    }
                    finally {
                        if (newestSearcher != null) {
                            newestSearcher.decref();
                        }
                    }
                }
            } else {
                oldDoc = RealTimeGetComponent.getInputDocument(this.core, indexedDocId);
                if (null == oldDoc) {
                    return true;
                }
            }
            if (oldDoc != null) {
                oldUserVersion = oldDoc.getFieldValue(this.versionFieldName);
                oldUserVersion = this.convertFieldValueUsingType(this.userVersionField, oldUserVersion);
                Object o = oldDoc.getFieldValue(this.solrVersionField.getName());
                if (o == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No _version_ for document " + oldDoc);
                }
                long l = this.oldSolrVersion = o instanceof Number ? ((Number)o).longValue() : Long.parseLong(o.toString());
            }
            if (null == oldUserVersion) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Doc exists in index, but has null versionField: " + this.versionFieldName);
            }
            if (!(oldUserVersion instanceof Comparable) || !(newUserVersion instanceof Comparable)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "old version and new version are not comparable: " + oldUserVersion.getClass() + " vs " + newUserVersion.getClass());
            }
            try {
                if (0 < ((Comparable)newUserVersion).compareTo((Comparable)oldUserVersion)) {
                    return true;
                }
                if (this.ignoreOldUpdates) {
                    if (log.isDebugEnabled()) {
                        log.debug("Dropping update since user version is not high enough: " + newUserVersion + "; old user version=" + oldUserVersion);
                    }
                    return false;
                }
                throw new SolrException(SolrException.ErrorCode.CONFLICT, "user version is not high enough: " + newUserVersion);
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "old version and new version are not comparable: " + oldUserVersion.getClass() + " vs " + newUserVersion.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }

        public boolean isLeader(UpdateCommand cmd) {
            if ((cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
                return false;
            }
            if (this.phase == DistributedUpdateProcessor.DistribPhase.FROMLEADER) {
                return false;
            }
            boolean x = this.distribProc.isLeader(cmd);
            return x;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (!this.isLeader(cmd)) {
                super.processAdd(cmd);
                return;
            }
            SolrInputDocument newDoc = cmd.getSolrInputDocument();
            Object newVersion = newDoc.getFieldValue(this.versionFieldName);
            if (null == newVersion) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc does not have versionField: " + this.versionFieldName);
            }
            int i = 0;
            while (true) {
                if ((i & 0xFF) == 255) {
                    log.warn("Unusual number of optimistic concurrency retries: retries=" + i + " cmd=" + cmd);
                }
                if (!this.isVersionNewEnough(cmd.getIndexedId(), newVersion)) {
                    return;
                }
                try {
                    cmd.setVersion(this.oldSolrVersion);
                    super.processAdd(cmd);
                    return;
                }
                catch (SolrException e) {
                    if (e.code() != 409) {
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }

        @Override
        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            if (null == this.deleteVersionParamName) {
                super.processDelete(cmd);
                return;
            }
            if (!cmd.isDeleteById()) {
                super.processDelete(cmd);
                return;
            }
            String deleteParamValue = cmd.getReq().getParams().get(this.deleteVersionParamName);
            if (null == deleteParamValue) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Delete by ID must specify doc version param: " + this.deleteVersionParamName);
            }
            if (!this.isLeader(cmd)) {
                SolrInputDocument newDoc = new SolrInputDocument();
                newDoc.setField(this.core.getLatestSchema().getUniqueKeyField().getName(), (Object)cmd.getId());
                newDoc.setField(this.versionFieldName, (Object)deleteParamValue);
                AddUpdateCommand newCmd = new AddUpdateCommand(cmd.getReq());
                newCmd.solrDoc = newDoc;
                newCmd.commitWithin = cmd.commitWithin;
                super.processAdd(newCmd);
                return;
            }
            int i = 0;
            while (true) {
                if ((i & 0xFF) == 255) {
                    log.warn("Unusual number of optimistic concurrency retries: retries=" + i + " cmd=" + cmd);
                }
                if (!this.isVersionNewEnough(cmd.getIndexedId(), deleteParamValue)) {
                    return;
                }
                try {
                    SolrInputDocument newDoc = new SolrInputDocument();
                    newDoc.setField(this.core.getLatestSchema().getUniqueKeyField().getName(), (Object)cmd.getId());
                    newDoc.setField(this.versionFieldName, (Object)deleteParamValue);
                    AddUpdateCommand newCmd = new AddUpdateCommand(cmd.getReq());
                    newCmd.solrDoc = newDoc;
                    newCmd.commitWithin = cmd.commitWithin;
                    newCmd.setVersion(this.oldSolrVersion);
                    super.processAdd(newCmd);
                    return;
                }
                catch (SolrException e) {
                    if (e.code() != 409) {
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
    }
}

