/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.solr.util.stats.Clock;
import org.apache.solr.util.stats.Histogram;
import org.apache.solr.util.stats.Meter;
import org.apache.solr.util.stats.Snapshot;
import org.apache.solr.util.stats.TimerContext;

public class Timer {
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final Meter meter;
    private final Histogram histogram = new Histogram(Histogram.SampleType.BIASED);
    private final Clock clock;

    public Timer() {
        this(TimeUnit.MILLISECONDS, TimeUnit.SECONDS, Clock.defaultClock());
    }

    public Timer(TimeUnit durationUnit, TimeUnit rateUnit, Clock clock) {
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
        this.meter = new Meter("calls", rateUnit, clock);
        this.clock = clock;
        this.clear();
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public void clear() {
        this.histogram.clear();
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public TimerContext time() {
        return new TimerContext(this, this.clock);
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public double getMax() {
        return this.convertFromNS(this.histogram.getMax());
    }

    public double getMin() {
        return this.convertFromNS(this.histogram.getMin());
    }

    public double getMean() {
        return this.convertFromNS(this.histogram.getMean());
    }

    public double getStdDev() {
        return this.convertFromNS(this.histogram.getStdDev());
    }

    public double getSum() {
        return this.convertFromNS(this.histogram.getSum());
    }

    public Snapshot getSnapshot() {
        double[] values = this.histogram.getSnapshot().getValues();
        double[] converted = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = this.convertFromNS(values[i]);
        }
        return new Snapshot(converted);
    }

    public String getEventType() {
        return this.meter.getEventType();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    private double convertFromNS(double ns) {
        return ns / (double)TimeUnit.NANOSECONDS.convert(1L, this.durationUnit);
    }
}

