/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.pagenavi.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codelibs.robot.dbflute.cbean.pagenavi.PageNumberLink;
import org.codelibs.robot.dbflute.cbean.pagenavi.PageNumberLinkSetupper;
import org.codelibs.robot.dbflute.cbean.pagenavi.group.PageGroupOption;

public class PageGroupBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int _currentPageNumber;
    protected int _allPageCount;
    protected PageGroupOption _pageGroupOption;
    protected List<Integer> _cachedPageNumberList;

    public <LINK extends PageNumberLink> List<LINK> buildPageNumberLinkList(PageNumberLinkSetupper<LINK> pageNumberLinkSetupper) {
        List<Integer> pageNumberList = this.createPageNumberList();
        ArrayList<LINK> pageNumberLinkList = new ArrayList<LINK>();
        for (Integer pageNumber : pageNumberList) {
            pageNumberLinkList.add(pageNumberLinkSetupper.setup(pageNumber, pageNumber.equals(this._currentPageNumber)));
        }
        return pageNumberLinkList;
    }

    public List<Integer> createPageNumberList() {
        this.assertPageGroupValid();
        if (this._cachedPageNumberList != null) {
            return this._cachedPageNumberList;
        }
        int pageGroupSize = this._pageGroupOption.getPageGroupSize();
        int allPageCount = this._allPageCount;
        int currentPageGroupStartPageNumber = this.calculateStartPageNumber();
        if (currentPageGroupStartPageNumber <= 0) {
            String msg = "currentPageGroupStartPageNumber should be greater than 0. {> 0} But:";
            msg = msg + " currentPageGroupStartPageNumber=" + currentPageGroupStartPageNumber;
            throw new IllegalStateException(msg);
        }
        int nextPageGroupStartPageNumber = currentPageGroupStartPageNumber + pageGroupSize;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = currentPageGroupStartPageNumber; i < nextPageGroupStartPageNumber && i <= allPageCount; ++i) {
            resultList.add(i);
        }
        this._cachedPageNumberList = resultList;
        return this._cachedPageNumberList;
    }

    protected int calculateStartPageNumber() {
        int currentPageGroupStartPageNumber;
        this.assertPageGroupValid();
        int pageGroupSize = this._pageGroupOption.getPageGroupSize();
        int currentPageNumber = this._currentPageNumber;
        int currentPageGroupNumber = currentPageNumber / pageGroupSize;
        if (currentPageNumber % pageGroupSize == 0) {
            --currentPageGroupNumber;
        }
        if (currentPageNumber < (currentPageGroupStartPageNumber = pageGroupSize * currentPageGroupNumber + 1)) {
            String msg = "currentPageNumber should be greater equal currentPageGroupStartPageNumber. But:";
            msg = msg + " currentPageNumber=" + currentPageNumber;
            msg = msg + " currentPageGroupStartPageNumber=" + currentPageGroupStartPageNumber;
            throw new IllegalStateException(msg);
        }
        return currentPageGroupStartPageNumber;
    }

    public int[] createPageNumberArray() {
        this.assertPageGroupValid();
        return this.convertListToIntArray(this.createPageNumberList());
    }

    public boolean isExistPrePageGroup() {
        this.assertPageGroupValid();
        return this._currentPageNumber > this._pageGroupOption.getPageGroupSize();
    }

    public boolean isExistNextPageGroup() {
        this.assertPageGroupValid();
        int currentStartPageNumber = this.calculateStartPageNumber();
        if (currentStartPageNumber <= 0) {
            String msg = "currentStartPageNumber should be greater than 0. {> 0} But:";
            msg = msg + " currentStartPageNumber=" + currentStartPageNumber;
            throw new IllegalStateException(msg);
        }
        int nextStartPageNumber = currentStartPageNumber + this._pageGroupOption.getPageGroupSize();
        return nextStartPageNumber <= this._allPageCount;
    }

    protected int[] convertListToIntArray(List<Integer> ls) {
        int[] resultArray = new int[ls.size()];
        int arrayIndex = 0;
        int[] arr$ = resultArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int pageNumber;
            resultArray[arrayIndex] = pageNumber = arr$[i$];
            ++arrayIndex;
        }
        return resultArray;
    }

    protected void assertPageGroupValid() {
        if (this._pageGroupOption == null) {
            String msg = "The pageGroupOption should not be null. Please call setPageGroupOption().";
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 0) {
            String msg = "The pageGroupSize should be greater than 1. But the value is zero.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 1) {
            String msg = "The pageGroupSize should be greater than 1. But the value is one.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("currentPageNumber=").append(this._currentPageNumber);
        sb.append(", allPageCount=").append(this._allPageCount);
        sb.append(", pageGroupOption=").append(this._pageGroupOption);
        sb.append("}");
        return sb.toString();
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }

    public void setAllPageCount(int allPageCount) {
        this._allPageCount = allPageCount;
    }

    public void setPageGroupOption(PageGroupOption pageGroupOption) {
        this._pageGroupOption = pageGroupOption;
    }

    public int getPreGroupNearestPageNumber() {
        if (!this.isExistPrePageGroup()) {
            String msg = "The previous page range should exist when you use preGroupNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageGroupOption=" + this._pageGroupOption;
            throw new IllegalStateException(msg);
        }
        return this.createPageNumberList().get(0) - 1;
    }

    public int getNextGroupNearestPageNumber() {
        if (!this.isExistNextPageGroup()) {
            String msg = "The next page range should exist when you use nextGroupNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageGroupOption=" + this._pageGroupOption;
            throw new IllegalStateException(msg);
        }
        List<Integer> ls = this.createPageNumberList();
        return ls.get(ls.size() - 1) + 1;
    }
}

